/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedArrayList<E>
extends ArrayList<E> {
    private Map<Object, Integer> _indexCache;
    private boolean _lazyCaching = false;

    public CachedArrayList() {
    }

    public CachedArrayList(Collection<? extends E> collection) {
        super(collection);
        if (!this.isLazyCaching()) {
            this.cacheAll();
        }
    }

    public CachedArrayList(int n) {
        super(n);
    }

    @Override
    public int indexOf(Object object) {
        this.initializeCache();
        Integer n = this._indexCache.get(object);
        if (n != null) {
            return n;
        }
        if (this.isLazyCaching()) {
            int n2 = super.indexOf(object);
            if (n2 == -1) {
                this.uncacheIt(object);
            } else {
                this.cacheIt(object, n2);
            }
            return n2;
        }
        return -1;
    }

    protected synchronized void adjustCache(int n, int n2) {
        if (this._indexCache != null) {
            Map<Object, Integer> map = this.createCache();
            Set<Object> set = this._indexCache.keySet();
            for (Object object : set) {
                int n3 = this._indexCache.get(object);
                if (n3 >= n) {
                    map.put(object, n3 + n2);
                    continue;
                }
                map.put(object, n3);
            }
            this._indexCache = map;
        }
    }

    protected Map<Object, Integer> createCache() {
        return new IdentityHashMap<Object, Integer>();
    }

    public void cacheIt(Object object, int n) {
        if (this._indexCache != null && (this._indexCache.get(object) == null || n < this._indexCache.get(object))) {
            this._indexCache.put(object, n);
        }
    }

    public void uncacheIt(Object object) {
        if (this._indexCache != null) {
            this._indexCache.remove(object);
        }
    }

    @Override
    public boolean add(E e) {
        boolean bl = super.add(e);
        if (!this.isLazyCaching() && bl) {
            this.initializeCache();
            this.cacheIt(e, this.size() - 1);
        }
        return bl;
    }

    @Override
    public void add(int n, E e) {
        super.add(n, e);
        if (!this.isLazyCaching()) {
            this.initializeCache();
            this.adjustCache(n, 1);
            this.cacheIt(e, n);
        } else if (this._indexCache != null) {
            this.adjustCache(n, 1);
            this.cacheIt(e, n);
        }
    }

    private void initializeCache() {
        if (this._indexCache == null) {
            this._indexCache = this.createCache();
        }
    }

    @Override
    public E remove(int n) {
        Object e = super.remove(n);
        if (e != null) {
            this.uncacheIt(e);
            this.adjustCache(n, -1);
        }
        return e;
    }

    @Override
    public boolean remove(Object object) {
        int n = this.indexOf(object);
        boolean bl = super.remove(object);
        if (bl) {
            this.uncacheIt(object);
            this.adjustCache(n, -1);
        }
        return bl;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        this.uncacheAll();
        return super.removeAll(collection);
    }

    @Override
    public void clear() {
        this.uncacheAll();
        super.clear();
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean bl = super.addAll(collection);
        if (bl) {
            this.cacheAll();
        }
        return bl;
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        boolean bl = super.addAll(n, collection);
        this.initializeCache();
        this.adjustCache(n, collection.size());
        for (E e : collection) {
            this.cacheIt(e, n++);
        }
        return bl;
    }

    @Override
    public E set(int n, E e) {
        if (!this.isLazyCaching()) {
            this.initializeCache();
            E e2 = super.set(n, e);
            this.uncacheIt(e);
            this.cacheIt(e, n);
            return e2;
        }
        return super.set(n, e);
    }

    public void invalidateCache() {
        this.uncacheAll();
    }

    public void uncacheAll() {
        if (this._indexCache != null) {
            this._indexCache.clear();
            this._indexCache = null;
        }
    }

    public void cacheAll() {
        this._indexCache = this.createCache();
        Integer n = 0;
        for (Object e : this) {
            if (this._indexCache.get(e) == null) {
                this._indexCache.put(e, n);
            }
            Integer n2 = n;
            Integer n3 = n = Integer.valueOf(n + 1);
        }
    }

    public boolean isLazyCaching() {
        return this._lazyCaching;
    }

    public void setLazyCaching(boolean bl) {
        this._lazyCaching = bl;
    }

    @Override
    protected void removeRange(int n, int n2) {
        if (n == n2) {
            this.remove(n);
        } else {
            super.removeRange(n, n2);
            this.uncacheAll();
            if (!this.isLazyCaching()) {
                this.cacheAll();
            }
        }
    }
}

