/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.neon.api;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.PrintGraphics;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.print.PrinterGraphics;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.pushingpixels.neon.api.font.FontPolicy;
import org.pushingpixels.neon.api.font.FontSet;
import org.pushingpixels.neon.api.icon.ResizableIcon;
import org.pushingpixels.neon.api.icon.ResizableIconUIResource;
import org.pushingpixels.neon.internal.ColorFilter;
import org.pushingpixels.neon.internal.contrib.intellij.JBHiDPIScaledImage;
import org.pushingpixels.neon.internal.contrib.intellij.UIUtil;
import org.pushingpixels.neon.internal.contrib.jgoodies.looks.LookUtils;
import org.pushingpixels.neon.internal.font.DefaultGnomeFontPolicy;
import org.pushingpixels.neon.internal.font.DefaultKDEFontPolicy;
import org.pushingpixels.neon.internal.font.DefaultMacFontPolicy;
import org.pushingpixels.neon.internal.font.FontPolicies;
import org.pushingpixels.neon.internal.font.FontSets;
import org.pushingpixels.neon.internal.font.NeonFontSet;
import org.pushingpixels.neon.internal.font.ScaledFontSet;

public class NeonCortex {
    private static final String PROP_DESKTOPHINTS = "awt.font.desktophints";
    private static Platform platform;
    private static Map<String, Map> desktopHintsCache;

    public static synchronized Platform getPlatform() {
        if (platform != null) {
            return platform;
        }
        if (LookUtils.IS_OS_WINDOWS) {
            platform = Platform.WINDOWS;
            return platform;
        }
        if (LookUtils.IS_OS_MAC) {
            platform = Platform.MACOS;
            return platform;
        }
        try {
            if (DefaultKDEFontPolicy.isKDERunning()) {
                platform = Platform.KDE;
                return platform;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            PrivilegedAction<String> desktopAction = () -> System.getProperty("sun.desktop");
            String desktop = AccessController.doPrivileged(desktopAction);
            if ("gnome".equals(desktop)) {
                platform = Platform.GNOME;
                return platform;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        platform = Platform.DEFAULT;
        return platform;
    }

    public static FontPolicy getDefaultFontPolicy() {
        FontPolicy defaultPolicy;
        Platform platform = NeonCortex.getPlatform();
        switch (platform) {
            case MACOS: {
                defaultPolicy = new DefaultMacFontPolicy();
                break;
            }
            case KDE: {
                defaultPolicy = new DefaultKDEFontPolicy();
                break;
            }
            case GNOME: {
                defaultPolicy = new DefaultGnomeFontPolicy();
                break;
            }
            case WINDOWS: {
                defaultPolicy = FontPolicies.getDefaultWindowsPolicy();
                break;
            }
            default: {
                defaultPolicy = FontPolicies.getDefaultPlasticPolicy();
            }
        }
        return () -> new NeonFontSet(defaultPolicy.getFontSet());
    }

    public static FontPolicy getScaledFontPolicy(float scaleFactor) {
        FontSet defaultFontSet = NeonCortex.getDefaultFontPolicy().getFontSet();
        return () -> new ScaledFontSet(defaultFontSet, scaleFactor);
    }

    public static BufferedImage createThumbnail(BufferedImage image, int requestedThumbWidth) {
        float ratio = (float)image.getWidth() / (float)image.getHeight();
        int width = image.getWidth();
        BufferedImage thumb = image;
        double scaleFactor = NeonCortex.getScaleFactor();
        do {
            if ((width /= 2) < requestedThumbWidth) {
                width = requestedThumbWidth;
            }
            BufferedImage temp = NeonCortex.getBlankImage(width, (int)((float)width / ratio));
            Graphics2D g2 = temp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2.drawImage(thumb, 0, 0, (int)((double)temp.getWidth() / scaleFactor), (int)((double)temp.getHeight() / scaleFactor), null);
            g2.dispose();
            thumb = temp;
        } while (width != requestedThumbWidth);
        return thumb;
    }

    public static void installDesktopHints(Graphics2D g2, Font font) {
        boolean isDefaultMojaveFont;
        boolean bl = isDefaultMojaveFont = NeonCortex.getPlatform() == Platform.MACOS && LookUtils.IS_OS_MAC_MOJAVE_OR_LATER && g2.getDeviceConfiguration().getDevice().getType() == 0 && font instanceof FontSets.DefaultUIResourceFont;
        if (isDefaultMojaveFont) {
            return;
        }
        Map desktopHints = NeonCortex.desktopHints(g2);
        if (desktopHints != null && !desktopHints.isEmpty()) {
            g2.addRenderingHints(desktopHints);
        }
    }

    public static void clearDesktopHints(Graphics2D g2, Font font) {
        GraphicsDevice device = g2.getDeviceConfiguration().getDevice();
        String deviceId = device.getIDstring();
        desktopHintsCache.remove(deviceId);
    }

    private static Map desktopHints(Graphics2D g2) {
        if (NeonCortex.isPrinting(g2)) {
            return null;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsDevice device = g2.getDeviceConfiguration().getDevice();
        String deviceId = device.getIDstring();
        String key = deviceId;
        if (!desktopHintsCache.containsKey(key)) {
            Object aaHint;
            HashMap desktopHints = (HashMap)toolkit.getDesktopProperty("awt.font.desktophints." + deviceId);
            if (desktopHints == null) {
                desktopHints = (Map)toolkit.getDesktopProperty(PROP_DESKTOPHINTS);
            }
            if (desktopHints != null && ((aaHint = desktopHints.get(RenderingHints.KEY_TEXT_ANTIALIASING)) == RenderingHints.VALUE_TEXT_ANTIALIAS_OFF || aaHint == RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT)) {
                desktopHints = null;
            }
            if (desktopHints == null) {
                desktopHints = new HashMap();
            }
            desktopHintsCache.put(key, desktopHints);
        }
        return desktopHintsCache.get(key);
    }

    private static boolean isPrinting(Graphics g) {
        return g instanceof PrintGraphics || g instanceof PrinterGraphics;
    }

    public static double getScaleFactor() {
        return UIUtil.getScaleFactor();
    }

    public static BufferedImage getBlankImage(int width, int height) {
        if (UIUtil.getScaleFactor() > 1.0) {
            return JBHiDPIScaledImage.create(width, height, 2);
        }
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice d = e.getDefaultScreenDevice();
        GraphicsConfiguration c = d.getDefaultConfiguration();
        return c.createCompatibleImage(width, height, 3);
    }

    public static BufferedImage getBlankUnscaledImage(int width, int height) {
        if (UIUtil.getScaleFactor() > 1.0) {
            return JBHiDPIScaledImage.createUnscaled(width, height, 2);
        }
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice d = e.getDefaultScreenDevice();
        GraphicsConfiguration c = d.getDefaultConfiguration();
        return c.createCompatibleImage(width, height, 3);
    }

    public static void drawImage(Graphics g, Image img, int x, int y) {
        if (img instanceof JBHiDPIScaledImage) {
            double scaleFactor = UIUtil.getScaleFactor();
            g.drawImage(img, x, y, (int)((double)img.getWidth(null) / scaleFactor), (int)((double)img.getHeight(null) / scaleFactor), null);
        } else {
            g.drawImage(img, x, y, img.getWidth(null), img.getHeight(null), null);
        }
    }

    public static void drawImage(Graphics g, Image img, int x, int y, int width, int height, int offsetX, int offsetY) {
        if (img instanceof JBHiDPIScaledImage) {
            double scaleFactor = UIUtil.getScaleFactor();
            g.drawImage(img, x, y, x + width, y + height, x + (int)((double)offsetX * scaleFactor), y + (int)((double)offsetY * scaleFactor), x + (int)((double)(offsetX + width) * scaleFactor), y + (int)((double)(offsetY + height) * scaleFactor), null);
        } else {
            g.drawImage(img, x, y, x + width, y + height, x + offsetX, y + offsetY, x + offsetX + width, y + offsetY + height, null);
        }
    }

    public static ResizableIcon colorizeIcon(final ResizableIcon.Factory sourceFactory, final Color color) {
        return new ResizableIcon(){
            private int width;
            private int height;
            private BufferedImage colorized;

            @Override
            public void setDimension(Dimension newDimension) {
                ResizableIcon original = sourceFactory.createNewIcon();
                original.setDimension(newDimension);
                BufferedImage flat = NeonCortex.getBlankImage(newDimension.width, newDimension.height);
                original.paintIcon(null, flat.getGraphics(), 0, 0);
                this.colorized = new ColorFilter(color).filter(flat, null);
                this.width = newDimension.width;
                this.height = newDimension.height;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.translate(x, y);
                NeonCortex.drawImage(g2d, this.colorized, 0, 0);
                g2d.dispose();
            }

            @Override
            public int getIconWidth() {
                return this.width;
            }

            @Override
            public int getIconHeight() {
                return this.height;
            }
        };
    }

    public static ResizableIcon colorizeIcon(ResizableIcon.Factory sourceFactory, Color color, float alpha) {
        return NeonCortex.colorizeIcon(sourceFactory, new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(alpha * 255.0f)));
    }

    public static ResizableIconUIResource colorizeIconAsUiResource(ResizableIcon.Factory sourceFactory, Color color) {
        return new ResizableIconUIResource(NeonCortex.colorizeIcon(sourceFactory, color));
    }

    public static ResizableIconUIResource colorizeIconAsUiResource(ResizableIcon.Factory sourceFactory, Color color, float alpha) {
        return NeonCortex.colorizeIconAsUiResource(sourceFactory, new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(alpha * 255.0f)));
    }

    static {
        desktopHintsCache = new HashMap<String, Map>();
    }

    public static enum Platform {
        MACOS,
        GNOME,
        KDE,
        WINDOWS,
        DEFAULT;

    }
}

