/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Keymap;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.core.NbPlaces;
import org.netbeans.core.ShortcutsEditor;
import org.netbeans.core.ShortcutsFolder;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.InstanceCookie;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ActionsPanel
extends JPanel {
    private static final ResourceBundle bundle = NbBundle.getBundle((Class)ActionsPanel.class);
    private ShortcutsEditor shortcutsEditor;
    private HashMap actionToNode = new HashMap(41);
    private DefaultTreeModel model;
    private DefaultTreeSelectionModel treeSelectionModel;
    private Action selectedAction;
    private DefaultListModel shortcutsModel;
    private HashMap nameToStroke = new HashMap(11);
    private JPanel actionsPanel;
    private JScrollPane actionsScrollPane;
    private JTree actionsTree;
    private JPanel shortcutPanel;
    private JScrollPane shortcutsScrollPane;
    private JList shortcutsList;
    private JPanel shortcutsButtonsPanel;
    private JButton shortcutAddButton;
    private JButton shortcutRemoveButton;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
    static /* synthetic */ Class class$javax$swing$Action;

    public ActionsPanel(boolean canChangeKey, ShortcutsEditor shortcutsEditor) {
        this.shortcutsEditor = shortcutsEditor;
        this.initComponents();
        this.initAccessibility();
        this.shortcutAddButton.setMnemonic(bundle.getString("ActionsPanel.shortcutAddButton.text_Mnemonic").charAt(0));
        this.shortcutRemoveButton.setMnemonic(bundle.getString("ActionsPanel.shortcutRemoveButton.text_Mnemonic").charAt(0));
        this.shortcutPanel.setBorder(new CompoundBorder(new TitledBorder(new EtchedBorder(), bundle.getString("ActionsPanel.ShortcutsTitle")), new EmptyBorder(new Insets(12, 12, 11, 11))));
        this.shortcutsModel = new DefaultListModel();
        this.shortcutsList.setModel(this.shortcutsModel);
        this.treeSelectionModel = new DefaultTreeSelectionModel();
        this.treeSelectionModel.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                TreeNode node;
                TreePath[] paths = ActionsPanel.this.actionsTree.getSelectionPaths();
                if (paths != null && paths.length == 1 && (node = (TreeNode)paths[0].getLastPathComponent()) != null && node instanceof ActionNode) {
                    ActionsPanel.this.updateSelectedAction(((ActionNode)node).getAction());
                    return;
                }
                ActionsPanel.this.updateSelectedAction(null);
            }
        });
        this.treeSelectionModel.setSelectionMode(1);
        this.model = new DefaultTreeModel(this.createActionsRootNode());
        this.actionsTree.setModel(this.model);
        this.actionsTree.setSelectionModel(this.treeSelectionModel);
        this.actionsTree.setShowsRootHandles(true);
        this.actionsTree.putClientProperty("JTree.lineStyle", "Angled");
        this.updateButtons();
    }

    void setAction(Action action) {
        TreeNode tn = (TreeNode)this.actionToNode.get(action.getClass());
        if (tn != null) {
            TreePath tp = new TreePath(this.model.getPathToRoot(tn));
            this.treeSelectionModel.setSelectionPath(tp);
            this.actionsTree.scrollPathToVisible(tp);
            this.updateSelectedAction(action);
        }
    }

    private void updateSelectedAction(Action action) {
        this.selectedAction = action;
        Keymap map = (Keymap)Lookup.getDefault().lookup(Keymap.class);
        KeyStroke[] strokes = map.getKeyStrokesForAction(action);
        this.shortcutsModel.removeAllElements();
        this.nameToStroke.clear();
        for (int i = 0; i < strokes.length; ++i) {
            String keyName = ShortcutsFolder.getKeyText(strokes[i]);
            this.nameToStroke.put(keyName, strokes[i]);
            this.shortcutsModel.addElement(keyName);
        }
        this.updateButtons();
    }

    private void initComponents() {
        this.actionsPanel = new JPanel();
        this.actionsScrollPane = new JScrollPane();
        this.actionsTree = new JTree();
        this.shortcutPanel = new JPanel();
        this.shortcutsScrollPane = new JScrollPane();
        this.shortcutsList = new JList();
        this.shortcutsButtonsPanel = new JPanel();
        this.shortcutAddButton = new JButton();
        this.shortcutRemoveButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.actionsPanel.setLayout(new BorderLayout());
        this.actionsTree.setRootVisible(false);
        this.actionsScrollPane.setViewportView(this.actionsTree);
        this.actionsPanel.add((Component)this.actionsScrollPane, "Center");
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.add((Component)this.actionsPanel, gridBagConstraints1);
        this.shortcutPanel.setLayout(new GridBagLayout());
        this.shortcutsList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                ActionsPanel.this.shortcutsListValueChanged(evt);
            }
        });
        this.shortcutsScrollPane.setViewportView(this.shortcutsList);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weightx = 1.0;
        this.shortcutPanel.add((Component)this.shortcutsScrollPane, gridBagConstraints2);
        this.shortcutsButtonsPanel.setLayout(new GridBagLayout());
        this.shortcutAddButton.setText(ResourceBundle.getBundle("org/netbeans/core/Bundle").getString("ActionsPanel.shortcutAddButton.text"));
        this.shortcutAddButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActionsPanel.this.shortcutAddButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.fill = 2;
        this.shortcutsButtonsPanel.add((Component)this.shortcutAddButton, gridBagConstraints3);
        this.shortcutRemoveButton.setText(ResourceBundle.getBundle("org/netbeans/core/Bundle").getString("ActionsPanel.shortcutRemoveButton.text"));
        this.shortcutRemoveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActionsPanel.this.shortcutRemoveButtonActionPerformed(evt);
            }
        });
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints3.anchor = 11;
        this.shortcutsButtonsPanel.add((Component)this.shortcutRemoveButton, gridBagConstraints3);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(0, 12, 0, 0);
        this.shortcutPanel.add((Component)this.shortcutsButtonsPanel, gridBagConstraints2);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(12, 0, 0, 0);
        gridBagConstraints1.weightx = 1.0;
        this.add((Component)this.shortcutPanel, gridBagConstraints1);
    }

    private void shortcutRemoveButtonActionPerformed(ActionEvent evt) {
        Object[] selectedItems = this.shortcutsList.getSelectedValues();
        Keymap map = (Keymap)Lookup.getDefault().lookup(Keymap.class);
        for (int i = 0; i < selectedItems.length; ++i) {
            KeyStroke ks = (KeyStroke)this.nameToStroke.get(selectedItems[i]);
            if (ks == null) continue;
            this.shortcutsEditor.removeShortcut(ks, map.getAction(ks));
            map.removeKeyStrokeBinding(ks);
        }
        this.updateSelectedAction(this.selectedAction);
        this.shortcutsEditor.setModified(true);
        this.updateTree();
    }

    private void shortcutAddButtonActionPerformed(ActionEvent evt) {
        KeyStroke existingStroke = null;
        boolean shortcutAccepted = false;
        Keymap map = (Keymap)Lookup.getDefault().lookup(Keymap.class);
        do {
            ShortcutEnterPanel sep = new ShortcutEnterPanel(existingStroke);
            DialogDescriptor dd = new DialogDescriptor((Object)sep, bundle.getString("ActionsPanel.AddShortcut"));
            JDialog addshort = (JDialog)DialogDisplayer.getDefault().createDialog(dd);
            addshort.setVisible(true);
            if (dd.getValue().equals(DialogDescriptor.OK_OPTION)) {
                existingStroke = sep.getShortcut();
                if (existingStroke.getKeyCode() == 0 && existingStroke.getModifiers() == 0) {
                    return;
                }
                Action a = map.getAction(existingStroke);
                if (a != null) {
                    String text = MessageFormat.format(bundle.getString("FMT_ActionsPanel.AlreadyBound"), a.getValue("Name"));
                    NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)text);
                    Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    if (result.equals(NotifyDescriptor.YES_OPTION)) {
                        shortcutAccepted = true;
                        this.shortcutsEditor.removeShortcut(existingStroke, a);
                        continue;
                    }
                    if (!result.equals(NotifyDescriptor.NO_OPTION)) continue;
                    return;
                }
                shortcutAccepted = true;
                continue;
            }
            return;
        } while (!shortcutAccepted);
        map.addActionForKeyStroke(existingStroke, this.selectedAction);
        this.shortcutsEditor.addShortcut(existingStroke, this.selectedAction);
        this.updateSelectedAction(this.selectedAction);
        this.shortcutsEditor.setModified(true);
        this.updateTree();
    }

    private void shortcutsListValueChanged(ListSelectionEvent evt) {
        this.updateButtons();
    }

    private void updateButtons() {
        this.shortcutAddButton.setEnabled(this.selectedAction != null);
        this.shortcutRemoveButton.setEnabled(this.selectedAction != null && this.shortcutsList.getSelectedIndices().length > 0);
    }

    void updateTree() {
        this.actionsTree.setShowsRootHandles(false);
        this.actionsTree.setShowsRootHandles(true);
        this.actionsTree.repaint();
        this.actionsTree.revalidate();
    }

    TreeNode createActionsRootNode() {
        final ArrayList<ActionsGroupNode> actionGroups = new ArrayList<ActionsGroupNode>();
        DataFolder actionsFolder = NbPlaces.getDefault().actions();
        DataObject[] actionsChildren = actionsFolder.getChildren();
        for (int i = 0; i < actionsChildren.length; ++i) {
            if (!(actionsChildren[i] instanceof DataFolder)) continue;
            actionGroups.add(new ActionsGroupNode((DataFolder)actionsChildren[i], null));
        }
        return new TreeNode(){

            public TreeNode getChildAt(int childIndex) {
                return (TreeNode)actionGroups.get(childIndex);
            }

            public int getChildCount() {
                return actionGroups.size();
            }

            public TreeNode getParent() {
                return null;
            }

            public int getIndex(TreeNode node) {
                return actionGroups.indexOf(node);
            }

            public boolean getAllowsChildren() {
                return true;
            }

            public boolean isLeaf() {
                return false;
            }

            public Enumeration children() {
                return Collections.enumeration(actionGroups);
            }
        };
    }

    protected void setFocusDefault() {
        this.actionsTree.requestFocus();
    }

    private void initAccessibility() {
        ResourceBundle bundle = NbBundle.getBundle((Class)ActionsPanel.class);
        this.actionsTree.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_ActionsPanel.actionsTree"));
        this.actionsTree.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ActionsPanel.actionsTree"));
        this.shortcutsList.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_ActionsPanel.shortcutsList"));
        this.shortcutsList.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ActionsPanel.shortcutsList"));
        this.shortcutAddButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_ShortcutsPanel.addButton.text.a11yDesc"));
        this.shortcutRemoveButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_ShortcutsPanel.removeButton.text.a11yDesc"));
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_ActionsPanel"));
    }

    static class ShortcutEnterPanel
    extends JPanel {
        private JLabel shortcutLabel;
        private JTextField shortcutField;
        private KeyStroke defaultStroke;
        private int currentKeyCode;
        private int currentModifiers;

        ShortcutEnterPanel(KeyStroke stroke) {
            this.defaultStroke = stroke;
            this.shortcutLabel = new JLabel(bundle.getString("ActionsPanel.ShortcutLabel"));
            this.shortcutField = new JTextField();
            this.shortcutLabel.setDisplayedMnemonic(bundle.getString("ActionsPanel.ShortcutLabel_Mnemonic").charAt(0));
            this.shortcutLabel.setLabelFor(this.shortcutField);
            this.setLayout(new GridBagLayout());
            this.setBorder(new EmptyBorder(new Insets(8, 8, 8, 8)));
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.insets = new Insets(0, 0, 0, 8);
            this.add((Component)this.shortcutLabel, gridBagConstraints1);
            gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.weightx = 1.0;
            this.add((Component)this.shortcutField, gridBagConstraints1);
            this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ActionsPanel.Dialog"));
            this.shortcutField.addKeyListener(new KeyAdapter(this){
                private final /* synthetic */ ShortcutEnterPanel this$0;
                {
                    this.this$0 = this$0;
                }

                public void keyPressed(KeyEvent evt) {
                    ShortcutEnterPanel.access$700(this.this$0, evt);
                }

                public void keyReleased(KeyEvent evt) {
                    ShortcutEnterPanel.access$800(this.this$0, evt);
                }

                public void keyTyped(KeyEvent evt) {
                    ShortcutEnterPanel.access$900(this.this$0, evt);
                }
            });
            if (this.defaultStroke != null) {
                this.shortcutField.setText(ShortcutsFolder.getKeyText(this.defaultStroke));
                this.currentKeyCode = this.defaultStroke.getKeyCode();
                this.currentModifiers = this.defaultStroke.getModifiers();
            } else {
                this.shortcutField.setText("");
            }
            this.shortcutLabel.setLabelFor(this.shortcutField);
            this.shortcutField.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/core/Bundle").getString("ACS_ActionsPanel.ShortcutLabel.a11yName"));
            this.shortcutField.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/core/Bundle").getString("ACS_ActionsPanel.ShortcutLabel.a11yDesc"));
        }

        public Dimension getPreferredSize() {
            return new Dimension(300, 50);
        }

        KeyStroke getShortcut() {
            return KeyStroke.getKeyStroke(this.currentKeyCode, this.currentModifiers);
        }

        private void shortcutFieldKeyReleased(KeyEvent evt) {
            evt.consume();
            switch (this.currentKeyCode) {
                case 16: 
                case 17: 
                case 18: 
                case 157: 
                case 65406: {
                    if (this.defaultStroke != null) {
                        this.shortcutField.setText(ShortcutsFolder.getKeyText(this.defaultStroke));
                        break;
                    }
                    this.shortcutField.setText("");
                }
            }
        }

        private void shortcutFieldKeyTyped(KeyEvent evt) {
            evt.consume();
        }

        private void shortcutFieldKeyPressed(KeyEvent evt) {
            evt.consume();
            this.currentKeyCode = evt.getKeyCode();
            this.currentModifiers = evt.getModifiers();
            this.shortcutField.setText(ShortcutsFolder.getKeyText(this.currentKeyCode, this.currentModifiers));
        }

        static /* synthetic */ void access$700(ShortcutEnterPanel x0, KeyEvent x1) {
            x0.shortcutFieldKeyPressed(x1);
        }

        static /* synthetic */ void access$800(ShortcutEnterPanel x0, KeyEvent x1) {
            x0.shortcutFieldKeyReleased(x1);
        }

        static /* synthetic */ void access$900(ShortcutEnterPanel x0, KeyEvent x1) {
            x0.shortcutFieldKeyTyped(x1);
        }
    }

    static class ActionNode
    implements TreeNode {
        private final Action action;
        private final DataObject obj;
        private final TreeNode parent;

        ActionNode(DataObject obj, Action action, TreeNode parent) {
            this.action = action;
            this.parent = parent;
            this.obj = obj;
        }

        Action getAction() {
            return this.action;
        }

        public TreeNode getChildAt(int childIndex) {
            return null;
        }

        public int getChildCount() {
            return 0;
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public int getIndex(TreeNode node) {
            return -1;
        }

        public boolean getAllowsChildren() {
            return false;
        }

        public boolean isLeaf() {
            return true;
        }

        public Enumeration children() {
            return null;
        }

        public String toString() {
            return ShortcutsFolder.getActionName(this.action);
        }
    }

    class ActionsGroupNode
    implements TreeNode {
        private DataFolder folder;
        private ArrayList actions;
        private TreeNode parent;

        ActionsGroupNode(DataFolder folder, TreeNode parent) {
            this.folder = folder;
            this.parent = parent;
            DataObject[] children = folder.getChildren();
            this.actions = new ArrayList(children.length);
            for (int i = 0; i < children.length; ++i) {
                InstanceCookie ic = (InstanceCookie)children[i].getCookie(class$org$openide$cookies$InstanceCookie == null ? ActionsPanel.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
                if (ic != null) {
                    try {
                        Class instClass = ic.instanceClass();
                        if ((class$javax$swing$Action == null ? ActionsPanel.class$("javax.swing.Action") : class$javax$swing$Action).isAssignableFrom(instClass)) {
                            ActionNode tn = new ActionNode(children[i], (Action)ic.instanceCreate(), this);
                            ActionsPanel.this.actionToNode.put(instClass, tn);
                            this.actions.add(tn);
                        }
                    }
                    catch (Exception e) {
                        ErrorManager.getDefault().notify(1, (Throwable)e);
                    }
                    catch (LinkageError le) {
                        ErrorManager.getDefault().notify((Throwable)le);
                    }
                }
                if (!(children[i] instanceof DataFolder)) continue;
                ActionsGroupNode tn = new ActionsGroupNode((DataFolder)children[i], this);
                this.actions.add(tn);
            }
        }

        public TreeNode getChildAt(int childIndex) {
            return (TreeNode)this.actions.get(childIndex);
        }

        public int getChildCount() {
            return this.actions.size();
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public int getIndex(TreeNode node) {
            return this.actions.indexOf(node);
        }

        public boolean getAllowsChildren() {
            return true;
        }

        public boolean isLeaf() {
            return false;
        }

        public Enumeration children() {
            return Collections.enumeration(this.actions);
        }

        public String toString() {
            return this.folder.getNodeDelegate().getDisplayName();
        }
    }
}

