/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import org.netbeans.core.NbPlaces;
import org.netbeans.core.ui.LookupNode;
import org.openide.actions.PropertiesAction;
import org.openide.actions.ToolsAction;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;

final class EnvironmentNode
extends AbstractNode {
    static final long serialVersionUID = 4782447107972624693L;
    private String filter;
    private static final String EN_ICON_BASE = "org/netbeans/core/resources/";
    private static HashMap types = new HashMap(11);
    private static final Object lock = new Object();

    private EnvironmentNode(String filter, Children children) {
        super(children);
        this.filter = filter;
        EnvironmentNode.decorateNode(filter, this);
    }

    public static Node find(final String name) {
        Object retValue = Children.MUTEX.readAccess(new Mutex.Action(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                Object object = lock;
                synchronized (object) {
                    Object n = (Node)types.get(name);
                    if (n == null) {
                        DataFolder folder = null;
                        if ("environment".equals(name)) {
                            NbPlaces.getDefault();
                            folder = NbPlaces.findSessionFolder("UI/Runtime");
                        } else if ("roots".equals(name)) {
                            NbPlaces.getDefault();
                            folder = NbPlaces.findSessionFolder("UI/Roots");
                        } else {
                            NbPlaces.getDefault();
                            folder = NbPlaces.findSessionFolder("UI/Services");
                        }
                        n = new PersistentLookupNode(name, folder);
                        types.put(name, n);
                    }
                    return n;
                }
            }
        });
        if (retValue != null) {
            return (Node)retValue;
        }
        throw new IllegalStateException();
    }

    private static void decorateNode(String name, AbstractNode node) {
        String resourceName = "CTL_" + name + "_name";
        String iconBase = EN_ICON_BASE + name.toLowerCase();
        node.setDisplayName(NbBundle.getMessage((Class)EnvironmentNode.class, (String)resourceName));
        node.setIconBase(iconBase);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(EnvironmentNode.class);
    }

    public SystemAction[] createActions() {
        return new SystemAction[]{SystemAction.get((Class)ToolsAction.class), SystemAction.get((Class)PropertiesAction.class)};
    }

    public Node.Handle getHandle() {
        return new EnvironmentHandle(this.filter);
    }

    static final class EnvironmentHandle
    implements Node.Handle {
        static final long serialVersionUID = -850350968366553370L;
        private String filter;

        public EnvironmentHandle(String filter) {
            this.filter = filter;
        }

        public Node getNode() {
            String f = this.filter;
            if (f == null) {
                f = "environment";
            }
            return EnvironmentNode.find(f);
        }
    }

    private static final class PersistentLookupNode
    extends LookupNode
    implements PropertyChangeListener {
        private String filter;

        public PersistentLookupNode(String filter, DataFolder folder) {
            super(folder);
            this.filter = filter;
            if ("roots".equals(filter)) {
                folder.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)folder));
            }
        }

        public Node.Handle getHandle() {
            return new EnvironmentHandle(this.filter);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("children".equals(evt.getPropertyName())) {
                NbPlaces.getDefault().fireChange();
            }
        }
    }
}

