/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.EnvironmentNode;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public final class NbPlaces {
    private final List listeners = new ArrayList();
    private static NbPlaces DEFAULT;

    private NbPlaces() {
    }

    public static synchronized NbPlaces getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new NbPlaces();
        }
        return DEFAULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener l) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener l) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireChange() {
        ChangeListener[] l;
        List list = this.listeners;
        synchronized (list) {
            l = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
        }
        ChangeEvent ev = new ChangeEvent(this);
        for (int i = 0; i < l.length; ++i) {
            l[i].stateChanged(ev);
        }
    }

    public Node environment() {
        return EnvironmentNode.find("environment");
    }

    public Node session() {
        return EnvironmentNode.find("session");
    }

    public Node workspaces() {
        FileSystem fs = Repository.getDefault().getDefaultFileSystem();
        FileObject fo = fs.findResource("UI/Services/IDEConfiguration/LookAndFeel/Workspace.instance");
        if (fo != null) {
            try {
                Node node;
                DataObject dob = DataObject.find((FileObject)fo);
                InstanceCookie ic = (InstanceCookie)dob.getCookie(InstanceCookie.class);
                if (ic != null && Node.class.isAssignableFrom(ic.instanceClass()) && (node = (Node)ic.instanceCreate()) != null) {
                    return node;
                }
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify(1, (Throwable)ioe);
            }
            catch (ClassNotFoundException cnfe) {
                ErrorManager.getDefault().notify(1, (Throwable)cnfe);
            }
        }
        AbstractNode n = new AbstractNode(Children.LEAF);
        n.setName(NbBundle.getMessage((Class)NbPlaces.class, (String)"CTL_NoWorkspaces"));
        return n;
    }

    public Node repositorySettings() {
        return new AbstractNode(Children.LEAF);
    }

    public Node projectDesktop() {
        return this.workplace().getNodeDelegate();
    }

    public Node[] roots() {
        return EnvironmentNode.find("roots").getChildren().getNodes();
    }

    public DataFolder templates() {
        return NbPlaces.findSessionFolder("Templates");
    }

    public DataFolder toolbars() {
        return NbPlaces.findSessionFolder("Toolbars");
    }

    public DataFolder menus() {
        return NbPlaces.findSessionFolder("Menu");
    }

    public DataFolder actions() {
        return NbPlaces.findSessionFolder("Actions");
    }

    public DataFolder bookmarks() {
        return NbPlaces.findSessionFolder("Bookmarks");
    }

    public DataFolder projects() {
        return NbPlaces.findSessionFolder("Projects");
    }

    public DataFolder startup() {
        return NbPlaces.findSessionFolder("Startup");
    }

    public DataFolder welcome() {
        return NbPlaces.findSessionFolder("Welcome");
    }

    public DataFolder workplace() {
        return NbPlaces.findSessionFolder("Workplace");
    }

    public static DataFolder findSessionFolder(String name) {
        try {
            FileSystem fs = Repository.getDefault().getDefaultFileSystem();
            FileObject fo = fs.findResource(name);
            if (fo == null) {
                fo = fs.getRoot();
                StringTokenizer st = new StringTokenizer(name, "/");
                while (st.hasMoreTokens()) {
                    String subFolderName = st.nextToken();
                    FileObject ff = fo.getFileObject(subFolderName);
                    if (ff != null && ff.isFolder()) {
                        fo = ff;
                        continue;
                    }
                    fo = fo.createFolder(subFolderName);
                }
            }
            DataFolder df = DataFolder.findFolder((FileObject)fo);
            return df;
        }
        catch (IOException ex) {
            IllegalStateException e = new IllegalStateException("Folder not found and cannot be created: " + name);
            ErrorManager.getDefault().annotate((Throwable)e, (Throwable)ex);
            throw e;
        }
    }
}

