/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Keymap;
import org.netbeans.core.ActionsPanel;
import org.netbeans.core.ShortcutsEditor;
import org.netbeans.core.ShortcutsFolder;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ShortcutsPanel
extends JPanel {
    private Keymap map;
    private Vector strokes;
    private ShortcutsEditor shortcutsEditor;
    private ActionsPanel addActionsPanel;
    private JScrollPane shortcutsScrollPane;
    private JButton addButton;
    private JTextArea shortcutTextArea;
    private JPanel buttonsPanel;
    private JList shortcutsList;
    private JButton removeButton;

    public ShortcutsPanel(ShortcutsEditor shortcutsEditor) {
        this.shortcutsEditor = shortcutsEditor;
        this.updateData();
        this.initComponents();
        this.initAccessibility();
        ResourceBundle bundle = NbBundle.getBundle((Class)ShortcutsPanel.class);
        this.addButton.setMnemonic(bundle.getString("ActionsPanel.shortcutAddButton.text_Mnemonic").charAt(0));
        this.removeButton.setMnemonic(bundle.getString("ActionsPanel.shortcutRemoveButton.text_Mnemonic").charAt(0));
        this.buttonsPanel.setBorder(new CompoundBorder(new TitledBorder(new EtchedBorder(), bundle.getString("ActionsPanel.ShortcutsTitle")), new EmptyBorder(new Insets(12, 12, 11, 11))));
        this.shortcutsList.setCellRenderer(new KeyStrokeRenderer());
        this.shortcutsList.setSelectedIndices(new int[0]);
        this.updateButtons();
    }

    private void initComponents() {
        this.shortcutsScrollPane = new JScrollPane();
        this.shortcutsList = new JList(this.strokes);
        this.buttonsPanel = new JPanel();
        this.shortcutTextArea = new JTextArea();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.shortcutsList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                ShortcutsPanel.this.shortcutsListValueChanged(evt);
            }
        });
        this.shortcutsScrollPane.setViewportView(this.shortcutsList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.shortcutsScrollPane, gridBagConstraints);
        this.buttonsPanel.setLayout(new GridBagLayout());
        this.shortcutTextArea.setWrapStyleWord(true);
        this.shortcutTextArea.setToolTipText(ResourceBundle.getBundle("org/netbeans/core/Bundle").getString("ACS_ShortcutsPanel.shortcutTextArea.text.a11yName"));
        this.shortcutTextArea.setLineWrap(true);
        this.shortcutTextArea.setEditable(false);
        this.shortcutTextArea.setText(ResourceBundle.getBundle("org/netbeans/core/Bundle").getString("ShortcutsPanel.shortcutTextArea.text"));
        this.shortcutTextArea.setBackground(this.buttonsPanel.getBackground());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.buttonsPanel.add((Component)this.shortcutTextArea, gridBagConstraints);
        this.addButton.setText(ResourceBundle.getBundle("org/netbeans/core/Bundle").getString("ShortcutsPanel.addButton.text"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ShortcutsPanel.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.buttonsPanel.add((Component)this.addButton, gridBagConstraints);
        this.removeButton.setText(ResourceBundle.getBundle("org/netbeans/core/Bundle").getString("ShortcutsPanel.removeButton.text"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ShortcutsPanel.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.buttonsPanel.add((Component)this.removeButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.buttonsPanel, gridBagConstraints);
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        if (this.addActionsPanel == null) {
            this.addActionsPanel = new ActionsPanel(true, this.shortcutsEditor);
            this.addActionsPanel.setBorder(new EmptyBorder(12, 12, 0, 11));
        }
        DialogDescriptor dd = new DialogDescriptor((Object)this.addActionsPanel, NbBundle.getBundle((Class)ShortcutsPanel.class).getString("ShortcutsPanel.AddActionTitle"));
        Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        d.setVisible(true);
        if (dd.getValue() == DialogDescriptor.OK_OPTION) {
            this.updateData();
            this.shortcutsList.setListData(this.strokes);
            this.shortcutsEditor.setModified(true);
        }
    }

    private void shortcutsListValueChanged(ListSelectionEvent evt) {
        this.updateButtons();
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int[] selectedIndices = this.shortcutsList.getSelectedIndices();
        Object[] selected = this.shortcutsList.getSelectedValues();
        for (int i = 0; i < selected.length; ++i) {
            KeyStroke ks = (KeyStroke)selected[i];
            this.shortcutsEditor.removeShortcut(ks, this.map.getAction(ks));
            this.map.removeKeyStrokeBinding(ks);
            this.strokes.remove(selected[i]);
        }
        if (selectedIndices.length == 1) {
            this.shortcutsList.setSelectedIndex(selectedIndices[0]);
        } else {
            this.shortcutsList.setSelectedIndices(new int[0]);
        }
        this.shortcutsList.revalidate();
        this.shortcutsList.repaint();
        this.shortcutsEditor.setModified(true);
    }

    private void updateData() {
        this.map = (Keymap)Lookup.getDefault().lookup(Keymap.class);
        KeyStroke[] strokesArray = this.map.getBoundKeyStrokes();
        this.strokes = new Vector();
        for (int i = 0; i < strokesArray.length; ++i) {
            this.strokes.addElement(strokesArray[i]);
        }
        Collections.sort(this.strokes, new Comparator(){

            public int compare(Object o1, Object o2) {
                int m2;
                int k2;
                int k1 = ((KeyStroke)o1).getKeyCode();
                if (k1 < (k2 = ((KeyStroke)o2).getKeyCode())) {
                    return -1;
                }
                if (k1 > k2) {
                    return 1;
                }
                int m1 = ((KeyStroke)o1).getModifiers();
                if (m1 < (m2 = ((KeyStroke)o2).getModifiers())) {
                    return -1;
                }
                if (m1 > m2) {
                    return 1;
                }
                return 0;
            }
        });
    }

    private void updateButtons() {
        this.removeButton.setEnabled(this.shortcutsList.getSelectedIndices().length > 0);
    }

    private void initAccessibility() {
        ResourceBundle bundle = NbBundle.getBundle((Class)ShortcutsPanel.class);
        this.shortcutsList.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_ShortcutsPanel.shortcutsList"));
        this.shortcutsList.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ShortcutsPanel.shortcutsList"));
        this.shortcutTextArea.getAccessibleContext().setAccessibleName(bundle.getString("ACS_ShortcutsPanel.shortcutTextArea.text.a11yName"));
        this.addButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_ShortcutsPanel.addButton.text.a11yDesc"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_ShortcutsPanel.removeButton.text.a11yDesc"));
    }

    protected void setFocusDefault() {
        this.shortcutsList.requestFocus();
    }

    static class KeyStrokeRenderer
    extends DefaultListCellRenderer {
        KeyStrokeRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setText(" " + ShortcutsFolder.getKeyStrokeName((KeyStroke)value));
            return this;
        }
    }
}

