/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.jse141urlpatch;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import sun.net.www.protocol.jar.URLJarFile;

public class JarURLConnection
extends java.net.JarURLConnection {
    protected static Map cache = Collections.synchronizedMap(new HashMap());
    protected static final boolean force_cache = Boolean.getBoolean("netbeans.core.jse141urlpatch.jar.forcecache");
    protected JarEntry jarEntry;
    protected JarFile jarFile;
    protected String contentType;

    public JarURLConnection(URL url) throws MalformedURLException, IOException {
        super(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws IOException {
        if (!this.connected) {
            URL url = this.getJarFileURL();
            String entryName = this.getEntryName();
            if (this.getUseCaches() || force_cache) {
                CacheEntry ce;
                SoftReference ref = (SoftReference)cache.get(url);
                CacheEntry cacheEntry = ce = ref != null ? (CacheEntry)ref.get() : null;
                if (ce == null) {
                    ce = new CacheEntry(this.createJarFile(url), url.openConnection());
                    Map map = cache;
                    synchronized (map) {
                        cache.put(url, new SoftReference<CacheEntry>(ce));
                    }
                }
                this.jarFile = ce.getJarFile();
                this.jarFileURLConnection = ce.getConnection();
            } else {
                this.jarFile = this.createJarFile(url);
                this.jarFileURLConnection = url.openConnection();
            }
            if (entryName != null) {
                this.jarEntry = (JarEntry)this.jarFile.getEntry(entryName);
                if (this.jarEntry == null) {
                    throw new FileNotFoundException("Entry not found: '" + entryName + "' in " + this.jarFile.getName());
                }
            }
            this.connected = true;
        }
    }

    public JarFile getJarFile() throws IOException {
        return this.jarFile;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        InputStream result = null;
        if (this.getEntryName() == null) {
            throw new IOException("No entry specified!");
        }
        result = this.jarFile.getInputStream(this.jarEntry);
        return result;
    }

    public int getContentLength() {
        int result = -1;
        try {
            this.connect();
            result = this.jarEntry == null ? this.jarFileURLConnection.getContentLength() : (int)this.getJarEntry().getSize();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public Object getContent() throws IOException {
        Object result = null;
        this.connect();
        result = this.getEntryName() == null ? this.jarFile : super.getContent();
        return result;
    }

    public String getContentType() {
        if (this.contentType == null) {
            String entryName = this.getEntryName();
            if (entryName == null) {
                this.contentType = "x-java/jar";
            } else {
                if (this.contentType == null) {
                    this.contentType = JarURLConnection.guessContentTypeFromName(entryName);
                }
                if (this.contentType == null) {
                    this.contentType = "content/unknown";
                }
            }
        }
        return this.contentType;
    }

    public String getHeaderField(String name) {
        return this.jarFileURLConnection != null ? this.jarFileURLConnection.getHeaderField(name) : null;
    }

    public String getHeaderField(int n) {
        return this.jarFileURLConnection != null ? this.jarFileURLConnection.getHeaderField(n) : null;
    }

    public String getHeaderFieldKey(int n) {
        return this.jarFileURLConnection != null ? this.jarFileURLConnection.getHeaderFieldKey(n) : null;
    }

    public Map getHeaderFields() {
        return this.jarFileURLConnection != null ? this.jarFileURLConnection.getHeaderFields() : Collections.EMPTY_MAP;
    }

    public void setRequestProperty(String key, String value) {
    }

    public String getRequestProperty(String key) {
        return this.jarFileURLConnection != null ? this.jarFileURLConnection.getRequestProperty(key) : null;
    }

    public void setAllowUserInteraction(boolean allowuserinteraction) {
        if (this.jarFileURLConnection != null) {
            this.jarFileURLConnection.setAllowUserInteraction(allowuserinteraction);
        }
    }

    public boolean getAllowUserInteraction() {
        return this.jarFileURLConnection != null ? this.jarFileURLConnection.getAllowUserInteraction() : false;
    }

    protected JarFile createJarFile(URL url) throws IOException {
        String fname = url.getFile();
        File file = new File(URLDecoder.decode(fname, "UTF-8"));
        return new URLJarFile(file);
    }

    protected static class CacheEntry {
        protected JarFile jarFile;
        protected URLConnection conn;

        protected CacheEntry(JarFile jarFile, URLConnection conn) {
            this.jarFile = jarFile;
            this.conn = conn;
        }

        public JarFile getJarFile() {
            return this.jarFile;
        }

        public URLConnection getConnection() {
            return this.conn;
        }
    }
}

