/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.modules;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.netbeans.JarClassLoader;
import org.netbeans.ProxyClassLoader;
import org.netbeans.core.modules.Events;
import org.netbeans.core.modules.InvalidException;
import org.netbeans.core.modules.ModuleManager;
import org.netbeans.core.modules.Util;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.WeakSet;

public final class Module
extends ModuleInfo {
    public static final String PROP_RELOADABLE = "reloadable";
    public static final String PROP_CLASS_LOADER = "classLoader";
    public static final String PROP_MANIFEST = "manifest";
    public static final String PROP_VALID = "valid";
    public static final String PROP_PROBLEMS = "problems";
    private final ModuleManager mgr;
    private final Events ev;
    private final Object history;
    private final File jar;
    private File physicalJar = null;
    private boolean enabled;
    private boolean reloadable;
    private final boolean autoload;
    private final boolean eager;
    private Manifest manifest;
    private String codeNameBase;
    private int codeNameRelease;
    private String codeName;
    private String[] provides;
    private Dependency[] dependenciesA;
    private SpecificationVersion specVers;
    private ClassLoader classloader = null;
    private final Set oldClassLoaders = new WeakSet(3);
    private Properties localizedProps;
    private PackageExport[] publicPackages;
    private static final Map extensionOwners;
    private static final Set moduleJARs;
    private Set localeVariants = null;
    private Set plainExtensions = null;
    private Set localeExtensions = null;
    private Set patches = null;
    private transient boolean released;
    private transient int releaseCount = 0;
    private static PermissionCollection modulePermissions;
    static final /* synthetic */ boolean $assertionsDisabled;

    Module(ModuleManager mgr, Events ev, File jar, Object history, boolean reloadable, boolean autoload, boolean eager) throws IOException {
        if (autoload && eager) {
            throw new IllegalArgumentException("A module may not be both autoload and eager");
        }
        this.mgr = mgr;
        this.ev = ev;
        this.jar = jar;
        this.history = history;
        this.reloadable = reloadable;
        this.autoload = autoload;
        this.eager = eager;
        this.enabled = false;
        this.loadManifest();
        this.parseManifest();
        this.findExtensionsAndVariants(this.manifest);
        Set bogoOwners = (Set)extensionOwners.get(jar);
        if (bogoOwners != null) {
            Util.err.log(16, "WARNING - module " + jar + " was incorrectly placed in the Class-Path of other JARs " + bogoOwners + "; please use OpenIDE-Module-Module-Dependencies instead");
        }
        moduleJARs.add(jar);
    }

    Module(ModuleManager mgr, Events ev, Manifest manifest, Object history, ClassLoader classloader) throws InvalidException {
        this.mgr = mgr;
        this.ev = ev;
        this.manifest = manifest;
        this.history = history;
        this.classloader = classloader;
        this.jar = null;
        this.reloadable = false;
        this.autoload = false;
        this.eager = false;
        this.enabled = false;
        this.parseManifest();
    }

    public ModuleManager getManager() {
        return this.mgr;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isValid() {
        return this.mgr.get(this.getCodeNameBase()) == this;
    }

    public boolean isAutoload() {
        return this.autoload;
    }

    public boolean isEager() {
        return this.eager;
    }

    public Object getAttribute(String attr) {
        return this.getManifest().getMainAttributes().getValue(attr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getLocalizedAttribute(String attr) {
        int idx;
        String locb = this.manifest.getMainAttributes().getValue("OpenIDE-Module-Localizing-Bundle");
        boolean usingLoader = false;
        if (locb != null) {
            if (this.classloader != null) {
                if (locb.endsWith(".properties")) {
                    usingLoader = true;
                    String basename = locb.substring(0, locb.length() - 11).replace('/', '.');
                    try {
                        ResourceBundle bundle = NbBundle.getBundle((String)basename, (Locale)Locale.getDefault(), (ClassLoader)this.classloader);
                        try {
                            return bundle.getString(attr);
                        }
                        catch (MissingResourceException mre) {
                        }
                    }
                    catch (MissingResourceException mre) {
                        Util.err.notify((Throwable)mre);
                    }
                } else {
                    Util.err.log(16, "WARNING - cannot efficiently load non-*.properties OpenIDE-Module-Localizing-Bundle: " + locb);
                }
            }
            if (!usingLoader) {
                String val;
                block20: {
                    if (this.localizedProps == null) {
                        Util.err.log("Trying to get localized attr " + attr + " from disabled module " + this.getCodeNameBase());
                        try {
                            if (this.jar != null) {
                                JarFile jarFile = new JarFile(this.jar, false);
                                try {
                                    this.loadLocalizedProps(jarFile, this.manifest);
                                    break block20;
                                }
                                finally {
                                    jarFile.close();
                                }
                            }
                            if (this.classloader != null) {
                                this.loadLocalizedPropsClasspath();
                                break block20;
                            }
                            throw new IllegalStateException();
                        }
                        catch (IOException ioe) {
                            Util.err.annotate((Throwable)ioe, 1, this.jar.getAbsolutePath(), null, null, null);
                            Util.err.notify(1, (Throwable)ioe);
                            if (this.localizedProps != null) break block20;
                            this.localizedProps = new Properties();
                        }
                    }
                }
                if ((val = this.localizedProps.getProperty(attr)) != null) {
                    return val;
                }
            }
        }
        if ((idx = attr.lastIndexOf(47)) == -1) {
            return NbBundle.getLocalizedValue((Attributes)this.getManifest().getMainAttributes(), (Attributes.Name)new Attributes.Name(attr));
        }
        String section = attr.substring(0, idx);
        String realAttr = attr.substring(idx + 1);
        Attributes attrs = this.getManifest().getAttributes(section);
        if (attrs != null) {
            return NbBundle.getLocalizedValue((Attributes)attrs, (Attributes.Name)new Attributes.Name(realAttr));
        }
        return null;
    }

    public String getCodeName() {
        return this.codeName;
    }

    public String getCodeNameBase() {
        return this.codeNameBase;
    }

    public int getCodeNameRelease() {
        return this.codeNameRelease;
    }

    public String[] getProvides() {
        return this.provides;
    }

    final boolean provides(String token) {
        for (int i = 0; i < this.provides.length; ++i) {
            if (!this.provides[i].equals(token)) continue;
            return true;
        }
        return false;
    }

    public Set getDependencies() {
        return new HashSet<Dependency>(Arrays.asList(this.dependenciesA));
    }

    final Dependency[] getDependenciesArray() {
        return this.dependenciesA;
    }

    public SpecificationVersion getSpecificationVersion() {
        return this.specVers;
    }

    public boolean owns(Class clazz) {
        ClassLoader cl = clazz.getClassLoader();
        if (cl instanceof Util.ModuleProvider) {
            return ((Util.ModuleProvider)((Object)cl)).getModule() == this;
        }
        return false;
    }

    public PackageExport[] getPublicPackages() {
        return this.publicPackages;
    }

    private void parseManifest() throws InvalidException {
        Attributes attr = this.manifest.getMainAttributes();
        this.codeName = attr.getValue("OpenIDE-Module");
        if (this.codeName == null) {
            InvalidException e = new InvalidException("Not a module: no OpenIDE-Module tag in manifest of " + this.jar);
            Util.err.annotate((Throwable)e, NbBundle.getMessage((Class)Module.class, (String)"EXC_not_a_module", (Object)this.jar.getAbsolutePath()));
            throw e;
        }
        try {
            String exportsS;
            if (this.codeName.indexOf(44) != -1) {
                throw new InvalidException("Illegal code name syntax parsing OpenIDE-Module: " + this.codeName);
            }
            Dependency.create((int)1, (String)this.codeName);
            Object[] cnParse = Util.parseCodeName(this.codeName);
            this.codeNameBase = (String)cnParse[0];
            int n = this.codeNameRelease = cnParse[1] != null ? (Integer)cnParse[1] : -1;
            if (cnParse[2] != null) {
                throw new NumberFormatException(this.codeName);
            }
            String specVersS = attr.getValue("OpenIDE-Module-Specification-Version");
            if (specVersS != null) {
                try {
                    this.specVers = new SpecificationVersion(specVersS);
                }
                catch (NumberFormatException nfe) {
                    InvalidException ie = new InvalidException("While parsing OpenIDE-Module-Specification-Version: " + nfe.toString());
                    Util.err.annotate((Throwable)ie, (Throwable)nfe);
                    throw ie;
                }
            } else {
                this.specVers = null;
            }
            String providesS = attr.getValue("OpenIDE-Module-Provides");
            if (providesS == null) {
                this.provides = new String[0];
            } else {
                StringTokenizer tok = new StringTokenizer(providesS, ", ");
                this.provides = new String[tok.countTokens()];
                for (int i = 0; i < this.provides.length; ++i) {
                    String provide = tok.nextToken();
                    if (provide.indexOf(44) != -1) {
                        throw new InvalidException("Illegal code name syntax parsing OpenIDE-Module-Provides: " + provide);
                    }
                    Dependency.create((int)1, (String)provide);
                    if (provide.lastIndexOf(47) != -1) {
                        throw new IllegalArgumentException("Illegal OpenIDE-Module-Provides: " + provide);
                    }
                    this.provides[i] = provide;
                }
                if (new HashSet<String>(Arrays.asList(this.provides)).size() < this.provides.length) {
                    throw new IllegalArgumentException("Duplicate entries in OpenIDE-Module-Provides: " + providesS);
                }
            }
            String[] additionalProvides = this.mgr.refineProvides(this);
            if (additionalProvides != null) {
                if (this.provides == null) {
                    this.provides = additionalProvides;
                } else {
                    ArrayList<String> l = new ArrayList<String>();
                    l.addAll(Arrays.asList(this.provides));
                    l.addAll(Arrays.asList(additionalProvides));
                    this.provides = l.toArray(this.provides);
                }
            }
            if ((exportsS = attr.getValue("OpenIDE-Module-Public-Packages")) != null) {
                if (exportsS.trim().equals("-")) {
                    this.publicPackages = new PackageExport[0];
                } else {
                    StringTokenizer tok = new StringTokenizer(exportsS, ", ");
                    ArrayList<PackageExport> exports = new ArrayList<PackageExport>(Math.max(tok.countTokens(), 1));
                    while (tok.hasMoreTokens()) {
                        String pkg;
                        String piece = tok.nextToken();
                        if (piece.endsWith(".*")) {
                            pkg = piece.substring(0, piece.length() - 2);
                            Dependency.create((int)1, (String)pkg);
                            if (pkg.lastIndexOf(47) != -1) {
                                throw new IllegalArgumentException("Illegal OpenIDE-Module-Public-Packages: " + exportsS);
                            }
                            exports.add(new PackageExport(pkg.replace('.', '/') + '/', false));
                            continue;
                        }
                        if (piece.endsWith(".**")) {
                            pkg = piece.substring(0, piece.length() - 3);
                            Dependency.create((int)1, (String)pkg);
                            if (pkg.lastIndexOf(47) != -1) {
                                throw new IllegalArgumentException("Illegal OpenIDE-Module-Public-Packages: " + exportsS);
                            }
                            exports.add(new PackageExport(pkg.replace('.', '/') + '/', true));
                            continue;
                        }
                        throw new IllegalArgumentException("Illegal OpenIDE-Module-Public-Packages: " + exportsS);
                    }
                    if (exports.isEmpty()) {
                        throw new IllegalArgumentException("Illegal OpenIDE-Module-Public-Packages: " + exportsS);
                    }
                    this.publicPackages = exports.toArray(new PackageExport[exports.size()]);
                }
            } else {
                Util.err.log(16, "Warning: module " + this.codeNameBase + " does not declare OpenIDE-Module-Public-Packages in its manifest, so all packages are considered public by default: http://www.netbeans.org/download/dev/javadoc/OpenAPIs/org/openide/doc-files/upgrade.html#3.4-public-packages");
                this.publicPackages = null;
            }
            HashSet dependencies = new HashSet(20);
            Set openideDeps = Dependency.create((int)4, (String)attr.getValue("OpenIDE-Module-IDE-Dependencies"));
            if (!openideDeps.isEmpty()) {
                Dependency d = (Dependency)openideDeps.iterator().next();
                String name = d.getName();
                if (!name.startsWith("IDE/")) {
                    throw new IllegalStateException("Weird IDE dep: " + name);
                }
                dependencies.addAll(Dependency.create((int)1, (String)("org.openide/" + name.substring(4) + " > " + d.getVersion())));
                if (dependencies.size() != 1) {
                    throw new IllegalStateException("Should be singleton: " + dependencies);
                }
            }
            dependencies.addAll(Dependency.create((int)3, (String)attr.getValue("OpenIDE-Module-Java-Dependencies")));
            dependencies.addAll(Dependency.create((int)1, (String)attr.getValue("OpenIDE-Module-Module-Dependencies")));
            String pkgdeps = attr.getValue("OpenIDE-Module-Package-Dependencies");
            if (pkgdeps != null) {
                dependencies.addAll(Dependency.create((int)2, (String)pkgdeps));
            }
            dependencies.addAll(Dependency.create((int)5, (String)attr.getValue("OpenIDE-Module-Requires")));
            this.mgr.refineDependencies(this, dependencies);
            this.dependenciesA = dependencies.toArray(new Dependency[dependencies.size()]);
        }
        catch (IllegalArgumentException iae) {
            InvalidException ie = new InvalidException("While parsing a dependency attribute: " + iae.toString());
            Util.err.annotate((Throwable)ie, (Throwable)iae);
            throw ie;
        }
    }

    public File getJarFile() {
        return this.jar;
    }

    public boolean isFixed() {
        return this.jar == null;
    }

    private void ensurePhysicalJar() throws IOException {
        if (this.reloadable && this.physicalJar == null) {
            this.physicalJar = Util.makeTempJar(this.jar);
        }
    }

    private void destroyPhysicalJar() {
        if (this.physicalJar != null) {
            if (this.physicalJar.isFile()) {
                if (!this.physicalJar.delete()) {
                    Util.err.log(16, "Warning: temporary JAR " + this.physicalJar + " not currently deletable.");
                } else {
                    Util.err.log("deleted: " + this.physicalJar);
                }
            }
            this.physicalJar = null;
        } else {
            Util.err.log("no physicalJar to delete for " + (Object)((Object)this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadManifest() throws IOException {
        block8: {
            Util.err.log("loading manifest of " + this.jar);
            File jarBeingOpened = null;
            try {
                if (this.reloadable) {
                    jarBeingOpened = this.physicalJar;
                    this.ensurePhysicalJar();
                    jarBeingOpened = this.physicalJar;
                    JarFile jarFile = new JarFile(this.physicalJar, false);
                    try {
                        Manifest m = jarFile.getManifest();
                        if (m == null) {
                            throw new IOException("No manifest found in " + this.physicalJar);
                        }
                        this.manifest = m;
                        break block8;
                    }
                    finally {
                        jarFile.close();
                    }
                }
                jarBeingOpened = this.jar;
                this.manifest = this.mgr.loadManifest(this.jar);
            }
            catch (IOException e) {
                if (jarBeingOpened != null) {
                    Util.err.annotate((Throwable)e, 0, "While loading manifest from: " + jarBeingOpened, null, null, null);
                }
                throw e;
            }
        }
    }

    private void findExtensionsAndVariants(Manifest m) {
        if (!$assertionsDisabled && this.jar == null) {
            throw new AssertionError((Object)("Cannot load extensions from classpath module " + this.codeNameBase));
        }
        this.localeVariants = null;
        List l = Util.findLocaleVariantsOf(this.jar, false);
        if (!l.isEmpty()) {
            this.localeVariants = new HashSet(l);
        }
        this.plainExtensions = null;
        this.localeExtensions = null;
        String classPath = m.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        if (classPath != null) {
            StringTokenizer tok = new StringTokenizer(classPath);
            while (tok.hasMoreTokens()) {
                File extfile;
                String ext = tok.nextToken();
                if ((new File(ext).isAbsolute() || ext.indexOf("../") != -1) && !ext.equals("../lib/updater.jar")) {
                    Util.err.log(16, "WARNING: Class-Path value " + ext + " from " + this.jar + " is illegal according to the Java Extension Mechanism: must be relative and not move up directories");
                }
                if (!(extfile = new File(this.jar.getParentFile(), ext.replace('/', File.separatorChar))).exists()) {
                    Util.err.log(16, "Warning: Class-Path value " + ext + " from " + this.jar + " cannot be found at " + extfile);
                    continue;
                }
                HashSet<File> owners = (HashSet<File>)extensionOwners.get(extfile);
                if (owners == null) {
                    owners = new HashSet<File>(2);
                    owners.add(this.jar);
                    extensionOwners.put(extfile, owners);
                } else if (!owners.contains(this.jar)) {
                    owners.add(this.jar);
                    this.ev.log("extensionMultiplyLoaded", extfile, owners);
                }
                if (moduleJARs.contains(extfile)) {
                    Util.err.log(16, "WARNING: Class-Path value " + ext + " from " + this.jar + " illegally refers to another module; use OpenIDE-Module-Module-Dependencies instead");
                }
                if (this.plainExtensions == null) {
                    this.plainExtensions = new HashSet();
                }
                this.plainExtensions.add(extfile);
                l = Util.findLocaleVariantsOf(extfile, false);
                if (l.isEmpty()) continue;
                if (this.localeExtensions == null) {
                    this.localeExtensions = new HashSet();
                }
                this.localeExtensions.addAll(l);
            }
        }
        File patchdir = new File(new File(this.jar.getParentFile(), "patches"), this.getCodeNameBase().replace('.', '-'));
        this.scanForPatches(patchdir);
        String patchesClassPath = System.getProperty("netbeans.patches." + this.getCodeNameBase());
        if (patchesClassPath != null) {
            StringTokenizer tokenizer = new StringTokenizer(patchesClassPath, File.pathSeparator);
            while (tokenizer.hasMoreElements()) {
                String element = (String)tokenizer.nextElement();
                File fileElement = new File(element);
                if (!fileElement.exists()) continue;
                if (this.patches == null) {
                    this.patches = new HashSet(15);
                }
                this.patches.add(fileElement);
            }
        }
        Util.err.log("localeVariants of " + this.jar + ": " + this.localeVariants);
        Util.err.log("plainExtensions of " + this.jar + ": " + this.plainExtensions);
        Util.err.log("localeExtensions of " + this.jar + ": " + this.localeExtensions);
        Util.err.log("patches of " + this.jar + ": " + this.patches);
        if (this.patches != null) {
            Iterator it = this.patches.iterator();
            while (it.hasNext()) {
                this.ev.log("patch", it.next());
            }
        }
    }

    private void scanForPatches(File patchdir) {
        if (!patchdir.isDirectory()) {
            return;
        }
        File[] jars = patchdir.listFiles(Util.jarFilter());
        if (jars != null) {
            for (int j = 0; j < jars.length; ++j) {
                if (this.patches == null) {
                    this.patches = new HashSet(5);
                }
                this.patches.add(jars[j]);
            }
        } else {
            Util.err.log(16, "Could not search for patches in " + patchdir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLocalizedProps(JarFile jarFile, Manifest m) throws IOException {
        String locbundle = m.getMainAttributes().getValue("OpenIDE-Module-Localizing-Bundle");
        if (locbundle != null) {
            String ext;
            String name;
            int idx;
            ZipEntry bundleFile = jarFile.getEntry(locbundle);
            if (bundleFile != null) {
                this.localizedProps = new Properties();
                InputStream is = jarFile.getInputStream(bundleFile);
                try {
                    this.localizedProps.load(is);
                }
                finally {
                    is.close();
                }
            }
            if ((idx = locbundle.lastIndexOf(46)) == -1) {
                name = locbundle;
                ext = "";
            } else {
                name = locbundle.substring(0, idx);
                ext = locbundle.substring(idx);
            }
            List pairs = Util.findLocaleVariantsOf(this.jar, true);
            Collections.reverse(pairs);
            Iterator it = pairs.iterator();
            while (it.hasNext()) {
                Object[] pair = (Object[])it.next();
                File localeJar = (File)pair[0];
                String suffix = (String)pair[1];
                String rsrc = name + suffix + ext;
                JarFile localeJarFile = new JarFile(localeJar, false);
                try {
                    ZipEntry bundleFile2 = localeJarFile.getEntry(rsrc);
                    if (bundleFile2 == null) continue;
                    if (this.localizedProps == null) {
                        this.localizedProps = new Properties();
                    }
                    InputStream is = localeJarFile.getInputStream(bundleFile2);
                    try {
                        this.localizedProps.load(is);
                    }
                    finally {
                        is.close();
                    }
                }
                finally {
                    localeJarFile.close();
                }
            }
            if (this.localizedProps == null) {
                throw new IOException("Could not find localizing bundle: " + locbundle);
            }
        }
    }

    private void loadLocalizedPropsClasspath() throws InvalidException {
        Attributes attr = this.manifest.getMainAttributes();
        String locbundle = attr.getValue("OpenIDE-Module-Localizing-Bundle");
        if (locbundle != null) {
            Util.err.log("Localized props in " + locbundle + " for " + attr.getValue("OpenIDE-Module"));
            try {
                String ext;
                String name;
                int idx = locbundle.lastIndexOf(46);
                if (idx == -1) {
                    name = locbundle;
                    ext = "";
                } else {
                    name = locbundle.substring(0, idx);
                    ext = locbundle.substring(idx);
                }
                ArrayList suffixes = new ArrayList(10);
                Iterator it = NbBundle.getLocalizingSuffixes();
                while (it.hasNext()) {
                    suffixes.add(it.next());
                }
                Collections.reverse(suffixes);
                it = suffixes.iterator();
                while (it.hasNext()) {
                    String suffix = (String)it.next();
                    String resource = name + suffix + ext;
                    InputStream is = this.classloader.getResourceAsStream(resource);
                    if (is == null) continue;
                    Util.err.log("Found " + resource);
                    if (this.localizedProps == null) {
                        this.localizedProps = new Properties();
                    }
                    this.localizedProps.load(is);
                }
                if (this.localizedProps == null) {
                    throw new IOException("Could not find localizing bundle: " + locbundle);
                }
            }
            catch (IOException ioe) {
                InvalidException e = new InvalidException(ioe.toString());
                Util.err.annotate((Throwable)e, (Throwable)ioe);
                throw e;
            }
        }
    }

    public List getAllJars() {
        if (this.jar == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<File> l = new ArrayList<File>();
        if (this.patches != null) {
            l.addAll(this.patches);
        }
        if (this.physicalJar != null) {
            l.add(this.physicalJar);
        } else if (this.jar != null) {
            l.add(this.jar);
        }
        if (this.plainExtensions != null) {
            l.addAll(this.plainExtensions);
        }
        if (this.localeVariants != null) {
            l.addAll(this.localeVariants);
        }
        if (this.localeExtensions != null) {
            l.addAll(this.localeExtensions);
        }
        return l;
    }

    public boolean isReloadable() {
        return this.reloadable;
    }

    public void setReloadable(boolean r) {
        this.mgr.assertWritable();
        if (this.isFixed()) {
            throw new IllegalStateException();
        }
        if (this.reloadable != r) {
            this.reloadable = r;
            this.mgr.fireReloadable(this);
        }
    }

    void reload() throws IOException {
        if (this.isFixed()) {
            throw new IllegalStateException();
        }
        this.destroyPhysicalJar();
        String codeNameBase1 = this.getCodeNameBase();
        this.localizedProps = null;
        this.loadManifest();
        this.parseManifest();
        this.findExtensionsAndVariants(this.manifest);
        String codeNameBase2 = this.getCodeNameBase();
        if (!codeNameBase1.equals(codeNameBase2)) {
            throw new InvalidException("Code name base changed during reload: " + codeNameBase1 + " -> " + codeNameBase2);
        }
    }

    public ClassLoader getClassLoader() throws IllegalArgumentException {
        if (!this.enabled) {
            throw new IllegalArgumentException("Not enabled: " + this.codeNameBase);
        }
        if (!$assertionsDisabled && this.classloader == null) {
            throw new AssertionError((Object)("Should have had a non-null loader for " + (Object)((Object)this)));
        }
        return this.classloader;
    }

    void classLoaderUp(Set parents) throws IOException {
        File act;
        if (this.isFixed()) {
            return;
        }
        Util.err.log("classLoaderUp on " + (Object)((Object)this) + " with parents " + parents);
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>(parents.size() + 1);
        loaders.add(Module.class.getClassLoader());
        Iterator it = parents.iterator();
        while (it.hasNext()) {
            Module parent = (Module)((Object)it.next());
            PackageExport[] exports = parent.getPublicPackages();
            if (exports != null && exports.length == 0) {
                Dependency[] deps = this.getDependenciesArray();
                boolean implDep = false;
                for (int i = 0; i < deps.length; ++i) {
                    if (deps[i].getType() != 1 || deps[i].getComparison() != 2 || !deps[i].getName().equals(parent.getCodeName())) continue;
                    implDep = true;
                    break;
                }
                if (!implDep) continue;
            }
            ClassLoader l = parent.getClassLoader();
            if (parent.isFixed() && loaders.contains(l)) {
                Util.err.log("#24996: skipping duplicate classloader from " + (Object)((Object)parent));
                continue;
            }
            loaders.add(l);
        }
        ArrayList<Object> classp = new ArrayList<Object>(3);
        if (this.patches != null) {
            it = this.patches.iterator();
            while (it.hasNext()) {
                File f = (File)it.next();
                if (f.isDirectory()) {
                    classp.add(f);
                    continue;
                }
                classp.add(new JarFile(f, false));
            }
        }
        if (this.reloadable) {
            this.ensurePhysicalJar();
            classp.add(new JarFile(this.physicalJar, false));
        } else {
            classp.add(new JarFile(this.jar, false));
        }
        if (this.localeVariants != null) {
            it = this.localeVariants.iterator();
            while (it.hasNext()) {
                classp.add(new JarFile((File)it.next(), false));
            }
        }
        if (this.localeExtensions != null) {
            it = this.localeExtensions.iterator();
            while (it.hasNext()) {
                act = (File)it.next();
                classp.add(act.isDirectory() ? act : new JarFile(act, false));
            }
        }
        if (this.plainExtensions != null) {
            it = this.plainExtensions.iterator();
            while (it.hasNext()) {
                act = (File)it.next();
                classp.add(act.isDirectory() ? act : new JarFile(act, false));
            }
        }
        this.mgr.refineClassLoader(this, loaders);
        try {
            this.classloader = new OneModuleClassLoader(classp, loaders.toArray(new ClassLoader[loaders.size()]));
        }
        catch (IllegalArgumentException iae) {
            IOException ioe = new IOException(iae.toString());
            Util.err.annotate((Throwable)ioe, (Throwable)iae);
            throw ioe;
        }
        this.oldClassLoaders.add(this.classloader);
    }

    void classLoaderDown() {
        if (this.isFixed()) {
            return;
        }
        if (this.classloader instanceof ProxyClassLoader) {
            ((ProxyClassLoader)this.classloader).destroy();
        }
        this.classloader = null;
        Util.err.log("classLoaderDown on " + (Object)((Object)this) + ": releaseCount=" + this.releaseCount + " released=" + this.released);
        this.released = false;
    }

    void cleanup() {
        if (this.isFixed()) {
            return;
        }
        if (this.isEnabled()) {
            throw new IllegalStateException("cleanup on enabled module: " + (Object)((Object)this));
        }
        if (this.classloader != null) {
            throw new IllegalStateException("cleanup on module with classloader: " + (Object)((Object)this));
        }
        if (!this.released) {
            Util.err.log("Warning: not all resources associated with module " + this.jar + " were successfully released.");
            this.released = true;
        } else {
            Util.err.log("All resources associated with module " + this.jar + " were successfully released.");
        }
        this.destroyPhysicalJar();
    }

    void destroy() {
        Iterator it = this.oldClassLoaders.iterator();
        while (it.hasNext()) {
            OneModuleClassLoader l = (OneModuleClassLoader)it.next();
            l.releaseLocks();
        }
        moduleJARs.remove(this.jar);
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public Set getProblems() {
        if (!this.isValid()) {
            throw new IllegalStateException("Not valid: " + (Object)((Object)this));
        }
        if (this.isEnabled()) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableSet(this.mgr.missingDependencies(this));
    }

    final void firePropertyChange0(String prop, Object old, Object nue) {
        if (Util.err.isLoggable(1)) {
            Util.err.log("Module.propertyChange: " + (Object)((Object)this) + " " + prop + ": " + old + " -> " + nue);
        }
        this.firePropertyChange(prop, old, nue);
    }

    public final Object getHistory() {
        return this.history;
    }

    public String toString() {
        String s = "Module:" + this.getCodeNameBase();
        if (!this.isValid()) {
            s = s + "[invalid]";
        }
        return s;
    }

    private static synchronized PermissionCollection getAllPermission() {
        if (modulePermissions == null) {
            modulePermissions = new Permissions();
            modulePermissions.add(new AllPermission());
            modulePermissions.setReadOnly();
        }
        return modulePermissions;
    }

    static {
        $assertionsDisabled = !Module.class.desiredAssertionStatus();
        extensionOwners = new HashMap();
        moduleJARs = new HashSet();
    }

    public static final class PackageExport {
        public final String pkg;
        public final boolean recursive;

        public PackageExport(String pkg, boolean recursive) {
            this.pkg = pkg;
            this.recursive = recursive;
        }

        public String toString() {
            return "PackageExport[" + this.pkg + (this.recursive ? "**/" : "") + "]";
        }
    }

    private class OneModuleClassLoader
    extends JarClassLoader
    implements Util.ModuleProvider,
    Util.PackageAccessibleClassLoader {
        private int rc;

        public OneModuleClassLoader(List classp, ClassLoader[] parents) throws IllegalArgumentException {
            super(classp, parents, false);
            this.rc = Module.this.releaseCount++;
        }

        public Module getModule() {
            return Module.this;
        }

        protected PermissionCollection getPermissions(CodeSource cs) {
            return Module.getAllPermission();
        }

        protected String findLibrary(String libname) {
            String mapped = System.mapLibraryName(libname);
            File lib = new File(new File(Module.this.jar.getParentFile(), "lib"), mapped);
            if (lib.isFile()) {
                return lib.getAbsolutePath();
            }
            return null;
        }

        protected boolean isSpecialResource(String pkg) {
            if (Module.this.mgr.isSpecialResource(pkg)) {
                return true;
            }
            return super.isSpecialResource(pkg);
        }

        protected boolean shouldDelegateResource(String pkg, ClassLoader parent) {
            if (!super.shouldDelegateResource(pkg, parent)) {
                return false;
            }
            Module other = parent instanceof Util.ModuleProvider ? ((Util.ModuleProvider)((Object)parent)).getModule() : null;
            return Module.this.mgr.shouldDelegateResource(Module.this, other, pkg);
        }

        public String toString() {
            return super.toString() + "[" + Module.this.getCodeNameBase() + "]";
        }

        protected void finalize() throws Throwable {
            super.finalize();
            Util.err.log("Finalize for " + this + ": rc=" + this.rc + " releaseCount=" + Module.this.releaseCount + " released=" + Module.this.released);
            if (this.rc == Module.this.releaseCount) {
                Module.this.released = true;
            } else {
                Util.err.log("Now resources for " + Module.this.getCodeNameBase() + " have been released.");
            }
        }
    }
}

