/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.modules;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.netbeans.core.NbTopManager;
import org.netbeans.core.modules.DuplicateException;
import org.netbeans.core.modules.Events;
import org.netbeans.core.modules.Module;
import org.netbeans.core.modules.ModuleHistory;
import org.netbeans.core.modules.ModuleList;
import org.netbeans.core.modules.ModuleManager;
import org.netbeans.core.modules.NbEvents;
import org.netbeans.core.modules.NbInstaller;
import org.netbeans.core.modules.TestModuleDeployer;
import org.netbeans.core.modules.Util;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;

public final class ModuleSystem {
    private final ModuleManager mgr;
    private final NbInstaller installer;
    private final ModuleList list;
    private final Events ev = Boolean.getBoolean("netbeans.modules.quiet") ? new QuietEvents() : new NbEvents();
    private Set bootModules = null;

    public ModuleSystem(FileSystem systemFileSystem) throws IOException {
        this.installer = new NbInstaller(this.ev);
        this.mgr = new ModuleManager(this.installer, this.ev);
        PropertyChangeListener l = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent ev) {
                if ("classLoader".equals(ev.getPropertyName())) {
                    NbTopManager.Lkp.systemClassLoaderChanged(ModuleSystem.this.mgr.getClassLoader());
                }
            }
        };
        this.mgr.addPropertyChangeListener(l);
        NbTopManager.Lkp.systemClassLoaderChanged(this.mgr.getClassLoader());
        NbTopManager.Lkp.moduleLookupReady(this.mgr.getModuleLookup());
        if (systemFileSystem.isReadOnly()) {
            this.list = null;
        } else {
            FileObject root = systemFileSystem.getRoot();
            FileObject modulesFolder = root.getFileObject("Modules");
            if (modulesFolder == null) {
                modulesFolder = root.createFolder("Modules");
            }
            this.list = new ModuleList(this.mgr, modulesFolder, this.ev);
            this.installer.registerList(this.list);
            this.installer.registerManager(this.mgr);
        }
        this.ev.log("createdModuleSystem");
    }

    public ModuleManager getManager() {
        return this.mgr;
    }

    public Events getEvents() {
        return this.ev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getModuleJars() {
        this.mgr.mutexPrivileged().enterReadAccess();
        try {
            Iterator modules = this.mgr.getEnabledModules().iterator();
            ArrayList l = new ArrayList();
            while (modules.hasNext()) {
                l.addAll(((Module)((Object)modules.next())).getAllJars());
            }
            ArrayList arrayList = l;
            return arrayList;
        }
        finally {
            this.mgr.mutexPrivileged().exitReadAccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadBootModules() {
        ArrayList<String> ignoredPrefixes = new ArrayList<String>(3);
        try {
            String jdk = System.getProperty("java.home");
            if (jdk.endsWith(File.separator + "jre")) {
                jdk = jdk.substring(0, jdk.length() - 4);
            }
            File f = new File(jdk);
            ignoredPrefixes.add("jar:" + f.toURI().toURL());
            String nbhomeS = System.getProperty("netbeans.home");
            if (nbhomeS != null) {
                File nbhome = new File(nbhomeS);
                f = new File(new File(nbhome, "lib"), "ext");
                ignoredPrefixes.add("jar:" + f.toURI().toURL());
                f = new File(new File(new File(nbhome, "modules"), "autoload"), "ext");
                ignoredPrefixes.add("jar:" + f.toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            Util.err.notify(1, (Throwable)e);
        }
        if (Util.err.isLoggable(1)) {
            Util.err.log("ignoredPrefixes=" + ignoredPrefixes);
        }
        this.mgr.mutexPrivileged().enterWriteAccess();
        this.ev.log("startLoadBootModules");
        try {
            try {
                this.bootModules = new HashSet(10);
                ClassLoader loader = ModuleSystem.class.getClassLoader();
                Enumeration<URL> e = loader.getResources("META-INF/MANIFEST.MF");
                this.ev.log("perfTick", "got all manifests");
                HashSet<URL> checkedManifests = new HashSet<URL>();
                block13: while (e.hasMoreElements()) {
                    InputStream is;
                    URL manifestUrl = e.nextElement();
                    if (!checkedManifests.add(manifestUrl)) continue;
                    String manifestUrlS = manifestUrl.toExternalForm();
                    Iterator it = ignoredPrefixes.iterator();
                    while (it.hasNext()) {
                        if (!manifestUrlS.startsWith((String)it.next())) continue;
                        continue block13;
                    }
                    if (Util.err.isLoggable(1)) {
                        Util.err.log("Checking boot manifest: " + manifestUrlS);
                    }
                    try {
                        is = manifestUrl.openStream();
                    }
                    catch (IOException ioe) {
                        Util.err.annotate((Throwable)ioe, 0, "URL: " + manifestUrl, null, null, null);
                        throw ioe;
                    }
                    try {
                        Manifest mani = new Manifest(is);
                        Attributes attr = mani.getMainAttributes();
                        if (attr.getValue("OpenIDE-Module") == null) continue;
                        this.bootModules.add(this.mgr.createFixed(mani, manifestUrl, loader));
                    }
                    finally {
                        is.close();
                    }
                }
                if (this.list == null) {
                    this.mgr.enable(this.bootModules);
                }
                this.ev.log("perfTick", "added all classpath modules");
            }
            catch (IOException ioe) {
                Util.err.notify((Throwable)ioe);
                Object var13_17 = null;
                this.ev.log("finishLoadBootModules");
                this.mgr.mutexPrivileged().exitWriteAccess();
                return;
            }
            catch (DuplicateException de) {
                Util.err.notify((Throwable)de);
                Object var13_18 = null;
                this.ev.log("finishLoadBootModules");
                this.mgr.mutexPrivileged().exitWriteAccess();
                return;
            }
            Object var13_16 = null;
            this.ev.log("finishLoadBootModules");
        }
        catch (Throwable throwable) {
            Object var13_19 = null;
            this.ev.log("finishLoadBootModules");
            this.mgr.mutexPrivileged().exitWriteAccess();
            throw throwable;
        }
        this.mgr.mutexPrivileged().exitWriteAccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readList() {
        this.ev.log("perfStart", "ModuleSystem.readList");
        this.mgr.mutexPrivileged().enterWriteAccess();
        try {
            this.list.readInitial();
        }
        finally {
            this.mgr.mutexPrivileged().exitWriteAccess();
        }
        this.ev.log("perfEnd", "ModuleSystem.readList");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore() {
        this.ev.log("perfStart", "ModuleSystem.restore");
        this.mgr.mutexPrivileged().enterWriteAccess();
        try {
            HashSet toTrigger = new HashSet(this.bootModules);
            this.list.trigger(toTrigger);
        }
        finally {
            this.mgr.mutexPrivileged().exitWriteAccess();
        }
        this.ev.log("perfEnd", "ModuleSystem.restore");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutDown(Runnable midHook) {
        this.mgr.mutexPrivileged().enterWriteAccess();
        try {
            boolean bl = this.mgr.shutDown(midHook);
            return bl;
        }
        finally {
            this.mgr.mutexPrivileged().exitWriteAccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deployTestModule(File jar) throws IOException {
        if (!jar.isAbsolute()) {
            throw new IOException("Absolute paths only please");
        }
        this.mgr.mutexPrivileged().enterWriteAccess();
        this.ev.log("startDeployTestModule", jar);
        System.err.println("Deploying test module " + jar + "...");
        try {
            Module m;
            Module tm = null;
            HashSet toReenable = new HashSet();
            Iterator it = this.mgr.getModules().iterator();
            while (it.hasNext()) {
                m = (Module)((Object)it.next());
                if (!jar.equals(m.getJarFile())) continue;
                if (!m.isReloadable()) {
                    m.setReloadable(true);
                }
                this.turnOffModule(m, toReenable);
                this.mgr.reload(m);
                tm = m;
                break;
            }
            if (tm == null) {
                try {
                    tm = this.mgr.create(jar, new ModuleHistory(jar.getAbsolutePath()), true, false, false);
                }
                catch (DuplicateException dupe) {
                    Module old = dupe.getOldModule();
                    System.err.println("Replacing old module in " + old.getJarFile());
                    this.turnOffModule(old, toReenable);
                    this.mgr.delete(old);
                    try {
                        tm = this.mgr.create(jar, new ModuleHistory(jar.getAbsolutePath()), true, false, false);
                    }
                    catch (DuplicateException dupe2) {
                        IOException ioe = new IOException(dupe2.toString());
                        Util.err.annotate((Throwable)ioe, (Throwable)dupe2);
                        throw ioe;
                    }
                }
            }
            System.err.println("Enabling " + tm.getJarFile() + "...");
            if (!this.mgr.simulateEnable(Collections.singleton(tm)).contains((Object)tm)) {
                throw new IOException("Cannot enable " + tm.getJarFile() + "; problems: " + tm.getProblems());
            }
            this.mgr.enable(tm);
            if (!toReenable.isEmpty()) {
                System.err.println("Also re-enabling:");
                it = toReenable.iterator();
                while (it.hasNext()) {
                    m = (Module)((Object)it.next());
                    System.err.println("\t" + m.getDisplayName());
                    if (!m.isReloadable()) continue;
                    m.reload();
                }
                try {
                    this.mgr.enable(toReenable);
                }
                catch (IllegalArgumentException iae) {
                    throw new IOException(iae.toString());
                }
            }
            System.err.println("Done.");
            Object var10_11 = null;
            this.ev.log("finishDeployTestModule", jar);
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.ev.log("finishDeployTestModule", jar);
            this.mgr.mutexPrivileged().exitWriteAccess();
            throw throwable;
        }
        this.mgr.mutexPrivileged().exitWriteAccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void turnOffModule(Module m, Set toReenable) {
        if (!m.isEnabled()) {
            return;
        }
        Iterator it = this.mgr.simulateDisable(Collections.singleton(m)).iterator();
        while (it.hasNext()) {
            Module m2 = (Module)((Object)it.next());
            if (m2.isAutoload() || m2.isEager()) continue;
            toReenable.add(m2);
        }
        try {
            System.err.println("Disabling " + m.getJarFile() + "...");
            this.mgr.disable(toReenable);
        }
        finally {
            toReenable.remove((Object)m);
        }
    }

    public String getEffectiveClasspath(Module m) {
        return this.installer.getEffectiveClasspath(m);
    }

    private static final class QuietEvents
    extends Events {
        QuietEvents() {
        }

        protected void logged(String message, Object[] args) {
        }
    }

    public static final class TestModuleDeployerImpl
    extends TestModuleDeployer {
        public void deployTestModule(File jar) throws IOException {
            NbTopManager.get().getModuleSystem().deployTestModule(jar);
        }
    }
}

