/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.projects;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.netbeans.core.perftool.StartLog;
import org.netbeans.core.projects.SystemFileSystem;
import org.netbeans.core.projects.cache.LayerCacheManager;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ModuleLayeredFileSystem
extends MultiFileSystem {
    private static final long serialVersionUID = 782910986724201983L;
    private static final String LAYER_STAMP = "layer-stamp.txt";
    static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.core.projects");
    private List urls;
    private LayerCacheManager manager;
    private final FileSystem writableLayer;
    private FileSystem cacheLayer;
    private final FileSystem[] otherLayers;

    ModuleLayeredFileSystem(FileSystem writableLayer, FileSystem[] otherLayers, File cacheDir) throws IOException {
        this(writableLayer, otherLayers, ModuleLayeredFileSystem.manager(cacheDir));
    }

    private ModuleLayeredFileSystem(FileSystem writableLayer, FileSystem[] otherLayers, LayerCacheManager mgr) throws IOException {
        this(writableLayer, otherLayers, mgr, ModuleLayeredFileSystem.loadCache(mgr));
    }

    private ModuleLayeredFileSystem(FileSystem writableLayer, FileSystem[] otherLayers, LayerCacheManager mgr, FileSystem cacheLayer) throws IOException {
        super(ModuleLayeredFileSystem.appendLayers(writableLayer, otherLayers, cacheLayer));
        this.manager = mgr;
        this.writableLayer = writableLayer;
        this.otherLayers = otherLayers;
        this.cacheLayer = cacheLayer;
        this.setPropagateMasks(true);
        this.urls = null;
    }

    private static LayerCacheManager manager(File cacheDir) throws IOException {
        if (cacheDir != null) {
            if (!cacheDir.isDirectory() && !cacheDir.mkdirs()) {
                throw new IOException("Could not make dir: " + cacheDir);
            }
            String defaultManager = "org.netbeans.core.projects.cache.BinaryCacheManager";
            String managerName = System.getProperty("netbeans.cache.layers", defaultManager);
            if (managerName.equals("-")) {
                err.log("Cache manager disabled");
                return LayerCacheManager.emptyManager();
            }
            try {
                Class<?> c = Class.forName(managerName);
                Constructor<?> ctor = c.getConstructor(File.class);
                LayerCacheManager mgr = (LayerCacheManager)ctor.newInstance(cacheDir);
                err.log("Using cache manager of type " + managerName + " in " + cacheDir);
                return mgr;
            }
            catch (Exception e) {
                IOException ioe = new IOException(e.toString());
                err.annotate((Throwable)ioe, (Throwable)e);
                throw ioe;
            }
        }
        err.log("No cache manager");
        return LayerCacheManager.emptyManager();
    }

    private static FileSystem loadCache(LayerCacheManager mgr) throws IOException {
        if (mgr.cacheExists()) {
            FileSystem fs;
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)ModuleLayeredFileSystem.class, (String)"MSG_start_load_cache"));
            String msg = "Loading layers from " + mgr.getCacheDirectory();
            StartLog.logStart(msg);
            try {
                fs = mgr.createLoadedFileSystem();
            }
            catch (IOException ioe) {
                err.notify(1, (Throwable)ioe);
                mgr.cleanupCache();
                ModuleLayeredFileSystem.cleanStamp(mgr.getCacheDirectory());
                fs = mgr.createEmptyFileSystem();
            }
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)ModuleLayeredFileSystem.class, (String)"MSG_end_load_cache"));
            StartLog.logEnd(msg);
            return fs;
        }
        return mgr.createEmptyFileSystem();
    }

    private static FileSystem[] appendLayers(FileSystem fs1, FileSystem[] fs2s, FileSystem fs3) {
        ArrayList<FileSystem> l = new ArrayList<FileSystem>(fs2s.length + 2);
        l.add(fs1);
        l.addAll(Arrays.asList(fs2s));
        l.add(fs3);
        return l.toArray(new FileSystem[l.size()]);
    }

    private static void cleanStamp(File cacheDir) throws IOException {
        File stampFile = new File(cacheDir, LAYER_STAMP);
        if (stampFile.exists() && !stampFile.delete()) {
            throw new IOException("Could not delete: " + stampFile);
        }
    }

    public final FileSystem[] getLayers() {
        return this.getDelegates();
    }

    final FileSystem getWritableLayer() {
        return this.writableLayer;
    }

    public static ModuleLayeredFileSystem getInstallationModuleLayer() {
        FileSystem fs = Repository.getDefault().getDefaultFileSystem();
        SystemFileSystem sfs = (SystemFileSystem)fs;
        ModuleLayeredFileSystem home = sfs.getInstallationLayer();
        if (home != null) {
            return home;
        }
        return sfs.getUserLayer();
    }

    public static ModuleLayeredFileSystem getUserModuleLayer() {
        SystemFileSystem sfs = (SystemFileSystem)Repository.getDefault().getDefaultFileSystem();
        return sfs.getUserLayer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setURLs(final List urls) throws Exception {
        Stamp stamp;
        File stampFile;
        if (urls.contains(null)) {
            throw new NullPointerException("urls=" + urls);
        }
        if (err.isLoggable(1)) {
            err.log("setURLs: " + urls);
        }
        if (this.urls != null && ((Object)urls).equals(this.urls)) {
            err.log("no-op");
            return;
        }
        StartLog.logStart("setURLs");
        final File cacheDir = this.manager.getCacheDirectory();
        if (cacheDir != null) {
            stampFile = new File(cacheDir, LAYER_STAMP);
            stamp = new Stamp(this.manager.getClass().getName(), urls);
        } else {
            stampFile = null;
            stamp = null;
        }
        if (cacheDir != null && stampFile.isFile()) {
            err.log("Stamp of new URLs: " + stamp.getHash());
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(stampFile), "UTF-8"));
            try {
                long hash;
                String line = r.readLine();
                try {
                    hash = Long.parseLong(line);
                }
                catch (NumberFormatException nfe) {
                    throw new IOException(nfe.toString());
                }
                err.log("Stamp in the cache: " + hash);
                if (hash == stamp.getHash()) {
                    err.log("Cache hit!");
                    this.urls = urls;
                    StartLog.logEnd("setURLs");
                    return;
                }
            }
            finally {
                r.close();
            }
        }
        this.runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                ModuleLayeredFileSystem moduleLayeredFileSystem = ModuleLayeredFileSystem.this;
                synchronized (moduleLayeredFileSystem) {
                    if (cacheDir != null) {
                        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$core$projects$ModuleLayeredFileSystem == null ? (class$org$netbeans$core$projects$ModuleLayeredFileSystem = ModuleLayeredFileSystem.class$("org.netbeans.core.projects.ModuleLayeredFileSystem")) : class$org$netbeans$core$projects$ModuleLayeredFileSystem), (String)"MSG_start_rewrite_cache"));
                        err.log("Rewriting cache in " + cacheDir);
                    }
                    try {
                        if (ModuleLayeredFileSystem.this.manager.supportsLoad()) {
                            ModuleLayeredFileSystem.this.manager.store(ModuleLayeredFileSystem.this.cacheLayer, urls);
                        } else {
                            ModuleLayeredFileSystem.this.cacheLayer = ModuleLayeredFileSystem.this.manager.store(urls);
                            ModuleLayeredFileSystem.this.setDelegates(ModuleLayeredFileSystem.appendLayers(ModuleLayeredFileSystem.this.writableLayer, ModuleLayeredFileSystem.this.otherLayers, ModuleLayeredFileSystem.this.cacheLayer));
                        }
                    }
                    catch (IOException ioe) {
                        err.notify(1, (Throwable)ioe);
                        err.log("Abandoning cache manager");
                        ModuleLayeredFileSystem.this.manager.cleanupCache();
                        ModuleLayeredFileSystem.cleanStamp(cacheDir);
                        ModuleLayeredFileSystem.this.manager = LayerCacheManager.emptyManager();
                        try {
                            if (ModuleLayeredFileSystem.this.manager.supportsLoad()) {
                                ModuleLayeredFileSystem.this.cacheLayer = ModuleLayeredFileSystem.this.manager.createEmptyFileSystem();
                                ModuleLayeredFileSystem.this.manager.store(ModuleLayeredFileSystem.this.cacheLayer, urls);
                            } else {
                                ModuleLayeredFileSystem.this.cacheLayer = ModuleLayeredFileSystem.this.manager.store(urls);
                            }
                            ModuleLayeredFileSystem.this.setDelegates(ModuleLayeredFileSystem.appendLayers(ModuleLayeredFileSystem.this.writableLayer, ModuleLayeredFileSystem.this.otherLayers, ModuleLayeredFileSystem.this.cacheLayer));
                        }
                        catch (IOException ioe2) {
                            err.notify((Throwable)ioe2);
                        }
                        return;
                    }
                    if (stampFile != null) {
                        OutputStreamWriter wr = new OutputStreamWriter((OutputStream)new FileOutputStream(stampFile), "UTF-8");
                        try {
                            wr.write(Long.toString(stamp.getHash()));
                            wr.write("\nLine above is identifying hash key, do not edit!\nBelow is metadata about layer cache, for debugging purposes.\n");
                            wr.write(stamp.toString());
                        }
                        finally {
                            ((Writer)wr).close();
                        }
                    }
                    if (cacheDir != null) {
                        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$core$projects$ModuleLayeredFileSystem == null ? (class$org$netbeans$core$projects$ModuleLayeredFileSystem = ModuleLayeredFileSystem.class$("org.netbeans.core.projects.ModuleLayeredFileSystem")) : class$org$netbeans$core$projects$ModuleLayeredFileSystem), (String)"MSG_end_rewrite_cache"));
                        err.log("Finished rewriting cache in " + cacheDir);
                    }
                }
            }
        });
        this.urls = urls;
        this.firePropertyChange("layers", null, null);
        StartLog.logEnd("setURLs");
    }

    public void addURLs(Collection urls) throws Exception {
        if (urls.contains(null)) {
            throw new NullPointerException("urls=" + urls);
        }
        ArrayList arr = new ArrayList(urls);
        if (this.urls != null) {
            arr.addAll(this.urls);
        }
        this.setURLs(arr);
    }

    public void removeURLs(Collection urls) throws Exception {
        if (urls.contains(null)) {
            throw new NullPointerException("urls=" + urls);
        }
        ArrayList arr = new ArrayList();
        if (this.urls != null) {
            arr.addAll(this.urls);
        }
        arr.removeAll(urls);
        this.setURLs(arr);
    }

    private static final class Stamp
    implements Comparator {
        private final String managerName;
        private final List urls;
        private final long[] times;
        private final long hash;

        public Stamp(String name, List urls) throws IOException {
            this.managerName = name;
            this.urls = new ArrayList(urls);
            Collections.sort(this.urls, this);
            this.times = new long[this.urls.size()];
            long x = 0x11L ^ (long)this.managerName.hashCode();
            Iterator it = this.urls.iterator();
            int i = 0;
            while (it.hasNext()) {
                URL u2;
                URL u = (URL)it.next();
                String s = u.toExternalForm();
                x += 3199876987199633L;
                x ^= (long)s.hashCode();
                if (s.startsWith("jar:")) {
                    int bangSlash = s.lastIndexOf("!/");
                    if (bangSlash != -1) {
                        u2 = new URL(s.substring(4, bangSlash));
                    } else {
                        err.log(16, "Weird JAR URL: " + u);
                        u2 = u;
                    }
                } else {
                    u2 = u;
                }
                File extracted = Utilities.toFile((URL)u2);
                if (extracted != null) {
                    int n = i++;
                    long l = extracted.lastModified();
                    this.times[n] = l;
                    x ^= l;
                    continue;
                }
                this.times[i++] = 0L;
            }
            this.hash = x;
        }

        public long getHash() {
            return this.hash;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.managerName);
            buf.append('\n');
            Iterator it = this.urls.iterator();
            int i = 0;
            while (it.hasNext()) {
                long t;
                if ((t = this.times[i++]) == 0L) {
                    buf.append("<file not found>");
                } else {
                    buf.append(new Date(t));
                }
                buf.append('\t');
                buf.append(it.next());
                buf.append('\n');
            }
            return buf.toString();
        }

        public int compare(Object o1, Object o2) {
            return ((URL)o1).toString().compareTo(((URL)o2).toString());
        }
    }
}

