/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.netbeans.core.ui.ModuleBean;
import org.netbeans.core.ui.ModuleNode;
import org.openide.WizardDescriptor;
import org.openide.cookies.InstanceCookie;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerPanel;
import org.openide.explorer.view.TreeTableView;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;

public class ModuleSelectionPanel
extends JPanel
implements PropertyChangeListener {
    private static final String PROP_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";
    private static final String PROP_CONTENT_DATA = "WizardPanel_contentData";
    private final ModuleBean.AllModulesBean allModules = ModuleBean.AllModulesBean.getDefault();
    private static final int DEF_TREE_WIDTH = 320;
    private static final int DEF_0_COL_WIDTH = 60;
    private static final int DEF_1_COL_WIDTH = 150;
    private static final int DEF_HEIGHT = 250;
    private JTextArea descriptionArea;
    private JLabel descriptionLabel;
    private JScrollPane descriptionPane;
    private ExplorerPanel explorerPanel;
    private JLabel tableLabel;
    private TreeTableView treeTableView;
    private ExplorerManager manager;

    public ModuleSelectionPanel() {
        this.putClientProperty(PROP_CONTENT_SELECTED_INDEX, new Integer(0));
        String name = NbBundle.getMessage((Class)ModuleSelectionPanel.class, (String)"LBL_SetupWizardModuleInstallation");
        this.putClientProperty(PROP_CONTENT_DATA, new String[]{name});
        this.setName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        super.addNotify();
        if (this.treeTableView != null) {
            return;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            this.initComponents();
            this.treeTableView.setProperties(new Node.Property[]{new PropertySupport.ReadWrite("enabled", Boolean.TYPE, NbBundle.getMessage((Class)ModuleNode.class, (String)"PROP_modules_enabled"), NbBundle.getMessage((Class)ModuleNode.class, (String)"HINT_modules_enabled")){

                public Object getValue() {
                    return null;
                }

                public void setValue(Object o) {
                }
            }, new PropertySupport.ReadOnly("specificationVersion", String.class, NbBundle.getMessage((Class)ModuleNode.class, (String)"PROP_modules_specversion"), NbBundle.getMessage((Class)ModuleNode.class, (String)"HINT_modules_specversion")){

                public Object getValue() {
                    return null;
                }
            }});
            Font f = UIManager.getFont("controlFont");
            Integer i = (Integer)UIManager.get("nbDefaultFontSize");
            if (i == null) {
                i = new Integer(11);
            }
            if (f == null) {
                f = this.getFont();
            }
            if (f.getSize() > i) {
                this.sizeTTVCarefully();
            } else {
                this.treeTableView.setPreferredSize(new Dimension(530, 250));
                this.treeTableView.setTreePreferredWidth(320);
                this.treeTableView.setTableColumnPreferredWidth(0, 60);
                this.treeTableView.setTableColumnPreferredWidth(1, 150);
            }
            this.treeTableView.setPopupAllowed(false);
            this.treeTableView.setDefaultActionAllowed(false);
            this.treeTableView.setBorder((Border)UIManager.get("Nb.ScrollPane.border"));
            this.manager = this.explorerPanel.getExplorerManager();
            ModuleNode node = new ModuleNode(true);
            this.manager.setRootContext((Node)node);
            this.initAccessibility();
        }
    }

    private void sizeTTVCarefully() {
        Font headerFont = (Font)UIManager.getDefaults().get("TableHeader.font");
        Font tableFont = (Font)UIManager.getDefaults().get("Table.font");
        FontMetrics headerFm = this.getFontMetrics(headerFont);
        int enabledColWidth = Math.max(60, headerFm.stringWidth(NbBundle.getMessage((Class)ModuleNode.class, (String)"PROP_modules_enabled")) + 20);
        int specColWidth = Math.max(150, headerFm.stringWidth(NbBundle.getMessage((Class)ModuleNode.class, (String)"PROP_modules_specversion")) + 20);
        int defFontSize = UIManager.getDefaults().getInt("nbDefaultFontSize");
        int treeWidth = 320 + 10 * (tableFont.getSize() - defFontSize);
        this.treeTableView.setPreferredSize(new Dimension(treeWidth + enabledColWidth + specColWidth, 250 + 10 * (tableFont.getSize() - defFontSize)));
        this.treeTableView.setTreePreferredWidth(treeWidth);
        this.treeTableView.setTableColumnPreferredWidth(0, enabledColWidth);
        this.treeTableView.setTableColumnPreferredWidth(1, specColWidth);
    }

    private void initComponents() {
        this.tableLabel = new JLabel();
        this.explorerPanel = new ExplorerPanel();
        this.treeTableView = new TreeTableView();
        this.descriptionLabel = new JLabel();
        this.descriptionPane = new JScrollPane();
        this.descriptionArea = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.setName(NbBundle.getMessage((Class)ModuleSelectionPanel.class, (String)"LBL_SetupWizardModuleInstallation"));
        this.tableLabel.setLabelFor((Component)this.treeTableView);
        this.tableLabel.setText(NbBundle.getMessage((Class)ModuleSelectionPanel.class, (String)"LBL_SetupWizardCheckModules"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 1, 5, 0);
        this.add((Component)this.tableLabel, gridBagConstraints);
        this.explorerPanel.add((Component)this.treeTableView, (Object)"Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.explorerPanel, gridBagConstraints);
        this.descriptionLabel.setLabelFor(this.descriptionArea);
        this.descriptionLabel.setText(NbBundle.getMessage((Class)ModuleSelectionPanel.class, (String)"LBL_SetupWizardDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 1, 5, 0);
        this.add((Component)this.descriptionLabel, gridBagConstraints);
        this.descriptionPane.setMinimumSize(new Dimension(22, 80));
        this.descriptionPane.setPreferredSize(new Dimension(50, 80));
        this.descriptionArea.setEditable(false);
        this.descriptionArea.setLineWrap(true);
        this.descriptionArea.setWrapStyleWord(true);
        this.descriptionPane.setViewportView(this.descriptionArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        this.add((Component)this.descriptionPane, gridBagConstraints);
    }

    private void prevButtonActionPerformed(ActionEvent evt) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.manager) {
            if ("selectedNodes".equals(evt.getPropertyName())) {
                InstanceCookie inst;
                Node[] nodes = this.manager.getSelectedNodes();
                String text = "";
                if (nodes.length == 1 && (inst = (InstanceCookie)nodes[0].getCookie(InstanceCookie.class)) != null) {
                    try {
                        if (inst.instanceClass() == ModuleBean.class) {
                            ModuleBean bean = (ModuleBean)inst.instanceCreate();
                            text = bean.getLongDescription();
                        }
                    }
                    catch (IOException ioe) {
                    }
                    catch (ClassNotFoundException cnfe) {
                        // empty catch block
                    }
                }
                this.descriptionArea.setText(text);
                this.descriptionArea.setCaretPosition(0);
                return;
            }
        }
        if (!(evt.getSource() instanceof WizardDescriptor)) return;
        if (!"value".equals(evt.getPropertyName())) return;
        WizardDescriptor wd = (WizardDescriptor)evt.getSource();
        if (wd.getValue() != WizardDescriptor.CANCEL_OPTION) {
            if (wd.getValue() != WizardDescriptor.CLOSED_OPTION) {
                if (wd.getValue() != WizardDescriptor.FINISH_OPTION) return;
                wd.removePropertyChangeListener((PropertyChangeListener)this);
                this.allModules.resume();
                return;
            }
        }
        wd.removePropertyChangeListener((PropertyChangeListener)this);
        this.allModules.cancel();
    }

    public void initAccessibility() {
        ResourceBundle b = NbBundle.getBundle(this.getClass());
        this.getAccessibleContext().setAccessibleDescription(b.getString("ACSD_ModuleSelectionPanel"));
        this.tableLabel.setDisplayedMnemonic(b.getString("LBL_SetupWizardCheckModules_MNE").charAt(0));
        this.tableLabel.getAccessibleContext().setAccessibleDescription(b.getString("ACSD_tableLabel"));
        this.descriptionLabel.setDisplayedMnemonic(b.getString("LBL_SetupWizardDescription_MNE").charAt(0));
        this.descriptionLabel.getAccessibleContext().setAccessibleDescription(b.getString("ACSD_descriptionLabel"));
    }

    public void initFromSettings(Object settings) {
        if (settings instanceof WizardDescriptor) {
            ((WizardDescriptor)settings).addPropertyChangeListener((PropertyChangeListener)this);
        }
        this.addNotify();
        this.manager.addPropertyChangeListener((PropertyChangeListener)this);
        this.allModules.pause();
    }

    public void storeSettings(Object settings) {
        this.manager.removePropertyChangeListener((PropertyChangeListener)this);
    }
}

