/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.layout;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jgraph.graph.CellView;
import org.jgraph.graph.GraphModel;
import org.jgraph.layout.TreeLayoutAlgorithm;

public class OrderedTreeLayoutAlgorithm
extends TreeLayoutAlgorithm {
    private Comparator comparator = null;

    public OrderedTreeLayoutAlgorithm(Comparator comparator) {
        this.setComparator(comparator);
    }

    public OrderedTreeLayoutAlgorithm() {
        this.setComparator(new DefaultComparator());
    }

    public String toString() {
        return "Ordered Tree Layout";
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public List getChildren(CellView cellView) {
        List list = super.getChildren(cellView);
        if (null == this.comparator) {
            Collections.sort(list);
        } else {
            Collections.sort(list, this.comparator);
        }
        return list;
    }

    public class DefaultComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            if (object instanceof CellView && object2 instanceof CellView) {
                GraphModel graphModel = OrderedTreeLayoutAlgorithm.this.graph.getModel();
                Object object3 = ((CellView)object).getCell();
                Object object4 = ((CellView)object2).getCell();
                Object object5 = graphModel.getParent(object3);
                Object object6 = graphModel.getParent(object4);
                int n = object5 == null ? graphModel.getIndexOfRoot(object3) : graphModel.getIndexOfChild(object5, object3);
                int n2 = object6 == null ? graphModel.getIndexOfRoot(object4) : graphModel.getIndexOfChild(object6, object4);
                return new Integer(n).compareTo(new Integer(n2));
            }
            return -1;
        }
    }
}

