/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.freeradius;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import net.sf.jradius.exception.RadiusException;
import net.sf.jradius.freeradius.FreeRadiusFormat;
import net.sf.jradius.freeradius.FreeRadiusRequest;
import net.sf.jradius.handler.chain.JRCommand;
import net.sf.jradius.log.RadiusLog;
import net.sf.jradius.packet.PacketFactory;
import net.sf.jradius.packet.RadiusPacket;
import net.sf.jradius.packet.attribute.AttributeList;
import net.sf.jradius.server.JRadiusServer;
import net.sf.jradius.server.RadiusProcessor;
import net.sf.jradius.server.config.Configuration;

public class FreeRadiusProcessor
extends RadiusProcessor {
    private static final FreeRadiusFormat format = new FreeRadiusFormat();

    protected void processSocket(Socket socket) throws IOException, RadiusException {
        FreeRadiusRequest request = new FreeRadiusRequest();
        DataInputStream in = new DataInputStream(socket.getInputStream());
        int nameLength = in.readInt();
        byte[] nameBytes = new byte[nameLength];
        in.readFully(nameBytes);
        byte messageType = in.readByte();
        byte packetCount = in.readByte();
        RadiusPacket[] rp = PacketFactory.parse(in, packetCount);
        int length = in.readInt();
        byte[] bConfig = new byte[length];
        in.readFully(bConfig);
        AttributeList configItems = new AttributeList();
        format.unpackAttributes(configItems, bConfig, length);
        request.setSender(new String(nameBytes));
        request.setType(messageType);
        request.setPackets(rp);
        request.setConfigItems(configItems);
        int result = this.runPacketHandlers(request);
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(outBytes);
        if (Configuration.isDebug()) {
            request.printDebugInfo(System.out);
        }
        out.writeByte(result);
        out.writeByte(packetCount);
        for (int i = 0; i < rp.length; ++i) {
            if (rp[i] == null) {
                out.writeByte(0);
                out.writeInt(0);
                continue;
            }
            out.write(format.packPacket(rp[i]));
        }
        byte[] bConfigItems = format.packAttributeList(request.getConfigItems());
        out.writeInt(bConfigItems.length);
        out.write(bConfigItems);
        out.close();
        OutputStream outs = socket.getOutputStream();
        outs.write(outBytes.toByteArray());
        outs.close();
        in.close();
        socket.close();
    }

    protected void logReturnCode(int result, JRCommand handler) {
        switch (result) {
            case 1: 
            case 4: 
            case 6: {
                RadiusLog.error("Error: Packet handler returned " + JRadiusServer.resultCodeToString(result) + ". Stopped handling this packet.");
                break;
            }
            case 0: 
            case 3: {
                RadiusLog.info("Packet handler returned " + JRadiusServer.resultCodeToString(result) + ". Stopped handling this packet.");
                break;
            }
            default: {
                RadiusLog.debug("Packet handler " + handler.getName() + " returned " + JRadiusServer.resultCodeToString(result) + ". Continue handling this packet.");
            }
        }
    }
}

