/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.handler;

import java.net.InetAddress;
import net.sf.jradius.dictionary.Attr_ReplyMessage;
import net.sf.jradius.dictionary.vsa_jradius.Attr_JRadiusRequestId;
import net.sf.jradius.dictionary.vsa_jradius.Attr_JRadiusSessionId;
import net.sf.jradius.exception.RadiusException;
import net.sf.jradius.handler.RadiusSessionHandler;
import net.sf.jradius.log.RadiusLog;
import net.sf.jradius.log.RadiusLogEntry;
import net.sf.jradius.packet.AccessRequest;
import net.sf.jradius.packet.AccountingRequest;
import net.sf.jradius.packet.RadiusPacket;
import net.sf.jradius.packet.attribute.AttributeList;
import net.sf.jradius.packet.attribute.RadiusAttribute;
import net.sf.jradius.server.JRadiusRequest;
import net.sf.jradius.session.JRadiusSession;
import net.sf.jradius.session.JRadiusSessionManager;

public class InitSessionHandler
extends RadiusSessionHandler {
    public boolean handle(JRadiusRequest request) throws RadiusException {
        JRadiusSession session;
        RadiusPacket req = request.getRequestPacket();
        RadiusPacket rep = request.hasReplyPacket() ? request.getReplyPacket() : null;
        AttributeList ci = request.getConfigItems();
        InetAddress cIP = (InetAddress)req.getAttributeValue(1052);
        String fullUserName = (String)req.getAttributeValue(1);
        String nasId = (String)req.getAttributeValue(32);
        String stripUserName = null;
        String realm = null;
        String error = null;
        if (fullUserName == null) {
            RadiusLog.warn("No User-Name found in RadiusPacket!\n" + req.toString());
            if (req instanceof AccountingRequest) {
                request.setReturnValue(7);
            } else {
                request.setReturnValue(0);
            }
            return true;
        }
        stripUserName = fullUserName;
        String[] s = this.splitUserName(stripUserName);
        if (s != null && s.length == 2) {
            stripUserName = s[0];
            realm = s[1];
        }
        if ((session = request.getSession()) == null) {
            try {
                session = JRadiusSessionManager.getManager().getSession(request);
            }
            catch (RadiusException e) {
                error = e.getMessage();
                String mesg = "Rejecting request: {User-Name = " + fullUserName + ", NAS-Identifier = " + nasId + "}";
                RadiusLog.warn(mesg + ": " + error);
                RadiusLog.problem(request, null, e, mesg);
                request.setReturnValue(0);
                request.addReplyAttribute((RadiusAttribute)new Attr_ReplyMessage(error));
                return true;
            }
            if (session.isNewSession()) {
                try {
                    session.setUsername(stripUserName);
                    session.setRealm(realm);
                    session.setClientIPAddress(cIP.getHostAddress());
                    session.initSession(request);
                }
                catch (RadiusException e) {
                    JRadiusSessionManager.getManager().putSession(session);
                    error = e.getMessage();
                    String mesg = "Rejecting request: {User-Name = " + fullUserName + ", NAS-Identifier = " + nasId + "}";
                    RadiusLog.warn(mesg + ": " + error);
                    request.addReplyAttribute((RadiusAttribute)new Attr_ReplyMessage(error));
                }
            }
        }
        RadiusLogEntry logEntry = session.getLogEntry(request);
        logEntry.setType(request);
        if (logEntry.getClientIPAddress() == null) {
            logEntry.setClientIPAddress(cIP.getHostAddress());
        }
        if (logEntry.getNasIdentifier() == null) {
            logEntry.setNasIdentifier(nasId);
        }
        if (logEntry.getUserName() == null) {
            logEntry.setUserName(fullUserName);
        }
        if (logEntry.getRealm() == null) {
            logEntry.setRealm(realm);
        }
        if (logEntry.getInboundRequest() == null) {
            logEntry.setInboundRequest(req.toString(false));
        }
        request.setSession(session);
        if (error != null) {
            if (req instanceof AccessRequest) {
                logEntry.setType("authorize");
            } else {
                logEntry.setType("accounting");
            }
            logEntry.addMessage(error);
            JRadiusSessionManager.getManager().removeSession(session);
            request.setReturnValue(0);
            return true;
        }
        if (ci.get(1259012098) == null) {
            ci.add((RadiusAttribute)new Attr_JRadiusSessionId(session.getSessionKey()));
        }
        if (ci.get(1259012097) == null) {
            ci.add((RadiusAttribute)new Attr_JRadiusRequestId(Integer.toString((char)req.getIdentifier())));
        }
        return false;
    }
}

