/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.ipdr;

import java.util.LinkedHashMap;
import net.sf.jradius.ipdr.IPDR_Base;
import net.sf.jradius.ipdr.IPDR_PublicWLANAccess;
import net.sf.jradius.log.RadiusLog;
import net.sf.jradius.packet.AccountingRequest;
import net.sf.jradius.packet.RadiusPacket;
import net.sf.jradius.session.JRadiusSession;

public class IPDRLogger {
    private static final LinkedHashMap ipdrList = new LinkedHashMap();

    public static String buildIPDR(String groupId, JRadiusSession radiusSession) throws Exception {
        RadiusPacket p = radiusSession.getLastRadiusRequest().getRequestPacket();
        if (!(p instanceof AccountingRequest)) {
            RadiusLog.error("Can not build IPDR for session without accounting");
            return null;
        }
        if (((AccountingRequest)p).getAccountingStatusType() != 2) {
            RadiusLog.error("Can not build IPDR for session without STOP record");
            return null;
        }
        IPDR_Base ipdr = (IPDR_Base)ipdrList.get(groupId);
        if (ipdr == null) {
            return null;
        }
        return ipdr.toXML(radiusSession);
    }

    static {
        try {
            ipdrList.put("pwlan", new IPDR_PublicWLANAccess());
        }
        catch (Exception e) {
            RadiusLog.error(e.getMessage());
        }
    }
}

