/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.ipdr;

import java.io.IOException;
import java.util.Date;
import net.sf.jradius.exception.UnknownAttributeException;
import net.sf.jradius.ipdr.IPDR_Base;
import net.sf.jradius.packet.RadiusPacket;
import net.sf.jradius.session.JRadiusSession;
import org.ipdr.common.BadCompositeException;
import org.ipdr.utils.IPDRException;
import org.xml.sax.SAXException;

public class IPDR_PublicWLANAccess
extends IPDR_Base {
    public IPDR_PublicWLANAccess() throws SAXException, IOException, IPDRException {
        super("http://www.ipdr.org/public//PublicWLANAccess3.5-A.0.1.xsd");
    }

    protected Object[] getIPDRData(JRadiusSession radiusSession, RadiusPacket p) throws BadCompositeException, UnknownAttributeException {
        Object[] dataObj = new Object[this.openTypeLength];
        Date startTime = radiusSession.getStartTime();
        Date stopTime = radiusSession.getStopTime();
        if (stopTime == null) {
            stopTime = new Date();
        }
        this.attributeToField(p, dataObj, 1, "userName");
        this.attributeToField(p, dataObj, 44, "sessionID");
        this.attributeToField(p, dataObj, 32, "NASID");
        this.attributeToField(p, dataObj, 4, "NASIPaddress");
        this.attributeToField(p, dataObj, 61, "NASPortType");
        this.attributeToField(p, dataObj, 5, "locationPort");
        this.attributeToField(p, dataObj, 8, "userIPAddr");
        this.attributeToField(p, dataObj, 31, "callingStationID");
        this.attributeToField(p, dataObj, 30, "calledStationID");
        this.attributeToField(p, dataObj, 46, "sessionDuration");
        this.addData(dataObj, "locationID", radiusSession.getLocationID(), null);
        this.addData(dataObj, "locationType", radiusSession.getLocationType(), null);
        this.addData(dataObj, "locationName", radiusSession.getLocationName(), null);
        this.addData(dataObj, "locationCity", radiusSession.getLocationCity(), null);
        this.addData(dataObj, "locationStateProvince", radiusSession.getLocationStateProvince(), null);
        this.addData(dataObj, "locationCountryCode", radiusSession.getLocationCountryCode(), null);
        this.addData(dataObj, "timeZoneOffset", new Integer(stopTime.getTimezoneOffset()), null);
        this.addData(dataObj, "inputOctets", new Integer(radiusSession.getTotalOctetsIn().intValue()), null);
        this.addData(dataObj, "outputOctets", new Integer(radiusSession.getTotalOctetsOut().intValue()), null);
        return dataObj;
    }

    protected String getServiceType() {
        return "PublicWLANAccessUsageEntry";
    }

    protected String getNameSpaceID() {
        return "PWA";
    }
}

