/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.log;

import net.sf.jradius.exception.RadiusException;
import net.sf.jradius.packet.AccountingRequest;
import net.sf.jradius.server.JRadiusRequest;
import net.sf.jradius.session.JRadiusSession;

public class RadiusLogEntry {
    private JRadiusSession session;
    private Integer code;
    private String type;
    private String message;
    private String packetId;
    private String clientIPAddress;
    private String nasIdentifier;
    private String userName;
    private String realm;
    private Integer userId;
    private String inboundRequest;
    private String outboundRequest;
    private String inboundReply;
    private String outboundReply;
    private boolean finished = true;
    private boolean committed = false;

    public RadiusLogEntry() {
    }

    public RadiusLogEntry(JRadiusSession session, String packetId) {
        this.session = session;
        this.setPacketId(packetId);
    }

    protected Object setValue(Object n, Object o) {
        if (o == null || !o.equals(n)) {
            this.committed = false;
            return n;
        }
        return o;
    }

    public String getSessionKey() {
        return this.session.getSessionKey();
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = (Integer)this.setValue(code, this.code);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = (String)this.setValue(type, this.type);
    }

    public void setType(JRadiusRequest request) throws RadiusException {
        block0 : switch (request.getType()) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 3: 
            case 4: {
                AccountingRequest req = (AccountingRequest)request.getRequestPacket();
                switch (req.getAccountingStatusType()) {
                    case 1: {
                        this.setType("start");
                        break block0;
                    }
                    case 2: {
                        this.setType("stop");
                        break block0;
                    }
                    case 3: {
                        this.setType("interim");
                        break block0;
                    }
                }
                this.setType("accounting");
                break;
            }
            default: {
                this.setType(request.getTypeString());
            }
        }
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = (String)this.setValue(message, this.message);
    }

    public void addMessage(String message) {
        StringBuffer sb = new StringBuffer();
        if (this.message != null) {
            sb.append(this.message).append(", ");
        }
        sb.append(message);
        this.setMessage(sb.toString());
    }

    public String getClientIPAddress() {
        return this.clientIPAddress;
    }

    public void setClientIPAddress(String clientIP) {
        this.clientIPAddress = (String)this.setValue(clientIP, this.clientIPAddress);
    }

    public String getNasIdentifier() {
        return this.nasIdentifier;
    }

    public void setNasIdentifier(String nasId) {
        this.nasIdentifier = (String)this.setValue(nasId, this.nasIdentifier);
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public Integer getUserId() {
        return this.userId;
    }

    public void setUserId(Integer userId) {
        this.userId = (Integer)this.setValue(userId, this.userId);
    }

    public String getPacketId() {
        return this.packetId;
    }

    public void setPacketId(String packetId) {
        this.packetId = packetId;
    }

    public String getInboundReply() {
        return this.inboundReply;
    }

    public void setInboundReply(String inboundReply) {
        this.inboundReply = (String)this.setValue(inboundReply, this.inboundReply);
    }

    public String getInboundRequest() {
        return this.inboundRequest;
    }

    public void setInboundRequest(String inboundRequest) {
        this.inboundRequest = (String)this.setValue(inboundRequest, this.inboundRequest);
    }

    public String getOutboundReply() {
        return this.outboundReply;
    }

    public void setOutboundReply(String outboundReply) {
        this.outboundReply = (String)this.setValue(outboundReply, this.outboundReply);
    }

    public String getOutboundRequest() {
        return this.outboundRequest;
    }

    public void setOutboundRequest(String outboundRequest) {
        this.outboundRequest = (String)this.setValue(outboundRequest, this.outboundRequest);
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void setCommitted(boolean committed) {
        this.committed = committed;
    }

    public String toString() {
        return "RadiusLogEntry: { type = " + this.type + ", packetId = " + this.packetId + " }: " + this.getMessage();
    }
}

