/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.sf.jradius.packet.RadiusFormat;
import net.sf.jradius.packet.attribute.RadiusAttribute;
import net.sf.jradius.packet.attribute.VSAttribute;
import net.sf.jradius.packet.attribute.value.AttributeValue;

public class DiameterFormat
extends RadiusFormat {
    private static final byte AVP_VENDOR = -128;

    public void packAttribute(DataOutputStream out, RadiusAttribute a) throws IOException {
        AttributeValue attributeValue = a.getValue();
        int length = attributeValue.getLength();
        int padding = (length + 3 & 0xFFFFFFFC) - length;
        if (a instanceof VSAttribute) {
            this.packHeader(out, (VSAttribute)a);
        } else {
            this.formatHeader(out, a);
        }
        attributeValue.getBytes(out);
        while (padding-- > 0) {
            out.writeByte(0);
        }
    }

    public void formatHeader(DataOutputStream out, RadiusAttribute a) throws IOException {
        AttributeValue attributeValue = a.getValue();
        out.writeInt(a.getType());
        out.writeByte(0);
        out.writeByte(0);
        out.writeShort(attributeValue.getLength() + 8);
    }

    public void packHeader(DataOutputStream out, VSAttribute a) throws IOException {
        AttributeValue attributeValue = a.getValue();
        out.writeInt(a.getVsaAttributeType());
        out.writeByte(-128);
        out.writeByte(0);
        out.writeShort(attributeValue.getLength() + 12);
        out.writeInt(a.getVendorId());
    }

    protected int unpackAttributeHeader(DataInputStream in, RadiusFormat.AttributeParseContext ctx) throws IOException {
        ctx.attributeType = in.readInt();
        int flen = in.readInt();
        byte flags = (byte)(flen >> 24 & 0xFF);
        ctx.attributeLength = flen & 0xFFFFFF;
        ctx.headerLength = 8;
        if ((flags & 0xFFFFFF80) > 0) {
            ctx.vendorNumber = in.readInt();
            ctx.headerLength += 4;
        }
        ctx.padding = (ctx.attributeLength + 3 & 0xFFFFFFFC) - ctx.attributeLength;
        return 0;
    }
}

