/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.standard;

import java.util.LinkedList;
import net.sf.jradius.exception.StandardViolatedException;
import net.sf.jradius.packet.AccountingRequest;
import net.sf.jradius.packet.RadiusPacket;
import net.sf.jradius.standard.RadiusStandard;

public class IRAPStandard
extends RadiusStandard {
    static final int[] requiredAccessRequest = new int[]{1, 4, 5, 61, 32, 30, 31};
    static final int[] requiredUAMAccessRequest = new int[]{2};
    static final int[] requiredEAPAccessRequest = new int[]{79, 80};
    static final int[] requiredEAPAccessChallenge = new int[]{79, 80};
    static final int[] requiredEAPAccessReject = new int[]{79, 80};
    static final int[] requiredAccessAccept = new int[]{1};
    static final int[] requiredEAPAccessAccept = new int[]{79, 80, 29, 20381713, 20381712};
    static final int[] requiredAccountingRequest = new int[]{1, 4, 5, 61, 32, 40, 41, 44, 8, 30, 31};
    static final int[] requiredAccountingInterimRequest = new int[]{42, 43, 47, 48, 46};
    static final int[] requiredAccountingStopRequest = new int[]{49};
    private boolean IEEE8021XRequired = false;

    public String getName() {
        return "IRAP";
    }

    public void checkPacket(RadiusPacket p, int[] ignore) throws StandardViolatedException {
        LinkedList missing = new LinkedList();
        boolean testAs8021X = false;
        testAs8021X = this.isIEEE8021XRequired() ? true : p.findAttribute(79) != null;
        block0 : switch (p.getCode()) {
            case 1: {
                IRAPStandard.checkMissing(p, missing, requiredAccessRequest, ignore);
                IRAPStandard.checkMissing(p, missing, testAs8021X ? requiredEAPAccessRequest : requiredUAMAccessRequest, ignore);
                break;
            }
            case 11: {
                if (!testAs8021X) break;
                IRAPStandard.checkMissing(p, missing, requiredEAPAccessChallenge, ignore);
                break;
            }
            case 2: {
                IRAPStandard.checkMissing(p, missing, requiredAccessAccept, ignore);
                if (!testAs8021X) break;
                IRAPStandard.checkMissing(p, missing, requiredEAPAccessAccept, ignore);
                break;
            }
            case 4: {
                IRAPStandard.checkMissing(p, missing, requiredAccountingRequest, ignore);
                switch (((AccountingRequest)p).getAccountingStatusType()) {
                    case 1: {
                        break block0;
                    }
                    case 2: {
                        IRAPStandard.checkMissing(p, missing, requiredAccountingStopRequest, ignore);
                    }
                    case 3: {
                        IRAPStandard.checkMissing(p, missing, requiredAccountingInterimRequest, ignore);
                    }
                }
            }
        }
        if (!missing.isEmpty()) {
            throw new StandardViolatedException(this.getClass(), missing);
        }
    }

    public boolean isIEEE8021XRequired() {
        return this.IEEE8021XRequired;
    }

    public void setIEEE8021XRequired(boolean required) {
        this.IEEE8021XRequired = required;
    }
}

