/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.util;

import gnu.crypto.prng.IRandom;
import gnu.crypto.prng.PRNGFactory;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.jradius.util.RadiusUtils;

public class RadiusRandom {
    static final Map attrib = new LinkedHashMap();
    static final IRandom rand = PRNGFactory.getInstance((String)"MD");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(int length) {
        byte[] result = new byte[length];
        IRandom iRandom = rand;
        synchronized (iRandom) {
            for (int i = 0; i < length; ++i) {
                try {
                    int n = i;
                    result[n] = (byte)(result[n] ^ rand.nextByte());
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public static String getRandomString(int length) {
        return RadiusUtils.byteArrayToHexString(RadiusRandom.getBytes(length));
    }

    static {
        Calendar cal = GregorianCalendar.getInstance();
        byte[] seed = Long.toBinaryString(cal.getTimeInMillis()).getBytes();
        attrib.put("gnu.crypto.prng.md.hash.name", "MD5");
        attrib.put("gnu.crypto.prng.md.seed", seed);
        rand.init(attrib);
    }
}

