/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.ssl.Base64;
import org.apache.commons.ssl.Util;
import org.apache.commons.ssl.util.ReadLine;

public class Base64InputStream
extends FilterInputStream {
    private static final byte[] LINE_ENDING = System.getProperty("line.separator").getBytes();
    final boolean decodeMode;
    final ReadLine readLine = new ReadLine(this.in);
    byte[] currentLine = null;
    int pos = 0;

    public Base64InputStream(InputStream base64, boolean decodeMode) {
        super(base64);
        this.decodeMode = decodeMode;
    }

    public int read() throws IOException {
        this.getLine();
        if (this.currentLine == null) {
            return -1;
        }
        byte b = this.currentLine[this.pos++];
        if (this.pos >= this.currentLine.length) {
            this.currentLine = null;
        }
        return b;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        this.getLine();
        if (this.currentLine == null) {
            return -1;
        }
        int size = Math.min(this.currentLine.length - this.pos, len);
        System.arraycopy(this.currentLine, this.pos, b, off, size);
        if (size >= this.currentLine.length - this.pos) {
            this.currentLine = null;
        } else {
            this.pos += size;
        }
        return size;
    }

    private void getLine() throws IOException {
        if (this.currentLine == null) {
            if (this.decodeMode) {
                byte[] line = this.readLine.nextAsBytes(100);
                if (line != null) {
                    this.currentLine = Base64.decodeBase64(line);
                }
            } else {
                byte[] b = Util.streamToBytes(this.in, 48);
                if (b.length > 0) {
                    b = Base64.encodeBase64(b);
                    int lfLen = LINE_ENDING.length;
                    this.currentLine = new byte[b.length + lfLen];
                    System.arraycopy(b, 0, this.currentLine, 0, b.length);
                    System.arraycopy(LINE_ENDING, 0, this.currentLine, b.length, lfLen);
                }
            }
            this.pos = 0;
        }
    }
}

