/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.validation.message;

import com.jgoodies.validation.Severity;
import com.jgoodies.validation.message.AbstractValidationMessage;

public class PropertyValidationMessage
extends AbstractValidationMessage {
    private final Object target;
    private final String role;
    private final String property;

    public PropertyValidationMessage(String text, Object target, String role, String property) {
        this(Severity.WARNING, text, target, role, property);
    }

    public PropertyValidationMessage(Severity severity, String text, Object target, String role, String property) {
        super(text, severity);
        if (target == null) {
            throw new NullPointerException("The target must not be null.");
        }
        if (role == null) {
            throw new NullPointerException("The role must not be null.");
        }
        if (property == null) {
            throw new NullPointerException("The property must not be null.");
        }
        this.target = target;
        this.role = role;
        this.property = property;
    }

    public Object target() {
        return this.target;
    }

    public String role() {
        return this.role;
    }

    public String property() {
        return this.property;
    }

    public String aspect() {
        return this.role() + "." + this.property();
    }

    public String formattedText() {
        return this.aspect() + " " + this.text();
    }

    public Object key() {
        return this.aspect();
    }
}

