/*
 * Decompiled with CFR 0.152.
 */
package com.ireasoning.protocol.snmp;

import com.ireasoning.protocol.snmp.D;
import com.ireasoning.protocol.snmp.SnmpOID;
import com.ireasoning.protocol.snmp.SnmpVarBind;
import com.ireasoning.protocol.snmp.a0;
import com.ireasoning.protocol.snmp.ag;
import com.ireasoning.protocol.snmp.ah;
import com.ireasoning.util.Tokenizer;
import com.ireasoning.util.aG;
import com.ireasoning.util.aN;
import com.ireasoning.util.aR;
import com.ireasoning.util.aU;
import com.ireasoning.util.aW;
import com.ireasoning.util.au;
import com.ireasoning.util.bs;
import com.ireasoning.util.r;
import com.ireasoning.util.s;
import com.ireasoning.util.t;
import com.sysuptime.server.msp.Command;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Set;
import java.util.Vector;

public final class MibUtil {
    private MibUtil() {
    }

    public static void setResolveSyntax(boolean bl2) {
        aG.setResolveSyntax(bl2);
    }

    public static void loadMibs(String[] stringArray) throws IOException, bs {
        MibUtil.loadMibs(stringArray, true);
    }

    public static void loadMibs(String[] stringArray, boolean bl2) throws IOException, bs {
        aN.loadMibs(stringArray, bl2);
    }

    public static void loadMibs(String[] stringArray, String string) throws IOException, bs {
        MibUtil.loadMibs(stringArray, true, string);
    }

    public static void loadMibs(String[] stringArray, boolean bl2, String string) throws IOException, bs {
        aN.loadMibs(stringArray, bl2, string);
    }

    public static void loadMib(String string) throws IOException, bs {
        MibUtil.loadMib(string, null);
    }

    public static void loadMib(String string, String string2) throws IOException, bs {
        MibUtil.loadMib(string, true, string2);
    }

    public static void loadMib(String string, boolean bl2) throws IOException, bs {
        MibUtil.loadMib(string, bl2, null);
    }

    public static void loadMib(String string, boolean bl2, String string2) throws IOException, bs {
        aN.loadMib(string, bl2, string2);
    }

    public static void loadMib(Reader reader, boolean bl2) throws IOException, bs {
        aN.loadMib(reader, bl2, null);
    }

    public static void loadMib(Reader reader, boolean bl2, String string) throws IOException, bs {
        aN.loadMib(reader, bl2, string);
    }

    public static void loadMibs(Reader[] readerArray, boolean bl2) throws IOException, bs {
        aN.loadMibs(readerArray, bl2, null);
    }

    public static void loadMib2() {
        try {
            Reader reader = aR.getResourceAsReader("RFC1213.MIB");
            if (reader == null) {
                au.warn("Loading MIB-II from resource bundle failed. You may need to use loadMib method to load MIB-II explicitly.");
                return;
            }
            URL uRL = aR.getResource("RFC1213.MIB");
            if (uRL == null) {
                au.warn("Loading MIB-II from resource bundle failed. You may need to use loadMib method to load MIB-II explicitly.");
                return;
            }
            String string = uRL.toString();
            aN.loadMib(reader, string);
        }
        catch (Exception exception) {
            au.error(exception);
        }
    }

    public static void unloadMib(String string) {
        aN.unloadMib(string);
    }

    public static void unloadAllMibs() {
        aN.unloadAllMibs();
    }

    public static boolean isMibFileLoaded(String string) {
        return aG.isMibFileLoaded(string);
    }

    public static boolean isMibFileLoaded() {
        return aG.isMibFileLoaded();
    }

    public static SnmpOID lookupOID(String string) {
        return MibUtil.lookupOID(string, null, true);
    }

    public static SnmpOID lookupOID(String string, boolean bl2) {
        return MibUtil.lookupOID(string, null, bl2);
    }

    public static SnmpOID lookupOID(String string, String string2) {
        return MibUtil.lookupOID(string, string2, true);
    }

    public static SnmpOID lookupOID(String string, String string2, boolean bl2) {
        Command[] commandArray = SnmpVarBind.b();
        if (string.startsWith(".")) {
            string = string.substring(1);
        }
        if (string.equals("ccitt.0")) {
            return new SnmpOID(".0.0");
        }
        int n2 = string.indexOf(".");
        if (n2 < 0) {
            SnmpOID snmpOID = null;
            snmpOID = string2 == null ? aN.lookupOID(string) : aN.lookupOID(string + ":" + string2);
            return snmpOID;
        }
        String string3 = string.substring(0, n2);
        String string4 = string.substring(n2 + 1);
        if (aU.isDigit(string3)) {
            return new SnmpOID(string);
        }
        if (!aU.isDigit(string4)) {
            String string5;
            int n3 = string.indexOf(".", n2 + 1);
            if (n3 < 0) {
                n3 = string.length();
            }
            if (!aU.isDigit(string5 = string.substring(n2 + 1, n3))) {
                SnmpOID snmpOID;
                s s2;
                block24: {
                    int n4;
                    String[] stringArray;
                    block23: {
                        int n5;
                        s s3;
                        block21: {
                            stringArray = Tokenizer.parse(string, '.', false, true);
                            ArrayList arrayList = aN.getRoots();
                            int n6 = arrayList.size();
                            s2 = null;
                            String string6 = stringArray[0];
                            int n7 = 0;
                            block0: while (true) {
                                int n8 = n7;
                                block1: while (n8 < n6) {
                                    s s4 = (s)arrayList.get(n7);
                                    s3 = s2 = s4.searchIgnoreCase(string6);
                                    if (commandArray == null) break block21;
                                    if (s3 != null) {
                                        for (int i2 = 1; i2 < stringArray.length; ++i2) {
                                            int n9;
                                            block22: {
                                                n8 = aU.isDigit(stringArray[i2]) ? 1 : 0;
                                                if (commandArray == null) continue block1;
                                                if (n8 != 0 && commandArray != null) break block0;
                                                for (s2 = (s)s2.getFirstChild(); s2 != null; s2 = (s)s2.getNextSibling()) {
                                                    n9 = stringArray[i2].equalsIgnoreCase(s2.getName().toString()) ? 1 : 0;
                                                    if (commandArray != null) {
                                                        if (n9 != 0 && commandArray != null) break;
                                                        if (commandArray != null) continue;
                                                    }
                                                    break block22;
                                                }
                                                if (s2 == null) break;
                                                n9 = i2;
                                            }
                                            if (n9 == stringArray.length - 1 && commandArray != null) break block0;
                                            if (commandArray != null) continue;
                                        }
                                    }
                                    ++n7;
                                    if (commandArray != null) continue block0;
                                }
                                break;
                            }
                            s3 = s2;
                        }
                        if (s3 == null) {
                            return null;
                        }
                        snmpOID = s2.getOID();
                        for (n5 = stringArray.length - 1; n5 >= 0; --n5) {
                            n4 = aU.isDigit(stringArray[n5]) ? 1 : 0;
                            if (commandArray != null) {
                                if (n4 == 0 && commandArray != null) break;
                                if (commandArray != null) continue;
                            }
                            break block23;
                        }
                        n4 = n5;
                    }
                    if (n4 != stringArray.length - 1) {
                        Object object = "";
                        for (int i3 = n5 + 1; i3 < stringArray.length; ++i3) {
                            object = (String)object + "." + stringArray[i3];
                            if (commandArray != null) {
                                if (commandArray != null) continue;
                            }
                            break block24;
                        }
                        snmpOID.append((String)object);
                    }
                }
                if (bl2 && s2.isScalarNode() && !snmpOID.endsWith(".0")) {
                    snmpOID.append(".0");
                }
                return snmpOID;
            }
        }
        SnmpOID snmpOID = null;
        snmpOID = string2 == null ? aN.lookupOID(string3) : aN.lookupOID(string3 + ":" + string2);
        SnmpOID snmpOID2 = snmpOID = snmpOID == null ? null : snmpOID.append(string4);
        if (snmpOID != null && aN.isScalarNode(string3) && snmpOID.endsWith(".0.0")) {
            snmpOID = snmpOID.suboid(0, snmpOID.getLength() - 1);
        }
        return snmpOID;
    }

    public static String translateOID(String string, boolean bl2) {
        s s2 = aN.get(string);
        if (s2 == null && (s2 = aN.searchOther(new SnmpOID(string))) == null) {
            return null;
        }
        return MibUtil.a(string, s2, bl2);
    }

    public static String translateOID(SnmpOID snmpOID, boolean bl2) {
        return MibUtil.translateOID(snmpOID.toString(), bl2);
    }

    public static String translateSnmpV1Trap(a0 a02) {
        return MibUtil.translateSnmpV1Trap(a02.getEnterprise(), a02.getGeneric(), a02.getSpecific());
    }

    public static String translateSnmpV1Trap(SnmpOID snmpOID, int n2, int n3) {
        if (n2 < 6) {
            if (n2 == 0) {
                return "coldStart";
            }
            if (1 == n2) {
                return "warmStart";
            }
            if (2 == n2) {
                return "linkDown";
            }
            if (3 == n2) {
                return "linkUp";
            }
            if (4 == n2) {
                return "authenticationFailure";
            }
            if (5 == n2) {
                return "egpNeighborLoss";
            }
        }
        long l2 = (long)n3 & 0xFFFFFFFFL;
        String string = snmpOID.toString() + ".0." + l2;
        return aN.getSnmpV1TrapName(string);
    }

    public static String translateValue(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        s s2 = aN.get(string);
        return MibUtil.translateValue(s2, string2);
    }

    public static String translateValue(s s2, String string) {
        String string2 = MibUtil.a(string, s2);
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    public static String translateValue(SnmpOID snmpOID, String string) {
        return MibUtil.translateValue(snmpOID.toString(), string);
    }

    public static D translate(String string, String string2, boolean bl2) {
        String string3 = MibUtil.translateOID(string, bl2);
        if (string3 == null) {
            string3 = string;
        }
        string2 = MibUtil.translateValue(string, string2);
        return new D(string3, string2);
    }

    public static D translate(SnmpOID snmpOID, String string, boolean bl2) {
        return MibUtil.translate(snmpOID.toString(), string, bl2);
    }

    public static s parseMib(String string) throws IOException, bs {
        return MibUtil.parseMib(string, true);
    }

    public static s parseMib(Reader reader, boolean bl2) throws IOException, bs {
        aG aG2 = aG.loadMib(reader, bl2);
        t t2 = (t)aG2.getRoot();
        try {
            if (t2 != null) {
                t2.setTrapNodes(aG2.getTraps());
            }
        }
        catch (IOException iOException) {
            throw MibUtil.a(iOException);
        }
        return t2;
    }

    public static s parseMibs(Reader[] readerArray, boolean bl2) throws IOException, bs {
        t t2;
        block16: {
            aG aG2 = aG.loadMib(readerArray[0], bl2);
            Command[] commandArray = SnmpVarBind.b();
            t2 = (t)aG2.getRoot();
            Vector vector = new Vector();
            vector.addAll(aG2.getTraps());
            for (int i2 = 1; i2 < readerArray.length; ++i2) {
                aG aG3 = aG.loadMib(readerArray[i2]);
                try {
                    try {
                        if (commandArray == null) break block16;
                        if (aG3 == null) {
                            continue;
                        }
                    }
                    catch (IOException iOException) {
                        throw MibUtil.a(iOException);
                    }
                }
                catch (IOException iOException) {
                    throw MibUtil.a(iOException);
                }
                vector.addAll(aG3.getTraps());
                s s2 = aG3.getRoot();
                try {
                    if (s2 == null) {
                        continue;
                    }
                }
                catch (IOException iOException) {
                    throw MibUtil.a(iOException);
                }
                if (t2 == null) {
                    t2 = (t)s2;
                    aG2 = aG3;
                    if (commandArray != null) continue;
                }
                r r2 = s2.getFirstChild();
                try {
                    if (r2 == null) {
                        continue;
                    }
                }
                catch (IOException iOException) {
                    throw MibUtil.a(iOException);
                }
                aG2.addOtherSubTree((s)r2.getFirstChild());
                if (commandArray != null) continue;
            }
            try {
                if (t2 != null) {
                    t2.setTrapNodes(vector);
                }
            }
            catch (IOException iOException) {
                throw MibUtil.a(iOException);
            }
        }
        return t2;
    }

    public static s parseMib(String string, boolean bl2) throws IOException, bs {
        aG aG2 = aG.loadMib(string, bl2);
        t t2 = (t)aG2.getRoot();
        try {
            if (t2 != null) {
                t2.setTrapNodes(aG2.getTraps());
            }
        }
        catch (IOException iOException) {
            throw MibUtil.a(iOException);
        }
        return t2;
    }

    public static s parseMibs(String[] stringArray) throws IOException, bs {
        return MibUtil.parseMibs(stringArray, true);
    }

    /*
     * Unable to fully structure code
     */
    public static s parseMibs(String[] var0, boolean var1_1) throws IOException, bs {
        block22: {
            var3_2 = null;
            var2_3 = SnmpVarBind.b();
            try {
                var3_2 = aG.loadMib(var0[0], var1_1);
            }
            catch (bs var4_4) {
                try {
                    if (var4_4.getMibModuleName() == null) {
                        var4_4.setMibModuleName(var0[0]);
                    }
                }
                catch (bs v0) {
                    throw MibUtil.a(v0);
                }
                throw var4_4;
            }
            var4_5 = (t)var3_2.getRoot();
            var5_6 = new Vector<E>();
            var5_6.addAll(var3_2.getTraps());
            for (var6_7 = 1; var6_7 < var0.length; ++var6_7) {
                block24: {
                    block23: {
                        var7_8 = aG.loadMib(var0[var6_7]);
                        try {
                            if (var2_3 == null) break block22;
                            if (var7_8 != null) break block23;
                        }
                        catch (bs v1) {
                            throw MibUtil.a(v1);
                        }
                        if (var2_3 != null) continue;
                        {
                            catch (bs var7_9) {
                                try {
                                    if (var7_9.getMibModuleName() == null) {
                                        var7_9.setMibModuleName(var0[var6_7]);
                                    }
                                }
                                catch (bs v2) {
                                    throw MibUtil.a(v2);
                                }
                                throw var7_9;
                            }
                        }
                    }
                    var5_6.addAll(var7_8.getTraps());
                    var8_10 = var7_8.getRoot();
                    if (var8_10 == null && var2_3 != null) continue;
                    if (var4_5 != null) break block24;
                    var4_5 = (t)var8_10;
                    var3_2 = var7_8;
                    if (var2_3 != null) continue;
                }
                var9_11 = var8_10.getFirstChild();
                if (var9_11 != null) ** GOTO lbl54
                try {
                    if (var2_3 != null) continue;
lbl54:
                    // 3 sources

                    var3_2.addOtherSubTree((s)var9_11.getFirstChild());
                    continue;
                }
                catch (IOException v3) {
                    throw MibUtil.a(v3);
                }
            }
            try {
                if (var4_5 != null) {
                    var4_5.setTrapNodes(var5_6);
                }
            }
            catch (bs v4) {
                throw MibUtil.a(v4);
            }
        }
        return var4_5;
    }

    public static s[] parseMibsWithoutMerge(String[] stringArray) throws IOException, bs {
        return MibUtil.parseMibsWithoutMerge(stringArray, true);
    }

    public static s[] parseMibsWithoutMerge(String[] stringArray, boolean bl2) throws IOException, bs {
        s[] sArray;
        block4: {
            s[] sArray2 = new s[stringArray.length];
            Command[] commandArray = SnmpVarBind.b();
            for (int i2 = 0; i2 < sArray2.length; ++i2) {
                try {
                    sArray = sArray2;
                    if (commandArray != null) {
                        sArray[i2] = MibUtil.parseMib(stringArray[i2], bl2);
                        if (commandArray != null) continue;
                        break;
                    }
                    break block4;
                }
                catch (IOException iOException) {
                    throw MibUtil.a(iOException);
                }
            }
            sArray = sArray2;
        }
        return sArray;
    }

    public static Set getModulesInfo() {
        return aG.getModulesInfo();
    }

    private static String a(String string, s s2) {
        String string2;
        if (s2 == null) {
            return null;
        }
        aW aW2 = s2.getSyntax();
        String string3 = s2.getSyntaxType();
        if (string3 == null) {
            return null;
        }
        if (string3.equals("BITS") || string3.equals("FcPortFCClass")) {
            return MibUtil.b(string, s2);
        }
        if (aW2 != null && (string2 = aW2.get(string)) != null) {
            string = string2;
        }
        return string;
    }

    private static String b(String string, s s2) {
        Object object;
        block6: {
            int n2 = string.indexOf("{");
            Command[] commandArray = SnmpVarBind.b();
            ah ah2 = new ah();
            if (n2 < 0) {
                byte[] byArray = ag.getBytes(string);
                ah2.setValue(byArray);
                string = ah2.toString();
                n2 = string.indexOf("{");
            }
            int n3 = string.indexOf("}");
            string = string.substring(n2 + 1, n3);
            String[] stringArray = Tokenizer.parse(string, ',', true);
            aW aW2 = s2.getSyntax();
            object = "{";
            boolean bl2 = true;
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string2 = null;
                if (commandArray != null) {
                    if (aW2 != null) {
                        string2 = aW2.get(stringArray[i2]);
                    }
                    if (!bl2) {
                        object = (String)object + ", ";
                    }
                    bl2 = false;
                    if (string2 != null) {
                        object = (String)object + string2;
                        if (commandArray != null) continue;
                    }
                    object = (String)object + stringArray[i2];
                    if (commandArray != null) continue;
                }
                break block6;
            }
            object = (String)object + "}";
        }
        return object;
    }

    private static String a(String string, s s2, boolean bl2) {
        if (s2 == null) {
            return null;
        }
        SnmpOID snmpOID = s2.getOID();
        SnmpOID snmpOID2 = new SnmpOID(string);
        String string2 = "";
        if (snmpOID.getLength() < snmpOID2.getLength()) {
            SnmpOID snmpOID3 = snmpOID2.suboid(snmpOID.getLength(), snmpOID2.getLength());
            string2 = snmpOID3.toString();
        }
        return bl2 ? s2.getFullName() + string2 : s2.getName().toString() + string2;
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

