/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.common.discovery;

import com.sysuptime.common.discovery.V3Params;
import java.io.Serializable;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ReadCommunity
implements Serializable {
    private static final Logger _logger = Logger.getLogger((String)ReadCommunity.class.getName());
    public static final String V1 = "1";
    public static final String V2 = "2";
    public static final String V3 = "3";
    private String _ipAddress;
    private String _community = "public";
    private int _version = 1;
    private int _port = 161;
    private V3Params _v3Params;
    private static boolean a;

    public ReadCommunity(String string, String string2, int n2, V3Params v3Params) {
        this._ipAddress = string;
        this._community = string2;
        this._version = n2;
        this._v3Params = v3Params;
    }

    public ReadCommunity(String string, String string2, int n2, V3Params v3Params, int n3) {
        this(string, string2, n2, v3Params);
        this._port = n3;
    }

    public ReadCommunity(ReadCommunity readCommunity) {
        this(readCommunity.getIpAddress(), readCommunity.getCommunity(), readCommunity.getVersion(), readCommunity.getV3Params(), readCommunity.getPort());
    }

    public void setPort(int n2) {
        this._port = n2;
    }

    public int getPort() {
        return this._port;
    }

    public String getIpAddress() {
        return this._ipAddress;
    }

    public String getCommunity() {
        return this._community;
    }

    public int getVersion() {
        return this._version;
    }

    public void setVersion(int n2) {
        this._version = n2;
    }

    public String getVersionString() {
        switch (this._version) {
            case 0: {
                return V1;
            }
            case 1: {
                return V2;
            }
            case 3: {
                return V3;
            }
        }
        return null;
    }

    public static int getVersion(String string) {
        if (V3.equals(string)) {
            return 3;
        }
        if (V2.equals(string)) {
            return 1;
        }
        return 0;
    }

    public static int translateVersion(int n2) {
        if (n2 == 0) {
            return 1;
        }
        if (n2 == 1) {
            return 2;
        }
        return 3;
    }

    public V3Params getV3Params() {
        return this._v3Params;
    }

    public boolean isWild() {
        return this._ipAddress == null || this._ipAddress.length() == 0;
    }

    public static String asXML(ReadCommunity[] readCommunityArray) {
        Document document = DocumentHelper.createDocument();
        Element element = document.addElement("read-communities");
        boolean bl2 = ReadCommunity.c();
        if (readCommunityArray != null) {
            for (int i2 = 0; i2 < readCommunityArray.length; ++i2) {
                Element element2 = element.addElement("read-community");
                Element element3 = element2.addElement("ip-address");
                element3.addCDATA(readCommunityArray[i2].getIpAddress());
                Element element4 = element2.addElement("community");
                element4.addCDATA(readCommunityArray[i2].getCommunity());
                Element element5 = element2.addElement("version");
                element5.addCDATA(readCommunityArray[i2].getVersionString());
                if (readCommunityArray[i2].getVersion() != 3) continue;
                V3Params v3Params = readCommunityArray[i2].getV3Params();
                Element element6 = element2.addElement("v3-params");
                Element element7 = element6.addElement("user-name");
                element7.addCDATA(v3Params.getUserName());
                Element element8 = element6.addElement("auth-algorithm");
                element8.addCDATA(v3Params.getAuthProtocol());
                Element element9 = element6.addElement("auth-password");
                element9.addCDATA(v3Params.getAuthPassword());
                Element element10 = element6.addElement("priv-algorithm");
                element10.addCDATA(v3Params.getPrivProtocolView());
                Element element11 = element6.addElement("priv-password");
                element11.addCDATA(v3Params.getPrivPassword());
                if (!bl2) continue;
            }
        }
        return document.asXML();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ReadCommunity[] asReadCommunities(String string) {
        boolean bl2;
        block8: {
            bl2 = ReadCommunity.b();
            if (string == null) return null;
            try {
                if (string.length() != 0) break block8;
                return null;
                catch (DocumentException documentException) {
                    throw ReadCommunity.a(documentException);
                }
            }
            catch (DocumentException documentException) {
                throw ReadCommunity.a(documentException);
            }
        }
        Document document = null;
        try {
            document = DocumentHelper.parseText((String)string);
        }
        catch (DocumentException documentException) {
            _logger.error((Object)"asReadCommunities", (Throwable)documentException);
            return null;
        }
        Element element = document.getRootElement();
        int n2 = element.nodeCount();
        ReadCommunity[] readCommunityArray = new ReadCommunity[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            Element element2 = (Element)element.node(i2);
            Element element3 = element2.element("ip-address");
            String string2 = element3.getData().toString();
            Element element4 = element2.element("community");
            String string3 = element4.getData().toString();
            Element element5 = element2.element("version");
            int n3 = ReadCommunity.getVersion(element5.getData().toString());
            V3Params v3Params = null;
            if (n3 == 3) {
                Element element6 = element2.element("v3-params");
                Element element7 = element6.element("user-name");
                String string4 = element7.getData().toString();
                Element element8 = element6.element("auth-algorithm");
                String string5 = element8.getData().toString();
                Element element9 = element6.element("auth-password");
                String string6 = element9.getData().toString();
                Element element10 = element6.element("priv-algorithm");
                int n4 = V3Params.getPrivProtocol(element10.getData().toString());
                Element element11 = element6.element("priv-password");
                String string7 = element11.getData().toString();
                v3Params = new V3Params(string4, string5, string6, n4, string7);
            }
            readCommunityArray[i2] = new ReadCommunity(string2, string3, n3, v3Params);
            if (bl2) continue;
        }
        return readCommunityArray;
    }

    public static ReadCommunity toView(ReadCommunity readCommunity) {
        int n2 = (readCommunity = new ReadCommunity(readCommunity)).getVersion();
        if (n2 < 3) {
            readCommunity.setVersion(++n2);
        }
        return readCommunity;
    }

    public static ReadCommunity fromView(ReadCommunity readCommunity) {
        int n2 = (readCommunity = new ReadCommunity(readCommunity)).getVersion();
        if (n2 < 3) {
            readCommunity.setVersion(--n2);
        }
        return readCommunity;
    }

    static {
        ReadCommunity.b(true);
    }

    public static void b(boolean bl2) {
        a = bl2;
    }

    public static boolean b() {
        return a;
    }

    public static boolean c() {
        boolean bl2 = ReadCommunity.b();
        return !bl2;
    }

    private static DocumentException a(DocumentException documentException) {
        return documentException;
    }
}

