/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.common.graph;

import com.sysuptime.common.graph.GraphXMLConstants;
import com.sysuptime.common.graph.ImageIconBean;
import com.sysuptime.common.graph.NetworkGraphModel;
import com.sysuptime.common.model.NetworkConnection;
import com.sysuptime.common.model.NetworkNode;
import com.sysuptime.common.model.NetworkNodeBean;
import com.sysuptime.common.util.ComparablePair;
import com.sysuptime.common.util.StringUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.dom4j.Element;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.Edge;
import org.jgraph.graph.GraphConstants;
import util.Base64;

public class PropertiesWriter
implements Serializable,
GraphXMLConstants {
    public void writeViewProperties(Element element, Object object, NetworkGraphModel networkGraphModel) {
        if (networkGraphModel == null) {
            return;
        }
        Hashtable hashtable = new Hashtable(networkGraphModel.getAttributes(object));
        hashtable.remove("labelAlongEdge");
        hashtable.remove("autosize");
        hashtable.remove("linecolor");
        Object v2 = hashtable.remove("bounds");
        String string = null;
        if (v2 != null) {
            string = this.a(((Rectangle2D)v2).getBounds());
        }
        if (GraphConstants.getRouting(hashtable) != null) {
            hashtable.remove("points");
        }
        List list = GraphConstants.getPoints(hashtable);
        hashtable.remove("points");
        hashtable.remove("backgroundColor");
        hashtable.remove("foregroundColor");
        String string2 = null;
        if (list != null) {
            string2 = this.a(list);
        }
        Element element2 = null;
        if (object instanceof NetworkNode) {
            ImageIcon imageIcon;
            element2 = element.addElement("node");
            element2.addAttribute("id", ((NetworkNodeBean)((NetworkNode)object).getUserObject()).getID());
            if (string != null) {
                element2.addAttribute("rect", string);
            }
            if ((imageIcon = ((NetworkNode)object).getCurrentDefaultIcon()) != null) {
                GraphConstants.setIcon(hashtable, (Icon)imageIcon);
            }
        } else if (object instanceof NetworkConnection) {
            element2 = element;
            element2.addAttribute("points", string2);
        }
        if (GraphConstants.getFont(hashtable).equals(GraphConstants.DEFAULTFONT)) {
            hashtable.remove("font");
        }
        if (element2 != null) {
            this.a(element2, hashtable, false, null, false);
        }
    }

    private String a(Object object) {
        Object object2 = "";
        if (object instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)object;
            object2 = rectangle.x + "," + rectangle.y + "," + rectangle.width + "," + rectangle.height;
        } else if (object instanceof List) {
            List list = (List)object;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                if (!(list.get(i2) instanceof Point2D)) continue;
                Point2D point2D = (Point2D)list.get(i2);
                stringBuffer.append(point2D.getX());
                stringBuffer.append(",");
                stringBuffer.append(point2D.getY());
                stringBuffer.append(",");
            }
            String string = stringBuffer.toString();
            object2 = string.length() > 0 ? string.substring(0, string.length() - 1) : string;
        } else if (object instanceof Font) {
            Font font = (Font)object;
            object2 = font.getName() + "," + font.getSize() + "," + font.getStyle();
        } else if (object instanceof Color) {
            Color color = (Color)object;
            object2 = Integer.toString(color.getRed()) + "," + Integer.toString(color.getGreen()) + "," + Integer.toString(color.getBlue());
        } else if (object instanceof Point) {
            Point point = (Point)object;
            object2 = point.x + "," + point.y;
        } else if (object instanceof float[]) {
            float[] fArray = (float[])object;
            Object object3 = "";
            for (int i3 = 0; i3 < fArray.length; ++i3) {
                object3 = (String)object3 + Float.toString(fArray[i3]) + ",";
            }
            object2 = ((String)object3).substring(0, ((String)object3).length() - 1);
        } else if (object instanceof Border) {
            if (object instanceof LineBorder) {
                LineBorder lineBorder = (LineBorder)object;
                object2 = "L," + lineBorder.getLineColor().getRGB() + "," + lineBorder.getThickness();
            } else if (object instanceof BevelBorder) {
                BevelBorder bevelBorder = (BevelBorder)object;
                object2 = "B," + bevelBorder.getBevelType();
            }
        } else {
            if (object instanceof ImageIconBean || object instanceof ImageIcon) {
                if (object instanceof ImageIconBean) {
                    ImageIconBean imageIconBean = (ImageIconBean)object;
                    object2 = imageIconBean.getFileName();
                } else if (object instanceof ImageIcon) {
                    object2 = ((ImageIcon)object).toString();
                }
                object2 = StringUtil.replaceString((String)object2, GraphXMLConstants.APP_HOME, "@HOME@");
                return object2;
            }
            if (object instanceof Edge.Routing) {
                if (object instanceof DefaultEdge.DefaultRouting) {
                    object2 = "simple";
                }
            } else if (object != null) {
                object2 = object.toString();
            }
        }
        return object2;
    }

    private void a(Element element, Map map, boolean bl2, Set set, boolean bl3) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            Object object2 = entry2.getKey();
            try {
                if (set != null && set.contains(object2)) continue;
            }
            catch (Exception exception) {
                throw PropertiesWriter.a(exception);
            }
            Object object3 = entry2.getValue();
            if (bl2) {
                object = object2;
                object2 = object3;
                object3 = object;
            }
            if (bl3) {
                try {
                    object2 = URLEncoder.encode(object2.toString(), "UTF-8");
                    object3 = URLEncoder.encode(this.a(object3), "UTF-8");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            object = element.addElement("a");
            object.addAttribute("key", object2.toString());
            object.addAttribute("value", this.a(object3));
        }
    }

    public void writeLinkProperties(Element element, NetworkConnection networkConnection) {
        Element element2 = element.addElement("properties");
        LinkedList linkedList = networkConnection.getOtherProperties().getProperties();
        for (ComparablePair comparablePair : linkedList) {
            Comparable comparable = comparablePair.getName();
            Object object = comparablePair.getValue();
            Element element3 = element2.addElement("p");
            element3.addAttribute("name", Base64.encodeToString((byte[])comparable.toString().getBytes(), (boolean)true));
            element3.addAttribute("value", Base64.encodeToString((byte[])object.toString().getBytes(), (boolean)true));
        }
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

