/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.common.model;

import com.sysuptime.common.model.Customer;
import com.sysuptime.common.model.CustomerNode;
import com.sysuptime.common.model.DeviceBean;
import com.sysuptime.common.model.DeviceNode;
import com.sysuptime.common.model.NetworkNodeBean;
import com.sysuptime.common.model.ParentNode;
import com.sysuptime.common.model.Subnet;
import com.sysuptime.common.model.SubnetNode;
import java.io.Serializable;

public abstract class TopoNode
implements Serializable {
    protected NetworkNodeBean _bean;
    protected transient ParentNode parentNode;
    protected boolean _isVisible = true;

    public TopoNode(NetworkNodeBean networkNodeBean) {
        this._bean = networkNodeBean;
    }

    public NetworkNodeBean getBean() {
        return this._bean;
    }

    public void setBean(NetworkNodeBean networkNodeBean) {
        this._bean = networkNodeBean;
    }

    public boolean isVisible() {
        return this._isVisible;
    }

    public void setVisible(boolean bl2) {
        this._isVisible = bl2;
    }

    public String getPrivateID() {
        return this._bean.getPrivateID();
    }

    public String getID() {
        return this._bean.getID();
    }

    public String getCustomerID() {
        return this._bean.getCustomerID();
    }

    public static TopoNode createNode(NetworkNodeBean networkNodeBean) {
        if (networkNodeBean instanceof Customer) {
            return new CustomerNode((Customer)networkNodeBean);
        }
        if (networkNodeBean instanceof Subnet) {
            return new SubnetNode((Subnet)networkNodeBean);
        }
        return new DeviceNode((DeviceBean)networkNodeBean);
    }

    public ParentNode getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(ParentNode parentNode) {
        this.parentNode = parentNode;
    }

    public String toString() {
        return this._bean.toString();
    }
}

