/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.common.trapreceiver;

import com.ireasoning.protocol.snmp.MibUtil;
import com.ireasoning.protocol.snmp.a0;
import com.ireasoning.util.ba;
import com.ireasoning.util.bl;
import com.sysuptime.common.trapreceiver.AlarmAction;
import com.sysuptime.common.trapreceiver.ITrapConstants;
import com.sysuptime.common.trapreceiver.TrapEventObject;
import com.sysuptime.common.trapreceiver.TrapObject;
import com.sysuptime.common.util.CommonUtil;
import com.sysuptime.common.util.ICommonBundle;
import com.sysuptime.common.util.StringUtil;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.openide.util.NbBundle;

public class MessageUtil
implements Serializable {
    private static final String[] GENERIC_STRING = new String[]{"cold start", "warm start", "link down", "link up", "authentification failure", "EGP neighbor loss", "enterprise specific"};
    private static Hashtable<String, String> OID_MAP = new Hashtable();
    public static final String CONTENT_MATCHED;
    public static final String CONTENT_NOT_MATCHED;
    public static final String FIXED_THRESHOLD;
    public static final String STAT_THRESHOLD;
    public static final String REARM_TYPE;
    public static final String ALARM_TYPE;

    public static String translateOID(String string) {
        try {
            if (string == null) {
                return null;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw MessageUtil.a(numberFormatException);
        }
        String string2 = OID_MAP.get(string);
        try {
            if (string2 != null) {
                return string2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw MessageUtil.a(numberFormatException);
        }
        string2 = MibUtil.translateOID(string, true);
        try {
            if (string2 == null) {
                return string;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw MessageUtil.a(numberFormatException);
        }
        return string2;
    }

    public static String translateOIDShort(String string) {
        try {
            if (string == null) {
                return null;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw MessageUtil.a(numberFormatException);
        }
        String string2 = OID_MAP.get(string);
        try {
            if (string2 != null) {
                return string2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw MessageUtil.a(numberFormatException);
        }
        string2 = MibUtil.translateOID(string, false);
        try {
            if (string2 == null) {
                return string;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw MessageUtil.a(numberFormatException);
        }
        return string2;
    }

    public static String getSnmpV1TrapName(TrapObject trapObject) {
        a0 a02 = new a0(trapObject.getEnterprise());
        a02.setSpecific((int)trapObject.getSpecific());
        a02.setGeneric(Integer.parseInt(trapObject.getGeneric()));
        return MibUtil.translateSnmpV1Trap(a02);
    }

    public static String getMessageInHtml(TrapObject trapObject, boolean bl2) {
        TrapEventObject trapEventObject;
        Object object;
        TrapObject trapObject2;
        StringBuffer stringBuffer;
        block36: {
            Object object2;
            StringBuffer stringBuffer2;
            String string;
            String string2;
            String string3;
            String string4;
            String string5;
            String string6;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss z");
            boolean bl3 = AlarmAction.c();
            try {
                if (trapObject == null) {
                    return "";
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw MessageUtil.a(numberFormatException);
            }
            String string7 = "";
            String string8 = "";
            String string9 = "";
            String string10 = "";
            String string11 = "";
            String string12 = "";
            String string13 = "";
            String string14 = "";
            String string15 = trapObject.getMessage();
            string13 = MessageUtil.translateOIDShort(string15);
            if (string13 == null) {
                string13 = string15;
            }
            try {
                string6 = trapObject.getAckComment() == null ? "" : trapObject.getAckComment();
            }
            catch (NumberFormatException numberFormatException) {
                throw MessageUtil.a(numberFormatException);
            }
            string7 = string6;
            try {
                string5 = trapObject.getClearComment() == null ? "" : trapObject.getClearComment();
            }
            catch (NumberFormatException numberFormatException) {
                throw MessageUtil.a(numberFormatException);
            }
            string8 = string5;
            try {
                string4 = trapObject.getAckUser() == null ? "" : trapObject.getAckUser();
            }
            catch (NumberFormatException numberFormatException) {
                throw MessageUtil.a(numberFormatException);
            }
            string9 = string4;
            try {
                string3 = trapObject.getClearUser() == null ? "" : trapObject.getClearUser();
            }
            catch (NumberFormatException numberFormatException) {
                throw MessageUtil.a(numberFormatException);
            }
            string10 = string3;
            Timestamp timestamp = trapObject.getAckTime();
            String string16 = null;
            if (timestamp != null) {
                string16 = simpleDateFormat.format(new Date(timestamp.getTime()));
            }
            try {
                string2 = timestamp != null ? string16 : "";
            }
            catch (NumberFormatException numberFormatException) {
                throw MessageUtil.a(numberFormatException);
            }
            string12 = string2;
            String string17 = trapObject.getEnterprise();
            string14 = MessageUtil.translateOIDShort(string17);
            if (string14 == null) {
                string14 = string17;
            }
            if ((timestamp = trapObject.getClearTime()) != null) {
                string16 = simpleDateFormat.format(new Date(timestamp.getTime()));
            }
            try {
                string = timestamp != null ? string16 : "";
            }
            catch (NumberFormatException numberFormatException) {
                throw MessageUtil.a(numberFormatException);
            }
            string11 = string;
            stringBuffer = new StringBuffer(2048);
            stringBuffer.append("<html>");
            stringBuffer.append("<table  cellspacing=\"1\" width=\"100%\" >");
            stringBuffer.append("<tr ><td><b>").append(NbBundle.getMessage(MessageUtil.class, (String)"MESSAGE_message")).append("</b>").append("</td><td colspan=5>").append(string13).append("</td></tr>\n");
            boolean bl4 = trapObject.getVersionNumber().equals("1");
            if (bl4) {
                stringBuffer.append("<tr>");
                String string18 = MessageUtil.getSnmpV1TrapName(trapObject);
                try {
                    if (string18 != null) {
                        stringBuffer.append("<td><b>").append(ICommonBundle.NAME).append("</b>").append("</td><td>").append(string18).append("</td>\n");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw MessageUtil.a(numberFormatException);
                }
                try {
                    if (!StringUtil.isEmptyNoSpace(trapObject.getGeneric())) {
                        stringBuffer.append("<td><b>").append(NbBundle.getMessage(MessageUtil.class, (String)"MESSAGE_specific")).append("</b>").append("</td><td>").append(String.valueOf(trapObject.getSpecific())).append("</td>\n");
                        stringBuffer.append("<td><b>").append(NbBundle.getMessage(MessageUtil.class, (String)"MESSAGE_generic")).append("</b>");
                        stringBuffer.append("</td><td>");
                        stringBuffer.append(GENERIC_STRING[Integer.parseInt(trapObject.getGeneric())]);
                        stringBuffer.append("</td>\n");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw MessageUtil.a(numberFormatException);
                }
                stringBuffer.append("</tr>");
            }
            try {
                stringBuffer.append("<tr>");
                stringBuffer.append("<td><b>").append(NbBundle.getMessage(MessageUtil.class, (String)"MESSAGE_time")).append("</b>").append("</td><td>").append(trapObject.getReceiveTimeText()).append("</td>\n");
                stringBuffer.append("<td><b>").append(NbBundle.getMessage(MessageUtil.class, (String)"MESSAGE_version")).append("</b>").append("</td><td>").append(trapObject.getVersionNumber()).append("</td>");
                stringBuffer.append("<td><b>").append(NbBundle.getMessage(MessageUtil.class, (String)"MESSAGE_ipaddress")).append("</b>");
                stringBuffer.append("</td><td>");
                stringBuffer.append(trapObject.getIpAddress());
                stringBuffer.append("</td></tr>\n");
                stringBuffer.append("<tr><td><b>");
                stringBuffer2 = stringBuffer;
                object2 = bl4 ? NbBundle.getMessage(MessageUtil.class, (String)"MESSAGE_enterprise") : NbBundle.getMessage(MessageUtil.class, (String)"MESSAGE_trapoid") + "</b>";
            }
            catch (NumberFormatException numberFormatException) {
                throw MessageUtil.a(numberFormatException);
            }
            stringBuffer2.append((String)object2).append("</td><td>").append(string14).append("</td>\n");
            stringBuffer.append("<td><b>").append(NbBundle.getMessage(MessageUtil.class, (String)"MESSAGE_timestamp")).append("</b>").append("</td><td colspan=3>").append(new ba(trapObject.getTimestamp() * 10L).toString()).append("</td>\n");
            stringBuffer.append("</tr>\n");
            stringBuffer.append("<tr><td><b>").append(NbBundle.getMessage(MessageUtil.class, (String)"MESSAGE_ack_comment")).append("</b>").append("</td><td>").append(string7).append("</td>\n");
            stringBuffer.append("<td><b>").append(NbBundle.getMessage(MessageUtil.class, (String)"MESSAGE_ack_time")).append("</b>");
            stringBuffer.append("</td><td>");
            stringBuffer.append(string12);
            stringBuffer.append("</td>\n");
            stringBuffer.append("<td><b>").append(NbBundle.getMessage(MessageUtil.class, (String)"MESSAGE_ack_user")).append("</b>").append("</td><td>").append(string9).append("</td></tr>\n");
            stringBuffer.append("<tr><td><b>").append(NbBundle.getMessage(MessageUtil.class, (String)"MESSAGE_clear_comment")).append("</b>").append("</td><td>").append(string8).append("</td>\n");
            stringBuffer.append("<td><b>").append(NbBundle.getMessage(MessageUtil.class, (String)"MESSAGE_clear_time")).append("</b>");
            stringBuffer.append("</td><td>");
            stringBuffer.append(string11);
            stringBuffer.append("</td>\n");
            stringBuffer.append("<td><b>").append(NbBundle.getMessage(MessageUtil.class, (String)"MESSAGE_clear_user")).append("</b>");
            stringBuffer.append("</td><td>");
            stringBuffer.append(string10);
            stringBuffer.append("</td></tr>\n");
            stringBuffer.append("</table><hr>");
            stringBuffer.append("<table  cellspacing=\"1\" width=\"100%\" >");
            int n2 = trapObject.getVarbinds().size();
            for (int i2 = 0; i2 < n2; ++i2) {
                trapObject2 = trapObject;
                if (!bl3) {
                    String string19;
                    String string20;
                    StringBuffer stringBuffer3;
                    object = trapObject2.getVarbinds().get(i2);
                    String string21 = MessageUtil.translateOIDShort(((bl)object).getVarbindName());
                    try {
                        stringBuffer3 = stringBuffer.append("<tr><td><b>").append(NbBundle.getMessage(MessageUtil.class, (String)"MESSAGE_name")).append("</b>").append("</td><td>");
                        string20 = string21 != null ? string21 : ((bl)object).getVarbindName();
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw MessageUtil.a(numberFormatException);
                    }
                    stringBuffer3.append(string20).append("</td></tr>\n");
                    String string22 = MibUtil.translateValue(((bl)object).getVarbindName(), ((bl)object).getVarbindValue());
                    try {
                        string19 = string22 != null ? string22 : ((bl)object).getVarbindValue();
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw MessageUtil.a(numberFormatException);
                    }
                    string22 = string19;
                    String string23 = "(" + CommonUtil.getTypeString(((bl)object).getVarbindValueType()) + ") ";
                    stringBuffer.append("<tr><td><b>").append(NbBundle.getMessage(MessageUtil.class, (String)"MESSAGE_value")).append("</b>").append("</td><td>").append(string23).append(string22).append("</td></tr>\n");
                    stringBuffer.append("<tr><td colspan=2><hr></td></tr>\n");
                    if (!bl3) continue;
                }
                break block36;
            }
            trapObject2 = trapObject;
        }
        if ((trapEventObject = trapObject2.getEvent()) != null) {
            object = trapObject.getEvent().getDescription();
            if (object == null) {
                object = "";
            }
            stringBuffer.append("<tr><td valign=\"top\"><b>").append(NbBundle.getMessage(MessageUtil.class, (String)"MESSAGE_description")).append("</b></td><td>").append((String)object).append("</td></tr>\n");
        }
        stringBuffer.append(" </table></html>");
        return stringBuffer.toString();
    }

    public static String getTimeSpan(String string) {
        String string2;
        block21: {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            StringBuffer stringBuffer = new StringBuffer("");
            boolean bl2 = AlarmAction.b();
            while (stringTokenizer.hasMoreTokens()) {
                block23: {
                    String string3 = stringTokenizer.nextToken();
                    try {
                        try {
                            block26: {
                                try {
                                    try {
                                        block25: {
                                            try {
                                                try {
                                                    block24: {
                                                        try {
                                                            try {
                                                                block22: {
                                                                    try {
                                                                        try {
                                                                            string2 = string3;
                                                                            if (!bl2) break block21;
                                                                            if (!StringUtil.isDigit(string2)) break block22;
                                                                        }
                                                                        catch (NumberFormatException numberFormatException) {
                                                                            throw MessageUtil.a(numberFormatException);
                                                                        }
                                                                        stringBuffer.append(string3).append(" ");
                                                                        if (bl2) break block23;
                                                                    }
                                                                    catch (NumberFormatException numberFormatException) {
                                                                        throw MessageUtil.a(numberFormatException);
                                                                    }
                                                                }
                                                                if (!string3.startsWith("m")) break block24;
                                                            }
                                                            catch (NumberFormatException numberFormatException) {
                                                                throw MessageUtil.a(numberFormatException);
                                                            }
                                                            stringBuffer.append(ICommonBundle.MINUTES).append(" ");
                                                            if (bl2) break block23;
                                                        }
                                                        catch (NumberFormatException numberFormatException) {
                                                            throw MessageUtil.a(numberFormatException);
                                                        }
                                                    }
                                                    if (!string3.startsWith("s")) break block25;
                                                }
                                                catch (NumberFormatException numberFormatException) {
                                                    throw MessageUtil.a(numberFormatException);
                                                }
                                                stringBuffer.append(NbBundle.getMessage(MessageUtil.class, (String)"seconds")).append(" ");
                                                if (bl2) break block23;
                                            }
                                            catch (NumberFormatException numberFormatException) {
                                                throw MessageUtil.a(numberFormatException);
                                            }
                                        }
                                        if (!string3.startsWith("h")) break block26;
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        throw MessageUtil.a(numberFormatException);
                                    }
                                    stringBuffer.append(ICommonBundle.HOUR).append(" ");
                                    if (bl2) break block23;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    throw MessageUtil.a(numberFormatException);
                                }
                            }
                            if (!string3.startsWith("d")) break block23;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw MessageUtil.a(numberFormatException);
                        }
                        stringBuffer.append(NbBundle.getMessage(MessageUtil.class, (String)"days")).append(" ");
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw MessageUtil.a(numberFormatException);
                    }
                }
                if (bl2) continue;
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    /*
     * Unable to fully structure code
     */
    public static void setPerformanceText(TrapObject var0, boolean var1_1, String var2_2) {
        block46: {
            block54: {
                block51: {
                    block56: {
                        block49: {
                            block48: {
                                block47: {
                                    block45: {
                                        var4_3 = var0.getSpecific();
                                        var3_4 = AlarmAction.b();
                                        if (var4_3 == 1000L) break block45;
                                        try {
                                            block55: {
                                                if (var4_3 == 1002L) break block45;
                                                break block55;
                                                catch (NumberFormatException v0) {
                                                    throw MessageUtil.a(v0);
                                                }
                                            }
                                            if (var4_3 != 1001L) break block46;
                                        }
                                        catch (NumberFormatException v1) {
                                            throw MessageUtil.a(v1);
                                        }
                                    }
                                    if (!(var6_5 = var0.getTrapOid()).startsWith(".1.3.6.1.4.1.15145.100.")) break block46;
                                    var6_5 = MessageUtil.translateOID(var6_5);
                                    var0.setTrapOid(var6_5);
                                    var7_6 = var0.getVarbinds();
                                    var8_7 = null;
                                    if (var1_1) {
                                        for (var9_8 = 0; var9_8 < var7_6.size(); ++var9_8) {
                                            var8_7 = var7_6.get(var9_8);
                                            var10_9 = MessageUtil.translateOID(var8_7.getVarbindName());
                                            try {
                                                var8_7.setVarbindName(var10_9);
                                                if (var3_4) {
                                                    if (var3_4) continue;
                                                    break;
                                                }
                                                break block47;
                                            }
                                            catch (NumberFormatException v2) {
                                                throw MessageUtil.a(v2);
                                            }
                                        }
                                    }
                                    var8_7 = var7_6.get(3);
                                    var9_8 = 0;
                                }
                                try {
                                    if (var2_2 == null || var2_2.indexOf("CONTENT_MATCH") < 0) break block48;
                                }
                                catch (NumberFormatException v3) {
                                    throw MessageUtil.a(v3);
                                }
                                var9_8 = 1;
                            }
                            if (var9_8 == 0) break block56;
                            var8_7 = var7_6.get(8);
                            var10_9 = var8_7.getVarbindValue();
                            try {
                                block57: {
                                    var11_10 = Double.parseDouble(var10_9);
                                    if (var11_10 != -1.012) ** GOTO lbl56
                                    var8_7.setVarbindValue(MessageUtil.CONTENT_MATCHED);
                                    if (var3_4) break block49;
                                    break block57;
                                    catch (NumberFormatException v4) {
                                        throw MessageUtil.a(v4);
                                    }
                                }
                                try {
                                    block58: {
                                        if (var11_10 != -2.012) break block49;
                                        break block58;
                                        catch (NumberFormatException v5) {
                                            throw MessageUtil.a(v5);
                                        }
                                    }
                                    var8_7.setVarbindValue(MessageUtil.CONTENT_NOT_MATCHED);
                                }
                                catch (NumberFormatException v6) {
                                    throw MessageUtil.a(v6);
                                }
                            }
                            catch (NumberFormatException var11_11) {
                                // empty catch block
                            }
                        }
                        var11_12 = var0.getEvent();
                        try {
                            if (var11_12 != null) {
                                var0.setMessage(var11_12.getMessage(var0));
                            }
                        }
                        catch (NumberFormatException v7) {
                            throw MessageUtil.a(v7);
                        }
                    }
                    if (StringUtil.isDigit(var10_9 = (var8_7 = var7_6.get(4)).getVarbindValue())) {
                        var11_13 = Integer.parseInt(var10_9);
                        try {
                            try {
                                block52: {
                                    try {
                                        try {
                                            block50: {
                                                try {
                                                    if (var11_13 != 0) break block50;
                                                    var8_7.setVarbindValue(MessageUtil.REARM_TYPE);
                                                    if (var3_4) break block51;
                                                }
                                                catch (NumberFormatException v8) {
                                                    throw MessageUtil.a(v8);
                                                }
                                            }
                                            if (var11_13 != 1) break block52;
                                        }
                                        catch (NumberFormatException v9) {
                                            throw MessageUtil.a(v9);
                                        }
                                        var8_7.setVarbindValue(MessageUtil.ALARM_TYPE);
                                        if (var3_4) break block51;
                                    }
                                    catch (NumberFormatException v10) {
                                        throw MessageUtil.a(v10);
                                    }
                                }
                                if (var11_13 != 2) break block51;
                            }
                            catch (NumberFormatException v11) {
                                throw MessageUtil.a(v11);
                            }
                            var8_7.setVarbindValue(ICommonBundle.ERROR);
                        }
                        catch (NumberFormatException v12) {
                            throw MessageUtil.a(v12);
                        }
                    }
                }
                if (StringUtil.isDigit(var10_9 = (var8_7 = var7_6.get(6)).getVarbindValue())) {
                    var11_14 = Integer.parseInt(var10_9);
                    try {
                        try {
                            block53: {
                                try {
                                    if (var11_14 != 0) break block53;
                                    var8_7.setVarbindValue(MessageUtil.FIXED_THRESHOLD);
                                    if (var3_4) break block54;
                                }
                                catch (NumberFormatException v13) {
                                    throw MessageUtil.a(v13);
                                }
                            }
                            if (var11_14 != 1) break block54;
                        }
                        catch (NumberFormatException v14) {
                            throw MessageUtil.a(v14);
                        }
                        var8_7.setVarbindValue(MessageUtil.STAT_THRESHOLD);
                    }
                    catch (NumberFormatException v15) {
                        throw MessageUtil.a(v15);
                    }
                }
            }
            if (StringUtil.isDigit(var10_9 = (var8_7 = var7_6.get(5)).getVarbindValue())) {
                var11_15 = Integer.parseInt(var8_7.getVarbindValue());
                try {
                    try {
                        if (var11_15 < 0 || var11_15 >= ITrapConstants.SEVERITY_STRINGS.length) break block46;
                    }
                    catch (NumberFormatException v16) {
                        throw MessageUtil.a(v16);
                    }
                    var8_7.setVarbindValue(ITrapConstants.SEVERITY_STRINGS[var11_15]);
                }
                catch (NumberFormatException v17) {
                    throw MessageUtil.a(v17);
                }
            }
        }
    }

    static {
        OID_MAP.put(".1.3.6.1.4.1.15145.100.0.1001".toString(), NbBundle.getMessage(MessageUtil.class, (String)"ARM_ALARM"));
        OID_MAP.put(".1.3.6.1.4.1.15145.100.0.1000".toString(), NbBundle.getMessage(MessageUtil.class, (String)"REARM_ALARM"));
        OID_MAP.put(".1.3.6.1.4.1.15145.100.0.1002".toString(), NbBundle.getMessage(MessageUtil.class, (String)"ERROR_ALARM"));
        OID_MAP.put(".1.3.6.1.4.1.15145.100.20.0".toString(), NbBundle.getMessage(MessageUtil.class, (String)"SCHEDULE_ID"));
        OID_MAP.put(".1.3.6.1.4.1.15145.100.21.0".toString(), NbBundle.getMessage(MessageUtil.class, (String)"SCHEDULE_NAME"));
        OID_MAP.put(".1.3.6.1.4.1.15145.100.22.0".toString(), NbBundle.getMessage(MessageUtil.class, (String)"HOST"));
        OID_MAP.put(".1.3.6.1.4.1.15145.100.23.0".toString(), NbBundle.getMessage(MessageUtil.class, (String)"RESULT_TYPE"));
        OID_MAP.put(".1.3.6.1.4.1.15145.100.24.0".toString(), NbBundle.getMessage(MessageUtil.class, (String)"IS_REARM"));
        OID_MAP.put(".1.3.6.1.4.1.15145.100.25.0".toString(), NbBundle.getMessage(MessageUtil.class, (String)"SEVERITY"));
        OID_MAP.put(".1.3.6.1.4.1.15145.100.26.0".toString(), NbBundle.getMessage(MessageUtil.class, (String)"THRESHOLD_TYPE"));
        OID_MAP.put(".1.3.6.1.4.1.15145.100.27.0".toString(), NbBundle.getMessage(MessageUtil.class, (String)"FIXED_THRESHOLD"));
        OID_MAP.put(".1.3.6.1.4.1.15145.100.28.0".toString(), NbBundle.getMessage(MessageUtil.class, (String)"CURRENT_VALUE"));
        OID_MAP.put(".1.3.6.1.4.1.15145.100.29.0".toString(), NbBundle.getMessage(MessageUtil.class, (String)"STATISTICAL_THRESHOLD"));
        OID_MAP.put(".1.3.6.1.4.1.15145.100.30.0".toString(), NbBundle.getMessage(MessageUtil.class, (String)"CURRENT_STATISTICAL_VALUE"));
        OID_MAP.put(".1.3.6.1.4.1.15145.100.31.0".toString(), NbBundle.getMessage(MessageUtil.class, (String)"ERROR_MESSAGE"));
        CONTENT_MATCHED = NbBundle.getMessage(MessageUtil.class, (String)"content_matched");
        CONTENT_NOT_MATCHED = NbBundle.getMessage(MessageUtil.class, (String)"content_not_matched");
        FIXED_THRESHOLD = NbBundle.getMessage(MessageUtil.class, (String)"FIXED_THRESHOLD");
        STAT_THRESHOLD = NbBundle.getMessage(MessageUtil.class, (String)"STATISTICAL_THRESHOLD");
        REARM_TYPE = NbBundle.getMessage(MessageUtil.class, (String)"rearm");
        ALARM_TYPE = NbBundle.getMessage(MessageUtil.class, (String)"alarm");
    }

    private static NumberFormatException a(NumberFormatException numberFormatException) {
        return numberFormatException;
    }
}

