/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe;

import com.sysuptime.common.model.NetworkNode;
import com.sysuptime.mainframe.AlarmViewController;
import com.sysuptime.mainframe.ComponentUtils;
import com.sysuptime.mainframe.ConsoleComponent$1;
import com.sysuptime.mainframe.ConsoleComponent$2;
import com.sysuptime.mainframe.Startup;
import com.sysuptime.mainframe.ViewComponent;
import com.sysuptime.mainframe.actions.ToBackAction;
import com.sysuptime.mainframe.actions.ToFrontAction;
import com.sysuptime.mainframe.graph.NetworkGraph;
import com.sysuptime.mainframe.nodes.StringTreeNode;
import com.sysuptime.mainframe.nodes.TreeNode;
import com.sysuptime.mainframe.tree.ExplorerTreeView;
import com.sysuptime.mainframe.tree.FunctionTreeView;
import com.sysuptime.mainframe.tree.StructuralTreeView;
import com.sysuptime.mainframe.util.FunctionManager;
import com.sysuptime.mainframe.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.ActionMap;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.event.GraphSelectionListener;
import org.netbeans.core.NbSheet;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ConsoleComponent
extends TopComponent
implements ExplorerManager.Provider,
GraphSelectionListener {
    private static final Logger _logger = Logger.getLogger((String)ConsoleComponent.class.getName());
    public static final String CONSOLE_NAME = ConsoleComponent.a("console_displayname");
    private static ConsoleComponent _instance;
    private transient ExplorerManager _manager;
    private transient ExplorerTreeView _treeView;
    private transient ViewComponent _currentComponent;

    private ConsoleComponent() {
        this.setDisplayName(CONSOLE_NAME);
        this._manager = new ExplorerManager();
        ActionMap actionMap = this.getActionMap();
        actionMap.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this._manager));
        actionMap.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this._manager));
        actionMap.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this._manager));
        actionMap.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this._manager, (boolean)true));
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this._manager, (ActionMap)actionMap));
        this.createComponents();
    }

    public void createComponents() {
        JTabbedPane jTabbedPane = new JTabbedPane(1);
        StringTreeNode stringTreeNode = new StringTreeNode(true);
        stringTreeNode.setIconBase(SwingUtil.getImageAbsoluteFileName("root"));
        this._manager.setRootContext((Node)stringTreeNode);
        this._treeView = new StructuralTreeView(this._manager, this.getCurrentGraph(), stringTreeNode);
        FunctionTreeView functionTreeView = new FunctionTreeView(this._manager, this.getCurrentGraph(), stringTreeNode);
        jTabbedPane.addTab(ConsoleComponent.a("console_ip_view"), (Component)((Object)this._treeView));
        jTabbedPane.addTab(ConsoleComponent.a("console_function_view"), (Component)((Object)functionTreeView));
        if (!Startup.isFreeEdition()) {
            // empty if block
        }
        jTabbedPane.setSelectedIndex(0);
        jTabbedPane.addChangeListener(new ConsoleComponent$1(this, jTabbedPane));
        this.setLayout(new BorderLayout());
        this.add("Center", jTabbedPane);
    }

    public TreeNode getRootNode() {
        return this._treeView.getRootNode();
    }

    public Node[] getSelectedNodes() {
        return this._treeView.getSelectedNodes();
    }

    public boolean setCurrentComponent(ViewComponent viewComponent) {
        Object object;
        if (this._currentComponent == viewComponent) {
            return false;
        }
        NetworkGraph networkGraph = this.getCurrentGraph();
        if (networkGraph != null) {
            networkGraph.removeGraphSelectionListener(this);
        }
        if (this._currentComponent != null) {
            object = (ToBackAction)SystemAction.get(ToBackAction.class);
            object.updateBackAction(this._currentComponent.getViewID());
        }
        this._currentComponent = viewComponent;
        this.createTree();
        object = this.getCurrentGraph();
        if (object != null) {
            object.removeGraphSelectionListener(this);
            object.addGraphSelectionListener(this);
        }
        return true;
    }

    public void createTree() {
        this._treeView.createTree(this.getCurrentGraph());
    }

    public void clearTree() {
        this._treeView.clearTree();
    }

    public NetworkGraph getCurrentGraph() {
        if (this._currentComponent == null) {
            return null;
        }
        return this._currentComponent.getGraph();
    }

    public ViewComponent getCurrentComponent() {
        return this._currentComponent;
    }

    public void valueChanged(GraphSelectionEvent graphSelectionEvent) {
        this.getCurrentGraph().repaint();
        if (this._currentComponent != null) {
            Object[] objectArray = this._currentComponent.getGraph().getSelectionCells();
            this._treeView.selectTreeNodeByGraphVertexes(objectArray);
            FunctionManager.getInstance().updateEditAction();
        }
    }

    public void setSelectionNode(Node node) {
        this._treeView.setSelectedTreeNodes(new Node[]{node});
    }

    public void clearSelection() {
        NetworkGraph networkGraph = this.getCurrentGraph();
        if (networkGraph != null) {
            networkGraph.clearSelection();
        }
        this._treeView.clearSelection();
    }

    public int getPersistenceType() {
        return 0;
    }

    public String getName() {
        return ConsoleComponent.a("console_name");
    }

    protected String preferredID() {
        return "CONSOLECOMPONENT";
    }

    /*
     * Loose catch block
     */
    public static synchronized ConsoleComponent getInstance() {
        block9: {
            block11: {
                block10: {
                    boolean bl2 = Startup.h();
                    if (_instance != null) break block9;
                    try {
                        block12: {
                            if (!SwingUtilities.isEventDispatchThread()) break block10;
                            break block12;
                            catch (Exception exception) {
                                throw ConsoleComponent.a(exception);
                            }
                        }
                        _instance = (ConsoleComponent)WindowManager.getDefault().findTopComponent("CONSOLECOMPONENT");
                        if (!bl2) break block11;
                    }
                    catch (Exception exception) {
                        throw ConsoleComponent.a(exception);
                    }
                }
                try {
                    SwingUtilities.invokeAndWait(new ConsoleComponent$2());
                }
                catch (Exception exception) {
                    _logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
            try {
                if (_instance == null) {
                    _instance = new ConsoleComponent();
                }
            }
            catch (Exception exception) {
                throw ConsoleComponent.a(exception);
            }
        }
        return _instance;
    }

    public ExplorerManager getExplorerManager() {
        return this._manager;
    }

    public void addNotify() {
        super.addNotify();
        ExplorerUtils.activateActions((ExplorerManager)this._manager, (boolean)true);
    }

    public void removeNotify() {
        ExplorerUtils.activateActions((ExplorerManager)this._manager, (boolean)false);
        super.removeNotify();
    }

    public Object readResolve() {
        return ConsoleComponent.getInstance();
    }

    public TreeNode findTreeNodeByGraphNode(NetworkNode networkNode) {
        return this._treeView.findTreeNodeByGraphNode(networkNode);
    }

    private static String a(String string) {
        return NbBundle.getBundle(ConsoleComponent.class).getString(string);
    }

    public void setEmptyWhenApplyLicense() {
        ((ToFrontAction)SystemAction.get(ToFrontAction.class)).clearFront();
        ((ToBackAction)SystemAction.get(ToBackAction.class)).clearBack();
        ComponentUtils.closeAllViewComponents();
        this._treeView.clearTree();
        AlarmViewController.INSTANCE.clearAllAlarms();
    }

    public ExplorerTreeView getTreeView() {
        return this._treeView;
    }

    public void updateStatus() {
        this.getTreeView().updateStatus();
        this.updateGraphStatus();
        SwingUtilities.invokeLater(() -> ((PropertySheet)NbSheet.getDefault().getComponent(0)).updateDescription());
    }

    public void updateGraphStatus() {
        NetworkGraph networkGraph = this.getCurrentGraph();
        if (networkGraph != null) {
            networkGraph.updateStatus();
        }
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

