/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.actions;

import com.sysuptime.common.discovery.DiscoveryOptionsData;
import com.sysuptime.common.msp.Probe;
import com.sysuptime.common.util.ICommonBundle;
import com.sysuptime.common.util.LockResponse;
import com.sysuptime.common.util.RmiResponse;
import com.sysuptime.mainframe.AlarmViewController;
import com.sysuptime.mainframe.ComponentUtils;
import com.sysuptime.mainframe.ConsoleComponent;
import com.sysuptime.mainframe.Startup;
import com.sysuptime.mainframe.actions.FindNodeAction;
import com.sysuptime.mainframe.discovery.DiscoveryMessageFrame;
import com.sysuptime.mainframe.discovery.DiscoveryOptionsDialog;
import com.sysuptime.mainframe.discovery.DiscoveryReportDialog;
import com.sysuptime.mainframe.graph.GraphLoader;
import com.sysuptime.mainframe.msp.ClientProxy;
import com.sysuptime.mainframe.msp.ProxyMBeanInvoker;
import com.sysuptime.mainframe.util.JNDIClient;
import com.sysuptime.mainframe.util.SwingUtil;
import com.sysuptime.mainframe.util.SystemStatusMBeanInvoker;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.netbeans.modules.openide.util.AWTBridge;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public final class DiscoveryAction
extends SystemAction
implements Presenter.Menu {
    private static final Logger _logger = Logger.getLogger((String)DiscoveryAction.class.getName());
    private static boolean _isDiscovering = false;
    private static DiscoveryMessageFrame _discoveryMessageFrame;

    public String getName() {
        return DiscoveryAction.a("actions_discovery");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected String iconResource() {
        return SwingUtil.getImageAbsoluteFileName("actions/discovery.gif");
    }

    public JMenuItem getMenuPresenter() {
        return AWTBridge.getDefault().createMenuPresenter((Action)((Object)this));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!ClientProxy.getInstance().resetProbe()) {
            return;
        }
        DiscoveryAction.doDiscovery(ClientProxy.getInstance().getProbe());
    }

    public static void doDiscovery(Probe probe) {
        block11: {
            block10: {
                int n2 = FindNodeAction.b();
                _logger.info((Object)"doDiscovery is invoked.");
                int n3 = n2;
                if (!JNDIClient.isServerReachable()) {
                    return;
                }
                if (_isDiscovering) {
                    JOptionPane.showMessageDialog(Startup.getFrame(), "Discovery is in progress.");
                    return;
                }
                Startup.changeToTopoTab();
                LockResponse lockResponse = SystemStatusMBeanInvoker.lockEditMode(Startup.getGlobalCallbackClient());
                if (lockResponse == null) break block10;
                switch (lockResponse.getErrorCode()) {
                    case 0: {
                        DiscoveryAction.startDiscovery(probe);
                        if (n3 == 0) break;
                    }
                    case -1: {
                        JOptionPane.showMessageDialog(Startup.getFrame(), NbBundle.getMessage(DiscoveryAction.class, (String)"actions_discovery_msg_userDiscovering", (Object[])new Object[]{lockResponse.getUserName(), lockResponse.getIpAddress(), lockResponse.getHostName()}));
                        if (n3 == 0) break;
                    }
                    case -3: {
                        JOptionPane.showMessageDialog(Startup.getFrame(), NbBundle.getMessage(DiscoveryAction.class, (String)"actions_discovery_msg_periodicalDiscovering"));
                    }
                }
                if (n3 == 0) break block11;
            }
            JOptionPane.showMessageDialog(Startup.getFrame(), DiscoveryAction.a("actions_discovery_starterror"));
        }
    }

    public static void startDiscovery(Probe probe) {
        block3: {
            block2: {
                int n2 = FindNodeAction.c();
                _logger.info((Object)"StartDiscovery invoked.");
                int n3 = n2;
                if (!DiscoveryAction.a(probe)) break block2;
                Startup.setCurDiscoveringProbe(probe);
                _logger.info((Object)"Option returned OK");
                AlarmViewController.INSTANCE.clearAllAlarms();
                DiscoveryMessageFrame discoveryMessageFrame = new DiscoveryMessageFrame();
                discoveryMessageFrame.setSize(600, 450);
                SwingUtil.centerOnFrame(Startup.getFrame(), discoveryMessageFrame);
                discoveryMessageFrame.setVisible(true);
                _logger.info((Object)"Show disocvery frame");
                new Thread(() -> {
                    try {
                        _isDiscovering = true;
                        _logger.info((Object)"Starting doing discovery");
                        DiscoveryAction.a(discoveryMessageFrame, probe);
                    }
                    catch (Exception exception) {
                        _logger.error((Object)"", (Throwable)exception);
                        SwingUtilities.invokeLater(() -> {
                            discoveryMessageFrame.dispose();
                            int n2 = JOptionPane.showConfirmDialog(Startup.getFrame(), DiscoveryAction.a("actions_discovery_enderror") + " report? ", ICommonBundle.ERROR, 0);
                            if (n2 == 0) {
                                SystemStatusMBeanInvoker.reportError(null);
                            }
                        });
                    }
                    _isDiscovering = false;
                    _discoveryMessageFrame = null;
                }).start();
                if (n3 != 0) break block3;
            }
            _logger.info((Object)"Option cancelled");
        }
    }

    private static boolean a(Probe probe) {
        block5: {
            try {
                DiscoveryOptionsData discoveryOptionsData = ProxyMBeanInvoker.INSTANCE.getDiscoveryOptions(probe.getId(), Startup.getCurrentUserName());
                DiscoveryOptionsDialog discoveryOptionsDialog = new DiscoveryOptionsDialog(discoveryOptionsData);
                discoveryOptionsDialog.showCenterOnOwner();
                if (!discoveryOptionsDialog.isOK()) break block5;
                discoveryOptionsData = discoveryOptionsDialog.getOptions();
                try {
                    if (!ProxyMBeanInvoker.INSTANCE.saveDiscoveryOptions(probe.getId(), Startup.getCurrentUserName(), discoveryOptionsData)) {
                        JOptionPane.showMessageDialog(Startup.getFrame(), DiscoveryAction.a("msg_saveDiscoveryOptionsFailed"), ICommonBundle.ERROR, 0);
                    }
                }
                catch (Exception exception) {
                    throw DiscoveryAction.a(exception);
                }
                return true;
            }
            catch (Exception exception) {
                _logger.error((Object)"showOptionsDialog", (Throwable)exception);
                JOptionPane.showMessageDialog(Startup.getFrame(), DiscoveryAction.a("actions_discovery_starterror"));
            }
        }
        return false;
    }

    private static void a(DiscoveryMessageFrame discoveryMessageFrame, Probe probe) throws Exception {
        RmiResponse rmiResponse = ProxyMBeanInvoker.INSTANCE.doDiscovery(probe.getId(), Startup.getGlobalCallbackClient());
        try {
            if (!((Boolean)rmiResponse.getValue()).booleanValue()) {
                throw new Exception("Internal error during discovery");
            }
        }
        catch (Exception exception) {
            throw DiscoveryAction.a(exception);
        }
        try {
            if (GraphLoader.getInstance().loadViewFilesFromServer() == null) {
                throw new Exception("Save to Local Error");
            }
        }
        catch (Exception exception) {
            throw DiscoveryAction.a(exception);
        }
        long l2 = probe.getId();
        SwingUtilities.invokeLater(() -> {
            ComponentUtils.refreshOpenedViews();
            ConsoleComponent.getInstance().createTree();
            discoveryMessageFrame.dispose();
            DiscoveryReportDialog discoveryReportDialog = new DiscoveryReportDialog(l2);
            discoveryReportDialog.show();
        });
    }

    private static String a(String string) {
        return NbBundle.getMessage(DiscoveryAction.class, (String)string);
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

