/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.actions;

import com.sysuptime.common.discovery.DeviceOption;
import com.sysuptime.common.discovery.SubnetOption;
import com.sysuptime.common.graph.NetworkGraphModel;
import com.sysuptime.common.model.Customer;
import com.sysuptime.common.model.NetworkNode;
import com.sysuptime.common.model.NetworkNodeBean;
import com.sysuptime.common.model.Subnet;
import com.sysuptime.common.util.LockResponse;
import com.sysuptime.mainframe.AlarmViewController;
import com.sysuptime.mainframe.ComponentUtils;
import com.sysuptime.mainframe.ConsoleComponent;
import com.sysuptime.mainframe.Startup;
import com.sysuptime.mainframe.actions.DiscoveryAction;
import com.sysuptime.mainframe.actions.FindNodeAction;
import com.sysuptime.mainframe.actions.UpdateNodeAction$1;
import com.sysuptime.mainframe.actions.UpdateNodeAction$2;
import com.sysuptime.mainframe.discovery.UpdateDeviceDialog;
import com.sysuptime.mainframe.discovery.UpdateSubnetDialog;
import com.sysuptime.mainframe.graph.GraphLoader;
import com.sysuptime.mainframe.graph.NetworkGraph;
import com.sysuptime.mainframe.msp.ClientProxy;
import com.sysuptime.mainframe.msp.ProxyMBeanInvoker;
import com.sysuptime.mainframe.util.FunctionManager;
import com.sysuptime.mainframe.util.IndeterminateWaitDialog;
import com.sysuptime.mainframe.util.JNDIClient;
import com.sysuptime.mainframe.util.SystemStatusMBeanInvoker;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class UpdateNodeAction
extends AbstractAction {
    private static final Logger _logger = Logger.getLogger((String)UpdateNodeAction.class.getName());
    private NetworkNodeBean _bean;

    public UpdateNodeAction(NetworkNodeBean networkNodeBean) {
        super(UpdateNodeAction.a("actions_updateNode"));
        this._bean = networkNodeBean;
        this.setEnabled(FunctionManager.getInstance().isDiscoveryEnabled());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block11: {
            block10: {
                long l2 = Long.parseLong(this._bean.getCustomerID());
                int n2 = FindNodeAction.b();
                if (!ClientProxy.getInstance().isActive(l2)) {
                    return;
                }
                if (!JNDIClient.isServerReachable()) {
                    return;
                }
                LockResponse lockResponse = SystemStatusMBeanInvoker.lockEditMode(Startup.getGlobalCallbackClient());
                if (lockResponse == null) break block10;
                switch (lockResponse.getErrorCode()) {
                    case 0: {
                        this.a();
                        if (n2 == 0) break;
                    }
                    case -1: {
                        JOptionPane.showMessageDialog(Startup.getFrame(), NbBundle.getMessage(DiscoveryAction.class, (String)"actions_discovery_msg_userDiscovering", (Object[])new Object[]{lockResponse.getUserName(), lockResponse.getIpAddress(), lockResponse.getHostName()}));
                        if (n2 == 0) break;
                    }
                    case -3: {
                        JOptionPane.showMessageDialog(Startup.getFrame(), NbBundle.getMessage(DiscoveryAction.class, (String)"actions_discovery_msg_periodicalDiscovering"));
                    }
                }
                if (n2 == 0) break block11;
            }
            JOptionPane.showMessageDialog(Startup.getFrame(), UpdateNodeAction.a("actions_discovery_starterror"));
        }
    }

    private void a() {
        block4: {
            block5: {
                int n2;
                block2: {
                    block3: {
                        n2 = FindNodeAction.b();
                        if (!(this._bean instanceof Customer)) break block2;
                        if (!Startup.isMaster()) break block3;
                        Startup.setAllProbes();
                        DiscoveryAction.startDiscovery(Startup.getProbeById(Long.valueOf(this._bean.getPrivateID())));
                        if (n2 == 0) break block4;
                    }
                    DiscoveryAction.startDiscovery(ClientProxy.getInstance().getProbe());
                    if (n2 == 0) break block4;
                }
                if (!(this._bean instanceof Subnet)) break block5;
                this.b();
                if (n2 == 0) break block4;
            }
            this.c();
        }
    }

    private void b() {
        UpdateSubnetDialog updateSubnetDialog = new UpdateSubnetDialog(Startup.getFrame(), (Subnet)this._bean);
        updateSubnetDialog.pack();
        updateSubnetDialog.showCenterOnOwner();
        if (updateSubnetDialog.isOK()) {
            AlarmViewController.INSTANCE.clearAllAlarms();
            IndeterminateWaitDialog indeterminateWaitDialog = new IndeterminateWaitDialog(Startup.getFrame(), true);
            indeterminateWaitDialog.pack();
            SwingUtilities.invokeLater(() -> {
                SubnetOption subnetOption = updateSubnetDialog.getOption();
                subnetOption.setProbeID(Long.parseLong(this._bean.getCustomerID()));
                subnetOption.setParentID(ConsoleComponent.getInstance().getCurrentGraph().getGraphID());
                try {
                    ClientProxy.getInstance().updateNode(subnetOption);
                }
                catch (Exception exception) {
                    _logger.error((Object)"updateNode", (Throwable)exception);
                }
                SwingUtilities.invokeLater(new UpdateNodeAction$1(this, indeterminateWaitDialog));
            });
            indeterminateWaitDialog.showCenterOnOwner();
        }
    }

    private void c() {
        NetworkGraph networkGraph = ConsoleComponent.getInstance().getCurrentGraph();
        NetworkGraphModel networkGraphModel = (NetworkGraphModel)networkGraph.getModel();
        UpdateDeviceDialog updateDeviceDialog = new UpdateDeviceDialog(Startup.getFrame(), this._bean, networkGraphModel);
        updateDeviceDialog.pack();
        updateDeviceDialog.showCenterOnOwner();
        if (updateDeviceDialog.isOK()) {
            AlarmViewController.INSTANCE.clearAllAlarms();
            DeviceOption deviceOption = updateDeviceDialog.getOption();
            deviceOption.setProbeID(Long.parseLong(this._bean.getCustomerID()));
            boolean bl2 = false;
            try {
                bl2 = ProxyMBeanInvoker.INSTANCE.isNodeReachable(deviceOption.getProbeID(), deviceOption.getIP());
            }
            catch (Exception exception) {
                _logger.error((Object)"isNodeReachable", (Throwable)exception);
            }
            if (!bl2) {
                int n2 = JOptionPane.showConfirmDialog(Startup.getFrame(), UpdateNodeAction.a("UpdateAction_confirm_unreachable"), "", 0);
                if (n2 == 0) {
                    NetworkNode networkNode = networkGraphModel.getNodeByBean(this._bean);
                    networkGraphModel.remove(new Object[]{networkNode});
                    GraphLoader.save2Local(networkGraph);
                    GraphLoader.save2Server(networkGraphModel, true);
                    ComponentUtils.refreshOpenedViews();
                    ConsoleComponent.getInstance().createTree();
                }
                return;
            }
            IndeterminateWaitDialog indeterminateWaitDialog = new IndeterminateWaitDialog(Startup.getFrame(), true);
            indeterminateWaitDialog.pack();
            SwingUtilities.invokeLater(() -> {
                try {
                    ClientProxy.getInstance().updateNode(deviceOption);
                }
                catch (Exception exception) {
                    _logger.error((Object)"updateNode", (Throwable)exception);
                }
                SwingUtilities.invokeLater(new UpdateNodeAction$2(this, indeterminateWaitDialog));
            });
            indeterminateWaitDialog.showCenterOnOwner();
        }
    }

    private static String a(String string) {
        return NbBundle.getMessage(UpdateNodeAction.class, (String)string);
    }
}

