/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.discovery;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.common.discovery.SubnetOption;
import com.sysuptime.common.model.Subnet;
import com.sysuptime.mainframe.discovery.UpdateSubnetDialog$1;
import com.sysuptime.mainframe.discovery.UpdateSubnetDialog$EditServiceAction;
import com.sysuptime.mainframe.msp.ClientProxy;
import com.sysuptime.mainframe.util.ConfirmDialog;
import com.sysuptime.mainframe.util.FormUtils;
import com.sysuptime.mainframe.util.SwingUtil;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openide.util.NbBundle;

public class UpdateSubnetDialog
extends ConfirmDialog {
    private Subnet _subnet;
    private JTextField _timeoutField;
    private JCheckBox _serviceCheck;
    private JButton _editServiceButton;
    private JCheckBox _cleanDiscoveryCheck;
    private JTextField _threadsNumField;
    private List _scanServices;
    private boolean _isOK;

    public UpdateSubnetDialog(Frame frame, Subnet subnet) {
        super(frame, "", true);
        this._subnet = subnet;
        this.d();
        SwingUtil.dialogBindingESC(this, null);
    }

    private void d() {
        this.setTitle(UpdateSubnetDialog.a("UpdateSubnet_title") + ": " + this._subnet.getIpAddress());
        this._timeoutField.setText("1.0");
        this._editServiceButton.setEnabled(false);
        this._serviceCheck.addActionListener(new UpdateSubnetDialog$1(this));
        this._threadsNumField.setText("30");
    }

    @Override
    protected JPanel getCenterPane() {
        return this.f();
    }

    private void e() {
        this._timeoutField = new JTextField();
        this._serviceCheck = new JCheckBox();
        this._editServiceButton = new JButton(new UpdateSubnetDialog$EditServiceAction(this));
        this._cleanDiscoveryCheck = new JCheckBox();
        this._threadsNumField = new JTextField();
    }

    private JPanel f() {
        this.e();
        JPanel jPanel = new JPanel();
        FormLayout formLayout = new FormLayout("FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:GROW(1.0),FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE", "CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE");
        CellConstraints cellConstraints = new CellConstraints();
        jPanel.setLayout((LayoutManager)formLayout);
        JLabel jLabel = new JLabel();
        jLabel.setText(UpdateSubnetDialog.a("label_timeout"));
        jPanel.add((Component)jLabel, cellConstraints.xy(3, 3));
        jPanel.add((Component)this._timeoutField, cellConstraints.xywh(5, 3, 3, 1));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(UpdateSubnetDialog.a("label_detectServices"));
        jPanel.add((Component)jLabel2, cellConstraints.xy(3, 5));
        jPanel.add((Component)this._serviceCheck, cellConstraints.xy(5, 5));
        jPanel.add((Component)this._editServiceButton, cellConstraints.xy(7, 5));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(UpdateSubnetDialog.a("lable_seconds"));
        jPanel.add((Component)jLabel3, cellConstraints.xy(9, 3));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText(UpdateSubnetDialog.a("label_cleanDiscovery"));
        jPanel.add((Component)jLabel4, cellConstraints.xy(3, 7));
        jPanel.add((Component)this._cleanDiscoveryCheck, cellConstraints.xy(5, 7));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText(UpdateSubnetDialog.a("label_threads"));
        jPanel.add((Component)jLabel5, cellConstraints.xy(3, 9));
        jPanel.add((Component)this._threadsNumField, cellConstraints.xywh(5, 9, 3, 1));
        FormUtils.addFillComponents(jPanel, new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}, new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11});
        return jPanel;
    }

    public void setScanServices(List list) {
        this._scanServices = list;
    }

    @Override
    protected void doOK() {
        long l2 = Long.parseLong(this._subnet.getCustomerID());
        if (!ClientProxy.getInstance().isActive(l2)) {
            return;
        }
        if (!this.g()) {
            return;
        }
        this._isOK = true;
        this.dispose();
    }

    private boolean g() {
        if (!this.h()) {
            return false;
        }
        return this.i();
    }

    private boolean h() {
        double d10;
        String string = this._timeoutField.getText();
        try {
            if (string.length() == 0) {
                JOptionPane.showMessageDialog(this, UpdateSubnetDialog.a("DiscoveryOptionsDialog_msg_timeoutRequired"));
                return false;
            }
        }
        catch (Exception exception) {
            throw UpdateSubnetDialog.a(exception);
        }
        try {
            d10 = Double.parseDouble(string);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, UpdateSubnetDialog.a("DiscoveryOptionsDialog_msg_timeoutRange"));
            return false;
        }
        try {
            if (d10 < 1.0) {
                JOptionPane.showMessageDialog(this, UpdateSubnetDialog.a("DiscoveryOptionsDialog_msg_timeoutRange"));
                return false;
            }
        }
        catch (Exception exception) {
            throw UpdateSubnetDialog.a(exception);
        }
        return true;
    }

    private boolean i() {
        int n2;
        String string = this._threadsNumField.getText();
        try {
            if (string.length() == 0) {
                JOptionPane.showMessageDialog(this, UpdateSubnetDialog.a("DiscoveryOptionsDialog_msg_threadsRequired"));
                return false;
            }
        }
        catch (Exception exception) {
            throw UpdateSubnetDialog.a(exception);
        }
        try {
            n2 = Integer.parseInt(string);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, UpdateSubnetDialog.a("DiscoveryOptionsDialog_msg_threadsRange"));
            return false;
        }
        try {
            if (n2 < 1) {
                JOptionPane.showMessageDialog(this, UpdateSubnetDialog.a("DiscoveryOptionsDialog_msg_threadsRange"));
                return false;
            }
        }
        catch (Exception exception) {
            throw UpdateSubnetDialog.a(exception);
        }
        return true;
    }

    public boolean isOK() {
        return this._isOK;
    }

    public SubnetOption getOption() {
        int n2 = (int)Double.parseDouble(this._timeoutField.getText()) * 1000;
        boolean bl2 = this._serviceCheck.isSelected();
        boolean bl3 = this._cleanDiscoveryCheck.isSelected();
        int n3 = Integer.parseInt(this._threadsNumField.getText());
        return new SubnetOption(this._subnet.getIpAddress(), n2, bl2, this._scanServices, bl3, n3);
    }

    private static String a(String string) {
        return NbBundle.getMessage(UpdateSubnetDialog.class, (String)string);
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

