/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.nodes;

import com.sysuptime.common.graph.GraphID;
import com.sysuptime.common.graph.NetworkGraphModel;
import com.sysuptime.common.model.DeviceBean;
import com.sysuptime.common.model.NetworkNode;
import com.sysuptime.common.model.NetworkNodeBean;
import com.sysuptime.common.model.OtherPropertiesSupport;
import com.sysuptime.common.model.ParentNode;
import com.sysuptime.common.model.TopoNode;
import com.sysuptime.common.util.ICommonBundle;
import com.sysuptime.mainframe.AlarmViewController;
import com.sysuptime.mainframe.ConsoleComponent;
import com.sysuptime.mainframe.actions.ClearTrapOnTreeAction;
import com.sysuptime.mainframe.actions.ExpandAllNodesAction;
import com.sysuptime.mainframe.actions.SNMPInfoAction;
import com.sysuptime.mainframe.actions.ShowPingNodeDialogAction;
import com.sysuptime.mainframe.actions.ShowTraceNodeDialogAction;
import com.sysuptime.mainframe.actions.TreeNodeSNMPInfoAction;
import com.sysuptime.mainframe.actions.ViewNodeTrapsAction;
import com.sysuptime.mainframe.graph.NetworkGraph;
import com.sysuptime.mainframe.nodes.OtherProperty;
import com.sysuptime.mainframe.nodes.TreeNode;
import com.sysuptime.mainframe.nodes.editors.BeanCommonProperty;
import com.sysuptime.mainframe.nodes.editors.DeviceIconProperty;
import com.sysuptime.mainframe.nodes.editors.DeviceNameProperty;
import com.sysuptime.mainframe.nodes.editors.InterfacesProperties;
import com.sysuptime.mainframe.nodes.editors.PortInfoProperties;
import com.sysuptime.mainframe.nodes.editors.SnmpParamProperties;
import com.sysuptime.mainframe.util.SwingUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.actions.SystemAction;

public abstract class BeanTreeNode
extends TreeNode {
    private GraphID _graphID;
    protected TopoNode _node;
    private boolean _isAlarmingIcon;

    public BeanTreeNode(Children children, TopoNode topoNode, GraphID graphID) {
        super(children);
        this._node = topoNode;
        this._graphID = graphID;
    }

    public String getBaseName() {
        return this.getBean().getDisplayName();
    }

    public TopoNode getNode() {
        return this._node;
    }

    public NetworkNodeBean getBean() {
        return this._node.getBean();
    }

    protected Sheet createSheet() {
        List list;
        PropertySupport propertySupport;
        PropertySupport propertySupport2;
        Sheet.Set set;
        NetworkNodeBean networkNodeBean = this.getBean();
        Sheet sheet = super.createSheet();
        int[] nArray = TreeNode.b();
        if (!(networkNodeBean instanceof NetworkNodeBean)) {
            return sheet;
        }
        NetworkGraph networkGraph = ConsoleComponent.getInstance().getCurrentGraph();
        NetworkNode networkNode = ((NetworkGraphModel)networkGraph.getModel()).getNodeByBean(networkNodeBean);
        if (networkNode != null) {
            set = new Sheet.Set();
            set.setName(BeanTreeNode.b("lannode_displayproperty"));
            set.setDisplayName(BeanTreeNode.b("lannode_displayname"));
            set.setShortDescription(BeanTreeNode.b("lannode_displaydescription"));
            set.put((Node.Property)new DeviceNameProperty(BeanTreeNode.b("lannode_value"), this));
            set.put((Node.Property)new DeviceIconProperty(BeanTreeNode.b("lannode_icon"), networkNode));
            sheet.put(set);
        }
        set = new Sheet.Set();
        set.setName(BeanTreeNode.b("lannode_device_info"));
        set.setDisplayName(BeanTreeNode.b("lannode_device_info_show"));
        set.setShortDescription(BeanTreeNode.b("lannode_device_info_show_description"));
        PropertySupport propertySupport3 = this.d();
        if (propertySupport3 != null) {
            set.put((Node.Property)propertySupport3);
        }
        if ((propertySupport3 = this.c()) != null) {
            set.put((Node.Property)propertySupport3);
        }
        if ((propertySupport2 = this.a()) != null) {
            set.put((Node.Property)propertySupport2);
        }
        if ((propertySupport = this.e()) != null) {
            set.put((Node.Property)propertySupport);
        }
        if (networkNodeBean instanceof OtherPropertiesSupport && (list = OtherProperty.getOtherProperties(networkNodeBean)) != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                set.put((Node.Property)((OtherProperty)((Object)iterator.next())));
                if (nArray != null) {
                    if (nArray != null) continue;
                }
                break;
            }
        } else {
            if (networkNodeBean.getScanServices() != null && !networkNodeBean.getScanServices().isEmpty()) {
                set.put((Node.Property)new PortInfoProperties("Services", networkNodeBean));
            }
            sheet.put(set);
        }
        return sheet;
    }

    protected PropertySupport a() {
        NetworkNodeBean networkNodeBean = this.getBean();
        if (networkNodeBean.isSnmpEnabled()) {
            return new SnmpParamProperties(BeanTreeNode.b("lannode_community"), networkNodeBean);
        }
        return null;
    }

    protected PropertySupport c() {
        NetworkNodeBean networkNodeBean = this.getBean();
        String string = networkNodeBean.getSysObjectIdValue();
        if (string != null && string.length() > 0) {
            return new BeanCommonProperty(BeanTreeNode.b("lannode_device_sysobjectidvalue"), string);
        }
        return null;
    }

    protected PropertySupport d() {
        NetworkNodeBean networkNodeBean = this.getBean();
        try {
            return new BeanCommonProperty(BeanTreeNode.b("lannode_device_dedicated"), networkNodeBean.getDedicated()[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected PropertySupport e() {
        NetworkNodeBean networkNodeBean = this.getBean();
        if (networkNodeBean instanceof DeviceBean && networkNodeBean.getInterfaces().length > 0) {
            return new InterfacesProperties(ICommonBundle.INTERFACES, networkNodeBean);
        }
        return null;
    }

    protected abstract void f();

    public GraphID getGraphID() {
        return this._graphID;
    }

    protected void g() {
        if (this._isAlarmingIcon) {
            this.setIconBase(SwingUtil.getImageAbsoluteFileName("subnet"));
            this._isAlarmingIcon = false;
        }
    }

    protected void h() {
        if (!this._isAlarmingIcon) {
            this.setIconBase(SwingUtil.getImageAbsoluteFileName("nodedown"));
            this._isAlarmingIcon = true;
        }
    }

    public void updateStatus() {
        block3: {
            block2: {
                int[] nArray = TreeNode.b();
                if (!this.i()) break block2;
                this.h();
                if (nArray != null) break block3;
            }
            this.g();
        }
        this.f();
    }

    private boolean i() {
        return AlarmViewController.INSTANCE.isAlarming(this._node);
    }

    @Override
    public Action[] getActions(boolean bl2) {
        Action[] actionArray;
        ArrayList<Action> arrayList;
        block5: {
            Action[] actionArray2 = super.getActions(false);
            ArrayList<Action> arrayList2 = new ArrayList<Action>();
            int[] nArray = TreeNode.b();
            for (int i2 = 0; i2 < actionArray2.length; ++i2) {
                arrayList = arrayList2;
                actionArray = actionArray2;
                if (nArray != null) {
                    arrayList.add(actionArray[i2]);
                    if (i2 == 0 || actionArray2[i2 - 1] == null || !actionArray2[i2 - 1].equals(SystemAction.get(ExpandAllNodesAction.class))) continue;
                    NetworkNodeBean networkNodeBean = this.getBean();
                    if (!(this._node instanceof ParentNode)) {
                        arrayList2.add((Action)SystemAction.get(ShowPingNodeDialogAction.class));
                        arrayList2.add((Action)SystemAction.get(ShowTraceNodeDialogAction.class));
                        arrayList2.add(null);
                    }
                    arrayList2.add((Action)SystemAction.get(ViewNodeTrapsAction.class));
                    arrayList2.add((Action)SystemAction.get(ClearTrapOnTreeAction.class));
                    arrayList2.add(null);
                    if (networkNodeBean != null && networkNodeBean.isSnmpEnabled()) {
                        arrayList2.add(new TreeNodeSNMPInfoAction(networkNodeBean));
                    }
                    if (networkNodeBean != null) {
                        arrayList2.add(new SNMPInfoAction(SNMPInfoAction.MIBBROWSER, networkNodeBean, networkNodeBean.getIPInSubnet(this._graphID.getGraphName())));
                    }
                    arrayList2.add(null);
                    if (nArray != null) continue;
                }
                break block5;
            }
            arrayList = arrayList2;
            actionArray = new Action[arrayList2.size()];
        }
        return arrayList.toArray(actionArray);
    }
}

