/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.nodes.editors;

import com.sysuptime.common.model.Layer2Connection;
import com.sysuptime.common.model.NetworkConnection;
import com.sysuptime.common.model.NetworkInterface;
import com.sysuptime.common.model.Subnet;
import com.sysuptime.mainframe.ConsoleComponent;
import com.sysuptime.mainframe.graph.NetworkGraph;
import com.sysuptime.mainframe.nodes.editors.ConnectionCustomEditor;
import java.awt.Component;
import org.apache.log4j.Logger;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.GraphModel;
import org.netbeans.beaninfo.editors.StringEditor;
import org.openide.explorer.propertysheet.ExPropertyEditor;

public class ConnectionEditor
extends StringEditor
implements ExPropertyEditor {
    private static final Logger _logger = Logger.getLogger(ConnectionEditor.class);
    private NetworkConnection _connection;
    private boolean _isSource;

    public ConnectionEditor(NetworkConnection networkConnection, boolean bl2) {
        this._connection = networkConnection;
        this._isSource = bl2;
    }

    public boolean supportsCustomEditor() {
        try {
            if (this._connection instanceof Layer2Connection) {
                return false;
            }
        }
        catch (Exception exception) {
            throw ConnectionEditor.a(exception);
        }
        NetworkInterface networkInterface = null;
        try {
            Object object;
            NetworkGraph networkGraph = ConsoleComponent.getInstance().getCurrentGraph();
            if (networkGraph != null) {
                Object object2;
                object = (DefaultGraphModel)networkGraph.getModel();
                try {
                    Object object3 = object2 = this._isSource ? DefaultGraphModel.getSourceVertex((GraphModel)object, (Object)this._connection) : DefaultGraphModel.getTargetVertex((GraphModel)object, (Object)this._connection);
                }
                catch (Exception exception) {
                    throw ConnectionEditor.a(exception);
                }
                if (object2 == null) {
                    return false;
                }
            }
            if ((networkInterface = this._isSource ? (NetworkInterface)this._connection.getAntecedent() : (NetworkInterface)this._connection.getDependent()) != null && (object = networkInterface.getHostNode()) instanceof Subnet) {
                return false;
            }
        }
        catch (Exception exception) {
            _logger.warn((Object)"supportsCustomEditor", (Throwable)exception);
        }
        return true;
    }

    public Component getCustomEditor() {
        return new ConnectionCustomEditor(this._connection, this._isSource);
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

