/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.sysuptime.common.performance.Monitor;
import com.sysuptime.common.performance.MonitorHelper;
import com.sysuptime.common.performance.ServiceNameElement;
import com.sysuptime.common.performance.TargetFactory;
import com.sysuptime.common.util.monitor.Snippet;
import com.sysuptime.mainframe.performance.ConfirmDialog;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.DialogProvider;
import com.sysuptime.mainframe.performance.ITreeElement;
import com.sysuptime.mainframe.performance.MonitorBroker;
import com.sysuptime.mainframe.performance.MonitorTableModel;
import com.sysuptime.mainframe.performance.MonitorsSnapshotViewer;
import com.sysuptime.mainframe.performance.ServiceElement;
import com.sysuptime.mainframe.performance.TreeElementDelegate;
import com.sysuptime.mainframe.performance.XmlNodeElement;
import com.sysuptime.mainframe.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.openide.awt.MouseUtils;

public class AddMonitorDialog
extends ConfirmDialog {
    private static final String TITLE = _bundle.getString("title_addmonitordialog");
    private static final String MESSAGE_ADD_MONITOR = _bundle.getString("message_addmonitor");
    private static final int HOST_NUMBER = 1;
    private MonitorTableModel _scheduleListModel;
    private BodyPanel _body;
    private static JDialog _dialog = null;

    public static JDialog getAddMonitorDialog() {
        return _dialog;
    }

    public AddMonitorDialog(JFrame jFrame, boolean bl2, MonitorTableModel monitorTableModel) {
        super(jFrame, TITLE, bl2);
        _dialog = this;
        this.initComponents();
        this.initUserData(monitorTableModel);
    }

    public AddMonitorDialog(JDialog jDialog, boolean bl2, MonitorTableModel monitorTableModel) {
        super(jDialog, TITLE, bl2);
        _dialog = this;
        this.initComponents();
        this.initUserData(monitorTableModel);
    }

    private void initComponents() {
        Container container = this.getContentPane();
        MonitorHelper.initDom(false);
        this._body = new BodyPanel();
        container.add((Component)this._body, "Center");
        container.add((Component)this.getRefreshPanel(), "South");
        this.getCancelButton().setText(DialogConstants.BUTTON_CLOSE);
        this.getOkButton().setText(DialogConstants.BUTTON_NEW);
        this.pack();
    }

    private void initUserData(MonitorTableModel monitorTableModel) {
        this._scheduleListModel = monitorTableModel;
    }

    private boolean addMonitor() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this._body._monitorTree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode != null && defaultMutableTreeNode.isLeaf()) {
            ServiceNameElement serviceNameElement = (ServiceNameElement)defaultMutableTreeNode.getUserObject();
            if (MonitorHelper.isWizard(serviceNameElement)) {
                try {
                    DialogProvider.createConciseMonitor(serviceNameElement, this._scheduleListModel);
                    return true;
                }
                catch (Exception exception) {
                    this._logger.error((Object)"add Monitor : ", (Throwable)exception);
                    return false;
                }
            }
            String string = serviceNameElement.getLocale();
            Monitor monitor = TargetFactory.getSchedule();
            DialogProvider.createScheduleDialog(this, DialogConstants.BUTTON_NEW + string, serviceNameElement, this._scheduleListModel, -1, monitor);
            new Thread(() -> {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                SwingUtilities.invokeLater(() -> MonitorsSnapshotViewer.getInstance().refresh());
            }).start();
            return true;
        }
        JOptionPane.showMessageDialog(this, MESSAGE_ADD_MONITOR);
        return false;
    }

    @Override
    protected void doRefresh() {
        MonitorHelper.initDom(false);
        this._body.removeAll();
        this._body.initMonitorTree();
        this._body.addTree();
        this._body.updateUI();
    }

    @Override
    protected void okDialog() {
        if (MonitorBroker.isExceedLicense(1)) {
            JOptionPane.showMessageDialog(this, DialogConstants.MESSAGE_EXCEED);
            return;
        }
        this.addMonitor();
    }

    private class BodyPanel
    extends JPanel
    implements ITreeElement {
        private JTree _monitorTree;

        public BodyPanel() {
            this.initMonitorTree();
            this.setLayout(new BorderLayout());
            this.addTree();
        }

        private void addTree() {
            this.add((Component)new JScrollPane(this._monitorTree), "Center");
        }

        @Override
        public Object getLeafNode(ServiceNameElement serviceNameElement) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(serviceNameElement, false);
            defaultMutableTreeNode.setUserObject(serviceNameElement);
            return defaultMutableTreeNode;
        }

        @Override
        public void addNode(Object object, Object object2) {
            ((DefaultMutableTreeNode)object).add((DefaultMutableTreeNode)object2);
        }

        @Override
        public Object getNode(XmlNodeElement xmlNodeElement) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(xmlNodeElement);
            defaultMutableTreeNode.setUserObject(xmlNodeElement);
            return defaultMutableTreeNode;
        }

        @Override
        public Object getRootNode() {
            return new TreeElementDelegate(this).getRootNode();
        }

        private void initMonitorTree() {
            this._monitorTree = SwingUtil.createJTree((DefaultMutableTreeNode)this.getRootNode());
            this._monitorTree.getSelectionModel().setSelectionMode(1);
            SwingUtil.expandAllNodes(this._monitorTree, 10, 2);
            TreePath treePath = new TreePath(this._monitorTree.getModel().getRoot());
            this.expandWizardNode(this._monitorTree, treePath);
            this._monitorTree.addMouseListener(new MonitorAction());
            ToolTipManager.sharedInstance().registerComponent(this._monitorTree);
            this._monitorTree.setCellRenderer(new MyTreeCellRenderer(SwingUtil.getImage("leaf.gif")));
        }

        private void expandWizardNode(JTree jTree, TreePath treePath) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (defaultMutableTreeNode.isLeaf()) {
                ServiceElement serviceElement = MonitorHelper.getService((ServiceNameElement)defaultMutableTreeNode.getUserObject());
                if (serviceElement != null && serviceElement.isWizard()) {
                    jTree.expandPath(treePath.getParentPath());
                }
            } else {
                int n2 = defaultMutableTreeNode.getChildCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    TreePath treePath2 = treePath.pathByAddingChild(defaultMutableTreeNode.getChildAt(i2));
                    this.expandWizardNode(jTree, treePath2);
                }
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(400, 550);
        }
    }

    private class MonitorAction
    extends MouseAdapter {
        private MonitorAction() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n2 = AddMonitorDialog.this._body._monitorTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (n2 != -1 && SwingUtilities.isLeftMouseButton(mouseEvent) && MouseUtils.isDoubleClick((MouseEvent)mouseEvent)) {
                AddMonitorDialog.this.addMonitor();
            }
        }
    }

    private static class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        public MyTreeCellRenderer(ImageIcon imageIcon) {
            this.setLeafIcon(imageIcon);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl2, boolean bl3, boolean bl4, int n2, boolean bl5) {
            super.getTreeCellRendererComponent(jTree, object, bl2, bl3, bl4, n2, bl5);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            String string = null;
            if (bl4) {
                ServiceElement serviceElement = MonitorHelper.getService((ServiceNameElement)defaultMutableTreeNode.getUserObject());
                if (serviceElement != null) {
                    string = serviceElement.getTooltip();
                }
            } else {
                XmlNodeElement xmlNodeElement = (XmlNodeElement)defaultMutableTreeNode.getUserObject();
                if (xmlNodeElement != null) {
                    string = xmlNodeElement.getTooltip();
                }
            }
            this.setToolTipText(string != null ? Snippet.getBundledString(string) : null);
            return this;
        }
    }
}

