/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.ireasoning.util.AgentProperties;
import com.sysuptime.common.expression.IExpression;
import com.sysuptime.common.expression.NormalExpressionConstants;
import com.sysuptime.mainframe.msp.ClientProxy;
import com.sysuptime.mainframe.performance.CPUMonitorPane;
import com.sysuptime.mainframe.performance.ConciseSnmpMonitorSecondDialog;
import com.sysuptime.mainframe.performance.DevicesMonitorPane;
import com.sysuptime.mainframe.performance.SnmpDevicesMonitorPane;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import org.openide.util.NbBundle;

public class ConciseCPUUtilMonitorSecondDialog
extends ConciseSnmpMonitorSecondDialog
implements NormalExpressionConstants {
    private DevicesMonitorPane _cpuMonitorPane;

    public ConciseCPUUtilMonitorSecondDialog(boolean bl2, SnmpDevicesMonitorPane snmpDevicesMonitorPane, AgentProperties agentProperties, DefaultTableModel defaultTableModel) {
        super(bl2, ConciseCPUUtilMonitorSecondDialog.fromBundle("CPU_utilization_quickly_creator_title"), snmpDevicesMonitorPane, agentProperties, defaultTableModel);
        this._cpuMonitorPane = snmpDevicesMonitorPane;
    }

    @Override
    protected IExpression getSubExpressin(IExpression iExpression, int n2) {
        String string = this.getExpressionName();
        if (string.equals("CPU load from MS Windows agent")) {
            return super.createSubExpression(iExpression, n2);
        }
        if (string.equals("CPU Utilization from NET-SNMP agent")) {
            return this.getSpecialExpression("CPU Utilization from NET-SNMP agent");
        }
        return null;
    }

    @Override
    public String getExpressionName() {
        return ((CPUMonitorPane)this._cpuMonitorPane).getExpressionName();
    }

    @Override
    protected String getQueryResultString() {
        return ConciseCPUUtilMonitorSecondDialog.fromBundle("cpu_utilization_result");
    }

    @Override
    protected IExpression createNormalExpression(String string) {
        try {
            if (string.equals("CPU load from MS Windows agent")) {
                String string2 = "cpuLoad";
                String string3 = "Valid if the SNMP agent supports HOST-RESOURCES-MIB. The average, over the last minute, of the percentage of time that this processor was not idle.";
                Vector vector = new Vector();
                Vector<String> vector2 = new Vector<String>();
                vector2.addElement("cpuLoad");
                vector2.addElement(".1.3.6.1.2.1.25.3.3.1.2.");
                vector.add(vector2);
                ClientProxy.getInstance().updateExpression(string, string2, string3, vector);
            } else if (string.equals("CPU Utilization from NET-SNMP agent")) {
                String string4 = "(user + sys + nice ) * 100 / (user + sys + nice + idle)";
                String string5 = "CPU utilization. Valid if SNMP agent is NET-SNMP agent.";
                Vector vector = new Vector();
                Vector<String> vector3 = new Vector<String>();
                vector3.addElement("user");
                vector3.addElement(".1.3.6.1.4.1.2021.11.50.0");
                vector.add(vector3);
                vector3 = new Vector();
                vector3.addElement("sys");
                vector3.addElement(".1.3.6.1.4.1.2021.11.52.0");
                vector.add(vector3);
                vector3 = new Vector();
                vector3.addElement("nice");
                vector3.addElement(".1.3.6.1.4.1.2021.11.51.0");
                vector.add(vector3);
                vector3 = new Vector();
                vector3.addElement("idle");
                vector3.addElement(".1.3.6.1.4.1.2021.11.53.0");
                vector.add(vector3);
                return ClientProxy.getInstance().updateExpression(string, string4, string5, vector);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"save expression Error: ", (Throwable)exception);
        }
        return null;
    }

    private static String fromBundle(String string) {
        return NbBundle.getMessage(ConciseCPUUtilMonitorSecondDialog.class, (String)string);
    }

    @Override
    protected int getMonitorType() {
        return this.CPU_TYPE;
    }
}

