/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.sysuptime.common.performance.ProcessResult;
import com.sysuptime.mainframe.performance.ConciseMonitorUtil;
import com.sysuptime.mainframe.performance.ConciseWMIMonitorFirstDialog;
import com.sysuptime.mainframe.performance.ConciseWmiMemoryMonitorSecondDialog;
import com.sysuptime.mainframe.performance.DevicesMonitorPanelFactory;
import com.sysuptime.mainframe.performance.WmiDevicesMonitorPane;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import org.openide.util.NbBundle;

public class ConciseWmiMemoryMonitorFirstDialog
extends ConciseWMIMonitorFirstDialog {
    public ConciseWmiMemoryMonitorFirstDialog(DefaultTableModel defaultTableModel) {
        super(defaultTableModel);
        this.setTitle(ConciseWmiMemoryMonitorFirstDialog.fromBundle("Title_wmi_memory_util"));
    }

    public ConciseWmiMemoryMonitorFirstDialog() {
        this.setTitle(ConciseWmiMemoryMonitorFirstDialog.fromBundle("Title_wmi_memory_util"));
    }

    @Override
    public WmiDevicesMonitorPane initDevicesMonitorPane(String string) {
        return DevicesMonitorPanelFactory.getInstance().createWmiMemoryMonitorPane(string);
    }

    @Override
    public boolean checkResult(ProcessResult processResult) {
        if (super.checkResult(processResult)) {
            try {
                Double.parseDouble(processResult.getResult());
                return true;
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, processResult.getResult());
                return false;
            }
        }
        return false;
    }

    @Override
    public String getScriptFilePath() {
        return ConciseMonitorUtil.MEMORY_FILE_PATH;
    }

    @Override
    public void createNextDialog(DefaultTableModel defaultTableModel, WmiDevicesMonitorPane wmiDevicesMonitorPane, long l2, int n2, String string) {
        ConciseWmiMemoryMonitorSecondDialog conciseWmiMemoryMonitorSecondDialog = new ConciseWmiMemoryMonitorSecondDialog(true, wmiDevicesMonitorPane, defaultTableModel, l2, n2, string);
        conciseWmiMemoryMonitorSecondDialog.setVisible(true);
    }

    private static String fromBundle(String string) {
        return NbBundle.getMessage(ConciseWmiMemoryMonitorFirstDialog.class, (String)string);
    }
}

