/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.ireasoning.util.MessageParser;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.openapi.performance.CommandVarProcessor;
import com.openapi.performance.QueryParameterElement;
import com.sysuptime.common.performance.FtpHost;
import com.sysuptime.common.performance.QueryParameter;
import com.sysuptime.common.util.monitor.Snippet;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.RemoteProtocolDialog;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FtpDialog
extends RemoteProtocolDialog {
    private JButton _savedFileValidator;
    private JComboBox _changes;
    private JLabel _filePath;
    private JPanel _panel;
    private JTextField _saved;
    private ValidatorAction _action = new ValidatorAction();

    public FtpDialog(JDialog jDialog, String string, boolean bl2, long l2) {
        super(jDialog, string, bl2, l2);
    }

    @Override
    protected int getRemoteProtocol() {
        return FtpHost.FTP_ID;
    }

    @Override
    protected int appendParameterCompenent(DefaultFormBuilder defaultFormBuilder, CellConstraints cellConstraints, QueryParameterElement queryParameterElement, int n2) {
        String string = queryParameterElement.getName();
        String string2 = Snippet.getBundledString(string);
        JComponent jComponent = this.getParameterComponent(queryParameterElement, string2);
        if (string.equalsIgnoreCase("check_changes")) {
            this.appendSavedFileValidator(defaultFormBuilder, jComponent, string2);
        } else {
            defaultFormBuilder.append(string2, (Component)jComponent);
            defaultFormBuilder.append(this.getLineEnd(queryParameterElement));
        }
        return n2;
    }

    @Override
    protected void initParameterData(QueryParameter queryParameter) {
        super.initParameterData(queryParameter);
        if (this._changes.getSelectedIndex() == this._changes.getModel().getSize() - 1) {
            this._saved.setText(queryParameter.get(queryParameter.size() - 1).toString());
            this._saved.setCaretPosition(0);
        }
    }

    private void appendSavedFileValidator(DefaultFormBuilder defaultFormBuilder, JComponent jComponent, String string) {
        defaultFormBuilder.append(string);
        this._changes = (JComboBox)jComponent;
        defaultFormBuilder.append((Component)this._changes);
        this._filePath = new JLabel(_bundle.getString("file_path"));
        defaultFormBuilder.append((Component)this._filePath);
        this._panel = new JPanel(new FlowLayout());
        this._saved = new JTextField();
        this._saved.setPreferredSize(DialogConstants.LONG_SIZE);
        this._panel.add(this._saved);
        this._savedFileValidator = new JButton(_bundle.getString("checkpath"));
        this._savedFileValidator.setPreferredSize(DialogConstants.OPERATE_SIZE);
        this._savedFileValidator.addActionListener(this._action);
        this._panel.add(this._savedFileValidator);
        defaultFormBuilder.append((Component)this._panel);
        this.setVisibleChanges(false);
        this._changes.addItemListener(new ChangesItem());
    }

    @Override
    protected boolean checkParameter() {
        boolean bl2 = super.checkParameter();
        if (!bl2) {
            this._tmpParameters.clear();
            return false;
        }
        if (this._changes.getSelectedIndex() == this._changes.getModel().getSize() - 1 && this._saved.getText().length() == 0) {
            JOptionPane.showMessageDialog(this, _bundle.getString("message_importsavedfile"));
            return false;
        }
        this._tmpParameters.add(this._saved.getText());
        return true;
    }

    private void setVisibleChanges(boolean bl2) {
        this._filePath.setVisible(bl2);
        this._panel.setVisible(bl2);
        this.setSize(this.getPreferredSize());
    }

    private void doSavedValidator() {
        File file = new File(MessageParser.parseMessage(this._saved.getText(), CommandVarProcessor.getVars()));
        if (file.exists()) {
            JOptionPane.showMessageDialog(this, _bundle.getString("message_comparedfileexist"));
        } else {
            JOptionPane.showMessageDialog(this, _bundle.getString("message_comparedfilenotexist"), "", 2);
        }
    }

    private class ValidatorAction
    implements ActionListener {
        private ValidatorAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object.equals(FtpDialog.this._savedFileValidator)) {
                FtpDialog.this.doSavedValidator();
            }
        }
    }

    private class ChangesItem
    implements ItemListener {
        private ChangesItem() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            ItemSelectable itemSelectable = itemEvent.getItemSelectable();
            if (itemEvent.getStateChange() == 1 && itemSelectable.equals(FtpDialog.this._changes)) {
                if (FtpDialog.this._changes.getSelectedIndex() == FtpDialog.this._changes.getModel().getSize() - 1) {
                    FtpDialog.this.setVisibleChanges(true);
                } else {
                    FtpDialog.this.setVisibleChanges(false);
                }
            }
        }
    }
}

