/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ireasoning.util.MibBrowserUtil;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.common.msp.Probe;
import com.sysuptime.common.performance.Monitor;
import com.sysuptime.common.performance.QueryParameter;
import com.sysuptime.common.performance.QueryParameter$QueryParameterDeserializer;
import com.sysuptime.common.performance.QueryParameter$QueryParameterSerializer;
import com.sysuptime.common.performance.ServiceNameElement;
import com.sysuptime.common.util.AppUtil;
import com.sysuptime.common.util.CommonUtil;
import com.sysuptime.common.util.FileUtil;
import com.sysuptime.mainframe.MainClient;
import com.sysuptime.mainframe.Startup;
import com.sysuptime.mainframe.msp.ClientProxy;
import com.sysuptime.mainframe.msp.ProxyMBeanInvoker;
import com.sysuptime.mainframe.performance.CalendarDialog;
import com.sysuptime.mainframe.performance.CloneMonitorDialog;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.DialogProvider;
import com.sysuptime.mainframe.performance.MasterMonitorTableModel;
import com.sysuptime.mainframe.performance.MonitorBroker;
import com.sysuptime.mainframe.performance.MonitorImporterDialog;
import com.sysuptime.mainframe.performance.MonitorTableModel;
import com.sysuptime.mainframe.performance.MonitorsSnapshotViewer;
import com.sysuptime.mainframe.performance.OperationDialog;
import com.sysuptime.mainframe.performance.PerformanceUIUtil;
import com.sysuptime.mainframe.performance.ResumeTimeDialog;
import com.sysuptime.mainframe.performance.SelectionValidator;
import com.sysuptime.mainframe.performance.SingletonValidator;
import com.sysuptime.mainframe.performance.TestRunDialog;
import com.sysuptime.mainframe.util.SwingUtil;
import com.sysuptime.mainframe.util.TableSorter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.openide.util.NbBundle;

public class ManageMonitorDialog
extends OperationDialog {
    private static final String TITLE = _bundle.getString("title_managemonitordialog");
    private static final String TITLE_SUSPEND = _bundle.getString("title_resumemonitor");
    public static final String TITLE_REMOVE_MONITOR = _bundle.getString("title_removemonitor");
    private static final String MESSAGE_RESUME_MONITOR = _bundle.getString("message_resumemonitor");
    private static final String BUTTON_CLONE = _bundle.getString("button_clone");
    private static final String BUTTON_CHART = "Graph";
    private JTable _scheduleListTable;
    private MonitorTableModel _monitorTableModel;
    private TableSorter _sorter;
    private JButton _testRun;
    private JButton _chart;
    private JButton _import;
    private JButton _export;
    private JButton _clone;

    public ManageMonitorDialog(Frame frame, boolean bl2) {
        super(frame, TITLE, bl2);
        this.initComponents();
        this.initUserData();
    }

    private void initComponents() {
        this.setResizable(false);
        Container container = this.getContentPane();
        container.add((Component)this.getBodyPanel(), "Center");
        container.add((Component)this.getClosePanel(), "South");
        this.disableButton();
        this.pack();
    }

    private MonitorTableModel createMonitorTableModel() {
        Map map = MonitorBroker.getGroupIdToName();
        if (Startup.isMspEdition() && Startup.isMaster()) {
            try {
                List list = ProxyMBeanInvoker.INSTANCE.getAllProbes();
                return new MasterMonitorTableModel(map, list);
            }
            catch (Exception exception) {
                this._logger.error((Object)"get all probes", (Throwable)exception);
                return null;
            }
        }
        return new MonitorTableModel(map);
    }

    private JPanel getBodyPanel() {
        FormLayout formLayout = new FormLayout("FILL:PREF:GROW(0.4),FILL:15PX:NONE,FILL:170PX:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE", "TOP:DEFAULT:NONE,CENTER:10PX:NONE,CENTER:DEFAULT:NONE,CENTER:10PX:NONE,CENTER:DEFAULT:NONE,CENTER:12PX:NONE,CENTER:DEFAULT:NONE,CENTER:12PX:NONE,CENTER:DEFAULT:NONE,CENTER:12PX:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:100PX:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:55PX:NONE,CENTER:DEFAULT:NONE");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        this._monitorTableModel = this.createMonitorTableModel();
        this._sorter = new TableSorter(this._monitorTableModel);
        this._scheduleListTable = SwingUtil.createJTable(this._sorter);
        this._sorter.setSortingStatus(this._monitorTableModel.getNameColumnIndex(), 1);
        PerformanceUIUtil.setGraceHeader(this._scheduleListTable);
        this._sorter.setTableHeader(this._scheduleListTable.getTableHeader());
        this._scheduleListTable.setSelectionMode(2);
        this._scheduleListTable.setPreferredScrollableViewportSize(new Dimension(620, 390));
        ModelListener modelListener = new ModelListener();
        this._scheduleListTable.addMouseListener(modelListener);
        TableColumnModel tableColumnModel = this._scheduleListTable.getColumnModel();
        tableColumnModel.getColumn(this._monitorTableModel.getNameColumnIndex()).setPreferredWidth(100);
        JScrollPane jScrollPane = new JScrollPane(this._scheduleListTable);
        jScrollPane.setBorder(BorderFactory.createEtchedBorder());
        panelBuilder.add((Component)jScrollPane, cellConstraints.xywh(1, 1, 1, 17));
        panelBuilder.add((Component)this.getOperationPanel(false, true), cellConstraints.xy(3, 3));
        this.getAddButton().setPreferredSize(DialogConstants.LONG_SIZE);
        this.getRemoveButton().setPreferredSize(DialogConstants.LONG_SIZE);
        this.getModifyButton().setPreferredSize(DialogConstants.LONG_SIZE);
        ControlAction controlAction = new ControlAction();
        this._testRun = new JButton(DialogConstants.BUTTON_TEST_RUN);
        this._testRun.setPreferredSize(DialogConstants.OPERATE_SIZE);
        this._testRun.addActionListener(controlAction);
        panelBuilder.add((Component)this._testRun, cellConstraints.xy(3, 7));
        this._clone = new JButton(BUTTON_CLONE);
        this._clone.setPreferredSize(DialogConstants.OPERATE_SIZE);
        this._clone.addActionListener(controlAction);
        panelBuilder.add((Component)this._clone, cellConstraints.xy(3, 5));
        this._chart = new JButton(BUTTON_CHART, SwingUtil.getImage("actions/monitorgraph.gif"));
        this._chart.setPreferredSize(DialogConstants.OPERATE_SIZE);
        this._chart.addActionListener(controlAction);
        panelBuilder.add((Component)this._chart, cellConstraints.xy(3, 1));
        this._import = new JButton("Templates");
        this._import.setPreferredSize(DialogConstants.OPERATE_SIZE);
        this._import.addActionListener(controlAction);
        panelBuilder.add((Component)this._import, cellConstraints.xy(3, 9));
        this._export = new JButton("Save as Template");
        this._export.setPreferredSize(DialogConstants.OPERATE_SIZE);
        this._export.addActionListener(controlAction);
        panelBuilder.add((Component)this._export, cellConstraints.xy(3, 11));
        this.addFillComponents(jScrollPane, new int[]{2, 3, 4, 5}, new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18});
        return panelBuilder.getPanel();
    }

    private void disableButton() {
        if (Startup.isMspEdition() && !Startup.isMaster()) {
            this.getAddButton().setEnabled(false);
            this.getModifyButton().setEnabled(false);
            this.getRemoveButton().setEnabled(false);
            this._testRun.setEnabled(false);
            this._import.setEnabled(false);
            this._export.setEnabled(false);
            this._clone.setEnabled(false);
        }
    }

    private void addFillComponents(Container container, int[] nArray, int[] nArray2) {
        int n2;
        Dimension dimension = new Dimension(10, 10);
        boolean bl2 = false;
        CellConstraints cellConstraints = new CellConstraints();
        if (nArray.length > 0 && nArray2.length > 0 && nArray[0] == 1 && nArray2[0] == 1) {
            container.add(Box.createRigidArea(dimension), cellConstraints.xy(1, 1));
            bl2 = true;
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2] == 1 && bl2) continue;
            container.add(Box.createRigidArea(dimension), cellConstraints.xy(nArray[n2], 1));
        }
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            if (nArray2[n2] == 1 && bl2) continue;
            container.add(Box.createRigidArea(dimension), cellConstraints.xy(1, nArray2[n2]));
        }
    }

    private void showMessage(String string) {
        JOptionPane.showMessageDialog(this, string);
    }

    private void showMessageSelectRow() {
        this.showMessage(NbBundle.getBundle(ManageMonitorDialog.class).getString("message_select_row"));
    }

    private void testRun() {
        int n2 = this._scheduleListTable.getSelectedRow();
        Object object = SingletonValidator.checkAllDialog(this, DialogConstants.MESSAGE_ONE_ROW, n2, SelectionValidator.CLASS);
        if (object != null && n2 != -1 && n2 < this._sorter.getRowCount()) {
            int n3 = this._sorter.modelIndex(n2);
            if (!this.checkActive()) {
                return;
            }
            SwingUtilities.invokeLater(() -> {
                int n3 = this._monitorTableModel.getMonitor(n3).getScheduleId();
                TestRunDialog testRunDialog = DialogProvider.createTestRunDialog();
                testRunDialog.splashProgress((JDialog)this, n3);
                if (testRunDialog.isError()) {
                    this.removeAction(n3, true, testRunDialog, true);
                } else {
                    testRunDialog.showTestRunResultDialog(this);
                }
            });
        }
    }

    private void cloneMonitor() {
        int n2 = this._scheduleListTable.getSelectedRow();
        Object object = SingletonValidator.checkAllDialog(this, DialogConstants.MESSAGE_ONE_ROW, n2, SelectionValidator.CLASS);
        if (object != null && n2 != -1 && n2 < this._sorter.getRowCount()) {
            int n3 = this._sorter.modelIndex(n2);
            Monitor monitor = this._monitorTableModel.getMonitor(n3);
            CloneMonitorDialog cloneMonitorDialog = new CloneMonitorDialog((Dialog)this, "Applying selected monitor's settings to other similar devices", true, monitor);
            cloneMonitorDialog.setSize(750, 300);
            SwingUtil.centerOnScreen(cloneMonitorDialog);
            cloneMonitorDialog.setVisible(true);
            this._monitorTableModel.clear();
            this.initUserData();
        }
    }

    private void graph() {
        int n2 = this._scheduleListTable.getSelectedRow();
        Object object = SingletonValidator.checkAllDialog(this, DialogConstants.MESSAGE_ONE_ROW, n2, SelectionValidator.CLASS);
        if (object != null && n2 != -1 && n2 < this._sorter.getRowCount()) {
            int n3 = this._sorter.modelIndex(n2);
            Monitor monitor = this._monitorTableModel.getMonitor(n3);
            PerformanceUIUtil.createGraphChooser(this, monitor);
        }
    }

    private void export() {
        int n2 = this._scheduleListTable.getSelectedRow();
        if (n2 < 0) {
            JOptionPane.showMessageDialog(this, NbBundle.getMessage(ManageMonitorDialog.class, (String)"message_select_rows"));
            return;
        }
        if (!this.checkActive()) {
            return;
        }
        Object object = SingletonValidator.checkAllDialog(this, DialogConstants.MESSAGE_ONE_ROW, n2, SelectionValidator.CLASS);
        if (object != null) {
            int n3 = this._sorter.modelIndex(n2);
            Monitor monitor = this._monitorTableModel.getMonitor(n3);
            Monitor monitor2 = MonitorBroker.getScheduleData(monitor.getScheduleId());
            monitor2.setScheduleId(-1);
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.registerTypeAdapter(QueryParameter.class, (Object)new QueryParameter$QueryParameterSerializer());
            Gson gson = gsonBuilder.setPrettyPrinting().create();
            String string = gson.toJson((Object)monitor2);
            String string2 = AppUtil.getClientSpecificDirectory("templates");
            String string3 = string2 + monitor2.getScheduleName() + ".template";
            try {
                FileUtil.writeFile(string3, string);
                JOptionPane.showMessageDialog(this, "Successfully created template file: " + string3, MibBrowserUtil.getString("Info"), 1);
                MainClient.getInstance().setStatus("Successfully created template file: " + string3);
            }
            catch (IOException iOException) {
                this._logger.error((Object)iOException);
            }
        }
    }

    public static void main(String[] stringArray) {
        String string = "test.template";
        String string2 = FileUtil.readFile(string);
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(QueryParameter.class, (Object)new QueryParameter$QueryParameterDeserializer());
        Monitor monitor = (Monitor)gsonBuilder.create().fromJson(string2, Monitor.class);
    }

    private void doImport() {
        MonitorImporterDialog monitorImporterDialog = new MonitorImporterDialog(this, true);
        SwingUtil.centerOnFrame(Startup.getFrame(), monitorImporterDialog);
        monitorImporterDialog.setVisible(true);
        if (monitorImporterDialog.isOk()) {
            String string = monitorImporterDialog.getFileName();
            Monitor monitor = MonitorImporterDialog.getMonitorFromFile(string);
            if (monitor == null) {
                JOptionPane.showMessageDialog(this, "File format is wrong: " + string, "Error", 1);
                return;
            }
            monitor.setScheduleId(-1);
            ServiceNameElement serviceNameElement = monitor.getTargetType();
            DialogProvider.createScheduleDialog(this, DialogConstants.BUTTON_MODIFY + serviceNameElement.getLocale(), serviceNameElement, null, 0, monitor);
            List list = MonitorBroker.getScheduleDataList();
            this._monitorTableModel.clear();
            this._monitorTableModel.addMonitors(list);
            this._monitorTableModel.fireTableDataChanged();
        }
    }

    private void initUserData() {
        List list = MonitorBroker.getScheduleDataList();
        this._monitorTableModel.addMonitors(list);
    }

    @Override
    protected void addItem() {
        if (!ClientProxy.getInstance().resetProbe()) {
            return;
        }
        DialogProvider.createAddMonitorDialog(this, this._monitorTableModel);
    }

    @Override
    protected void removeItem() {
        if (!this.checkActive()) {
            return;
        }
        if (this._scheduleListTable.getSelectedRowCount() > 1) {
            this.removeMoreItem(this._scheduleListTable.getSelectedRows(), false);
        } else {
            this.doRemove(this._scheduleListTable.getSelectedRow(), true);
        }
        SwingUtilities.invokeLater(() -> MonitorsSnapshotViewer.getInstance().refresh());
    }

    private void removeMoreItem(int[] nArray, boolean bl2) {
        int n2 = 0;
        if (!bl2) {
            n2 = JOptionPane.showOptionDialog(this, DialogConstants.MESSAGE_REMOVE_MORE_SCHEDULE, TITLE_REMOVE_MONITOR, 0, 2, null, DialogConstants.YES_NO_OPTION, DialogConstants.YES_NO_OPTION[1]);
        }
        if (n2 == 0) {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                this.doRemove(nArray[i2] - i2, false);
            }
        }
    }

    private void doRemove(int n2, boolean bl2) {
        int n3 = n2;
        Object object = SingletonValidator.checkAllDialog(this, DialogConstants.MESSAGE_ONE_ROW, n3, SelectionValidator.CLASS);
        if (object != null && n3 != -1 && n3 < this._sorter.getRowCount()) {
            int n4 = this._sorter.modelIndex(n3);
            this.removeAction(n4, false, null, bl2);
        }
    }

    private void removeAction(int n2, boolean bl2, TestRunDialog testRunDialog, boolean bl3) {
        try {
            Monitor monitor = this._monitorTableModel.getMonitor(n2);
            List list = MonitorBroker.getInverseDependencies(monitor.getScheduleId());
            if (list.size() == 0) {
                int n3 = -1;
                n3 = bl2 ? JOptionPane.showOptionDialog(this, testRunDialog.getExistedScheduleErrorMessage(false), DialogConstants.TITLE_TESTRUN, 0, 2, null, DialogConstants.YES_NO_OPTION, DialogConstants.YES_NO_OPTION[1]) : (bl3 ? JOptionPane.showOptionDialog(this, DialogConstants.MESSAGE_REMOVE_SCHEDULE, TITLE_REMOVE_MONITOR, 0, 2, null, DialogConstants.YES_NO_OPTION, DialogConstants.YES_NO_OPTION[1]) : 0);
                if (n3 != 0) {
                    return;
                }
                if (ClientProxy.getInstance().removeMonitor(monitor.getScheduleId())) {
                    this._monitorTableModel.removeMonitor(monitor);
                }
                return;
            }
            int n4 = -1;
            n4 = bl2 ? JOptionPane.showOptionDialog(this, testRunDialog.getExistedScheduleErrorMessage(true), DialogConstants.TITLE_TESTRUN, 1, 2, null, DialogConstants.DEPENDENCIES_MONITORS_QUIT_OPTION, DialogConstants.DEPENDENCIES_MONITORS_QUIT_OPTION[2]) : JOptionPane.showOptionDialog(this, DialogConstants.MESSAGE_REMOVE_SCHEDULE_DEP, TITLE_REMOVE_MONITOR, 1, 2, null, DialogConstants.DEPENDENCIES_MONITORS_QUIT_OPTION, DialogConstants.DEPENDENCIES_MONITORS_QUIT_OPTION[2]);
            if (n4 != 2 && n4 != -1) {
                if (ClientProxy.getInstance().removeMonitor(monitor.getScheduleId())) {
                    this._monitorTableModel.removeMonitor(monitor);
                }
                if (n4 == 1) {
                    ClientProxy.getInstance().removeMonitors(list);
                    this.removeMonitors(list);
                } else {
                    ClientProxy.getInstance().resetDependency(monitor.getScheduleId());
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    protected void modifyItem() {
        int n2 = this._scheduleListTable.getSelectedRow();
        Object object = SingletonValidator.checkAllDialog(this, DialogConstants.MESSAGE_ONE_ROW, n2, SelectionValidator.CLASS);
        if (object != null) {
            if (this._scheduleListTable.getSelectedRowCount() > 1) {
                JOptionPane.showMessageDialog(this, NbBundle.getBundle(ManageMonitorDialog.class).getString("message_select_row"));
                return;
            }
            if (n2 != -1 && n2 < this._sorter.getRowCount()) {
                int n3 = this._sorter.modelIndex(n2);
                Monitor monitor = this._monitorTableModel.getMonitor(n3);
                if (!this.checkActive()) {
                    return;
                }
                int n4 = monitor.getScheduleId();
                Monitor monitor2 = MonitorBroker.getScheduleData(n4);
                ServiceNameElement serviceNameElement = monitor2.getTargetType();
                DialogProvider.createScheduleDialog(this, DialogConstants.BUTTON_MODIFY + serviceNameElement.getLocale(), serviceNameElement, this._monitorTableModel, n3, monitor2);
            }
        }
    }

    public void removeMonitors(List list) {
        DefaultCellEditor defaultCellEditor = (DefaultCellEditor)this._scheduleListTable.getCellEditor();
        if (defaultCellEditor != null) {
            defaultCellEditor.stopCellEditing();
        }
        int n2 = this._monitorTableModel.getRowCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Monitor monitor = this._monitorTableModel.getMonitor(i2);
            if (!this.isSelectedId(list, monitor.getScheduleId())) continue;
            this._monitorTableModel.removeMonitor(monitor);
            --n2;
            --i2;
        }
    }

    public void modifyGroups(long l2, long l3) {
        int n2 = this._monitorTableModel.getRowCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Monitor monitor = this._monitorTableModel.getMonitor(i2);
            if (l2 != (long)monitor.getScheduleId()) continue;
            monitor.setGroupId(l3);
        }
        this._monitorTableModel.fireTableDataChanged();
    }

    private boolean isSelectedId(List list, int n2) {
        int n3 = list.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = ((Number)list.get(i2)).intValue();
            if (n4 != n2) continue;
            return true;
        }
        return false;
    }

    private JButton getEditedButton() {
        return this.getModifyButton();
    }

    private boolean checkActive() {
        int[] nArray = this._scheduleListTable.getSelectedRows();
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this._sorter.modelIndex(nArray[i2]);
            Monitor monitor = this._monitorTableModel.getMonitor(n3);
            long l2 = Probe.getProbeID(monitor.getScheduleId());
            if (ClientProxy.getInstance().isActive(l2)) continue;
            return false;
        }
        return true;
    }

    private class ModelListener
    extends MouseAdapter {
        private ModelListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (ManageMonitorDialog.this._scheduleListTable.getSelectedRowCount() > 1) {
                ManageMonitorDialog.this._chart.setEnabled(false);
                ManageMonitorDialog.this._testRun.setEnabled(false);
                ManageMonitorDialog.this.getEditedButton().setEnabled(false);
                ManageMonitorDialog.this._clone.setEnabled(false);
            } else {
                ManageMonitorDialog.this._chart.setEnabled(true);
                ManageMonitorDialog.this._clone.setEnabled(true);
                if (Startup.isMaster() || !Startup.isMspEdition()) {
                    ManageMonitorDialog.this._testRun.setEnabled(true);
                    ManageMonitorDialog.this.getEditedButton().setEnabled(true);
                }
            }
        }
    }

    private class ControlAction
    implements ActionListener {
        private ControlAction() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            try {
                if (object.equals(ManageMonitorDialog.this._testRun)) {
                    if (ManageMonitorDialog.this._scheduleListTable.getSelectedRowCount() == 1) {
                        ManageMonitorDialog.this.testRun();
                        return;
                    }
                    ManageMonitorDialog.this.showMessageSelectRow();
                    return;
                }
                if (object.equals(ManageMonitorDialog.this._chart)) {
                    if (ManageMonitorDialog.this._scheduleListTable.getSelectedRowCount() == 1) {
                        ManageMonitorDialog.this.graph();
                        return;
                    }
                    ManageMonitorDialog.this.showMessageSelectRow();
                    return;
                }
                if (object.equals(ManageMonitorDialog.this._clone)) {
                    if (ManageMonitorDialog.this._scheduleListTable.getSelectedRowCount() == 1) {
                        ManageMonitorDialog.this.cloneMonitor();
                        return;
                    }
                    ManageMonitorDialog.this.showMessageSelectRow();
                    return;
                }
                if (object.equals(ManageMonitorDialog.this._export)) {
                    ManageMonitorDialog.this.export();
                    return;
                }
                if (!object.equals(ManageMonitorDialog.this._import)) return;
                ManageMonitorDialog.this.doImport();
                return;
            }
            catch (Exception exception) {
                ManageMonitorDialog.this._logger.error((Object)"error", (Throwable)exception);
                JOptionPane.showMessageDialog(ManageMonitorDialog.this, "Error occurred: " + exception.getMessage());
                ManageMonitorDialog.this.dispose();
            }
        }
    }

    private class SuspendEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private JCheckBox _isSuspended = new JCheckBox("");
        private SuspendEditor _self;

        public SuspendEditor() {
            this._isSuspended.addActionListener(this);
            this._isSuspended.setHorizontalAlignment(0);
            this._self = this;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl2, int n2, int n3) {
            this._isSuspended.setSelected((Boolean)object);
            return this._isSuspended;
        }

        @Override
        public Object getCellEditorValue() {
            return this._isSuspended.isSelected();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        int n2 = ManageMonitorDialog.this._scheduleListTable.getSelectedRow();
                        if (n2 != -1 && n2 < ManageMonitorDialog.this._sorter.getRowCount()) {
                            int n3 = ManageMonitorDialog.this._sorter.modelIndex(n2);
                            Monitor monitor = ManageMonitorDialog.this._monitorTableModel.getMonitor(n3);
                            if (!ManageMonitorDialog.this.checkActive()) {
                                SuspendEditor.this._isSuspended.setSelected(!SuspendEditor.this._isSuspended.isSelected());
                                return;
                            }
                            if (SuspendEditor.this._isSuspended.isSelected()) {
                                if (!monitor.isSuspended()) {
                                    ResumeTimeDialog resumeTimeDialog = DialogProvider.createResumeTimeDialog(ManageMonitorDialog.this);
                                    if (resumeTimeDialog.isPut()) {
                                        monitor.setResumeTime(resumeTimeDialog.getResumeTime());
                                        monitor.setSuspended(true);
                                        ClientProxy.getInstance().setMonitorSuspended(monitor.getScheduleId(), true, resumeTimeDialog.getResumeTime());
                                    } else {
                                        monitor.setSuspended(false);
                                        SuspendEditor.this._isSuspended.setSelected(false);
                                    }
                                }
                            } else if (monitor.isSuspended()) {
                                int n4 = JOptionPane.showOptionDialog(ManageMonitorDialog.this, MESSAGE_RESUME_MONITOR, TITLE_SUSPEND, 0, 2, null, DialogConstants.YES_NO_OPTION, DialogConstants.YES_NO_OPTION[1]);
                                if (n4 == 0) {
                                    monitor.setResumeTime(0L);
                                    monitor.setSuspended(false);
                                    ClientProxy.getInstance().setMonitorSuspended(monitor.getScheduleId(), false, 0L);
                                } else {
                                    monitor.setSuspended(true);
                                    SuspendEditor.this._isSuspended.setSelected(true);
                                }
                            }
                            ManageMonitorDialog.this._monitorTableModel.fireTableDataChanged();
                        }
                        SuspendEditor.this._self.stopCellEditing();
                    }
                    catch (Exception exception) {
                        ManageMonitorDialog.this._logger.error((Object)"", (Throwable)exception);
                    }
                }
            });
        }
    }

    private class ResumeTimeEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private JPanel _cellPanel = new JPanel();
        private JLabel _displayTime = new JLabel();
        private JButton _importTime = new JButton();
        private ResumeTimeEditor _self;

        public ResumeTimeEditor() {
            this._importTime.setText("...");
            this._importTime.setPreferredSize(new Dimension(20, 20));
            this._importTime.addActionListener(this);
            this._cellPanel.setLayout(new BorderLayout());
            this._cellPanel.add(this._displayTime);
            this._cellPanel.add((Component)this._importTime, "East");
            this._self = this;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl2, int n2, int n3) {
            this._displayTime.setText((String)object);
            return this._cellPanel;
        }

        @Override
        public Object getCellEditorValue() {
            return this._displayTime.getText();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        int n2;
                        Monitor monitor;
                        int n3 = ManageMonitorDialog.this._scheduleListTable.getSelectedRow();
                        if (n3 != -1 && n3 < ManageMonitorDialog.this._sorter.getRowCount() && (monitor = ManageMonitorDialog.this._monitorTableModel.getMonitor(n2 = ManageMonitorDialog.this._sorter.modelIndex(n3))).isSuspended()) {
                            if (!ManageMonitorDialog.this.checkActive()) {
                                return;
                            }
                            CalendarDialog calendarDialog = (CalendarDialog)DialogProvider.createCalendarDialog(ManageMonitorDialog.this);
                            if (calendarDialog.isPut()) {
                                Date date = calendarDialog.getDate();
                                ClientProxy.getInstance().setMonitorSuspended(monitor.getScheduleId(), true, date.getTime());
                                SimpleDateFormat simpleDateFormat = CommonUtil.getDateFormat();
                                String string = simpleDateFormat.format(date);
                                ResumeTimeEditor.this._displayTime.setText(string);
                                monitor.setResumeTime(date.getTime());
                                ManageMonitorDialog.this._monitorTableModel.fireTableDataChanged();
                            }
                        }
                        ResumeTimeEditor.this._self.stopCellEditing();
                    }
                    catch (Exception exception) {
                        ManageMonitorDialog.this._logger.error((Object)"", (Throwable)exception);
                    }
                }
            });
        }
    }

    private class ResumeTimeRenderer
    extends JPanel
    implements TableCellRenderer {
        private JLabel _displayTime = new JLabel();
        private JButton _importTime = new JButton();

        public ResumeTimeRenderer() {
            this._importTime.setText("...");
            this._importTime.setPreferredSize(new Dimension(20, 20));
            this.setLayout(new BorderLayout());
            this.add(this._displayTime);
            this.add((Component)this._importTime, "East");
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
            this._displayTime.setText((String)object);
            if (bl2) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
                this._displayTime.setBackground(jTable.getSelectionBackground());
                this._displayTime.setForeground(jTable.getSelectionForeground());
                this._importTime.setBackground(jTable.getSelectionBackground());
                this._importTime.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
                this._displayTime.setBackground(jTable.getBackground());
                this._displayTime.setForeground(jTable.getForeground());
                this._importTime.setBackground(jTable.getBackground());
                this._importTime.setForeground(jTable.getForeground());
            }
            return this;
        }
    }
}

