/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.sysuptime.common.performance.Monitor;
import com.sysuptime.common.performance.PerformanceGraph;
import com.sysuptime.common.performance.ProcessResult;
import com.sysuptime.common.performance.ResultValue;
import com.sysuptime.common.performance.Timebucket;
import com.sysuptime.mainframe.util.JNDIClient;
import com.sysuptime.mainframe.util.RMIAdaptor;
import com.sysuptime.server.util.MBeanUtil;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import org.apache.log4j.Logger;

public class MonitorBroker {
    private static final Logger _logger = Logger.getLogger(MonitorBroker.class);
    private static RMIAdaptor _rmiAdaptor;
    private static final ObjectName MONITOR_OBJECT_NAME;
    private static long _weekDayId;

    public static List getScheduleNameList() {
        List list = null;
        try {
            list = (List)_rmiAdaptor.invoke(MONITOR_OBJECT_NAME, "getScheduleNameList", null, null);
        }
        catch (Exception exception) {
            _logger.error((Object)"Get schedule name list ", (Throwable)exception);
        }
        return list;
    }

    public static List getScheduleNameList(long l2) {
        try {
            Object[] objectArray = new Object[]{l2};
            String[] stringArray = new String[]{Long.TYPE.getName()};
            return (List)_rmiAdaptor.invoke(MONITOR_OBJECT_NAME, "getScheduleNameList", objectArray, stringArray);
        }
        catch (Exception exception) {
            _logger.error((Object)"get schedule name list", (Throwable)exception);
            return null;
        }
    }

    public static List getScheduleDataList() {
        List list = null;
        try {
            list = (List)_rmiAdaptor.invoke(MONITOR_OBJECT_NAME, "getScheduleDataList", null, null);
        }
        catch (Exception exception) {
            _logger.error((Object)"Get schedule data list ", (Throwable)exception);
        }
        return list;
    }

    public static Monitor getScheduleData(int n2) {
        Monitor monitor = null;
        try {
            monitor = (Monitor)_rmiAdaptor.invoke(MONITOR_OBJECT_NAME, "getScheduleData", new Object[]{n2}, new String[]{"int"});
        }
        catch (Exception exception) {
            _logger.error((Object)"Get schedule data ", (Throwable)exception);
        }
        return monitor;
    }

    public static int getScheduleId(String string) {
        int n2 = -1;
        try {
            Integer n3 = (Integer)_rmiAdaptor.invoke(MONITOR_OBJECT_NAME, "getScheduleId", new Object[]{string}, new String[]{"java.lang.String"});
            n2 = n3;
        }
        catch (Exception exception) {
            _logger.error((Object)"Get schedule id ", (Throwable)exception);
        }
        return n2;
    }

    public static boolean isExceedLicense(int n2) {
        boolean bl2 = false;
        try {
            Boolean bl3 = (Boolean)_rmiAdaptor.invoke(MONITOR_OBJECT_NAME, "isExceedLicense", new Object[]{n2}, new String[]{"int"});
            bl2 = bl3;
        }
        catch (Exception exception) {
            _logger.error((Object)"Get schedule id ", (Throwable)exception);
        }
        return bl2;
    }

    public static Map getScheduleNameToId() {
        Map map = null;
        try {
            map = (Map)_rmiAdaptor.invoke(MONITOR_OBJECT_NAME, "getScheduleNameToId", null, null);
        }
        catch (Exception exception) {
            _logger.error((Object)"Get schedule name to id ", (Throwable)exception);
        }
        return map;
    }

    public static Map getScheduleNameToIdFromProbe(int n2) {
        Map map = null;
        try {
            Object[] objectArray = new Object[]{n2};
            String[] stringArray = new String[]{Integer.TYPE.getName()};
            map = (Map)_rmiAdaptor.invoke(MONITOR_OBJECT_NAME, "getScheduleNameToIdFromProbe", objectArray, stringArray);
        }
        catch (Exception exception) {
            _logger.error((Object)"Get schedule name to id ", (Throwable)exception);
        }
        return map;
    }

    public static Map getGroupNameToId() {
        Map map = null;
        try {
            map = (Map)_rmiAdaptor.invoke(MONITOR_OBJECT_NAME, "getGroupNameToId", null, null);
        }
        catch (Exception exception) {
            _logger.error((Object)"Get group name and id ", (Throwable)exception);
        }
        return map;
    }

    public static Map getGroupIdToName() {
        Map map = null;
        try {
            map = (Map)_rmiAdaptor.invoke(MONITOR_OBJECT_NAME, "getGroupIdToName", null, null);
        }
        catch (Exception exception) {
            _logger.error((Object)"Get group id and name ", (Throwable)exception);
        }
        return map;
    }

    public static Map[] getGroupFilterInfo() {
        Map[] mapArray = null;
        try {
            mapArray = (Map[])_rmiAdaptor.invoke(MONITOR_OBJECT_NAME, "getGroupFilterInfo", null, null);
        }
        catch (Exception exception) {
            _logger.error((Object)"Get group id and name ", (Throwable)exception);
        }
        return mapArray;
    }

    public static List getMonitorIds(long l2) {
        List list = null;
        try {
            list = (List)_rmiAdaptor.invoke(MONITOR_OBJECT_NAME, "getMonitorIds", new Object[]{l2}, new String[]{"long"});
        }
        catch (Exception exception) {
            _logger.error((Object)"Get monitor id list ", (Throwable)exception);
        }
        return list;
    }

    public static Hashtable getTimebucketNameToObject() {
        List list = MonitorBroker.getNoUseStateTimebuckets();
        Hashtable<String, Timebucket> hashtable = new Hashtable<String, Timebucket>(list.size());
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Timebucket timebucket = (Timebucket)list.get(i2);
            hashtable.put(timebucket.getTimebucketName(), timebucket);
        }
        return hashtable;
    }

    public static Hashtable getTimebucketNameToId() {
        List list = MonitorBroker.getNoUseStateTimebuckets();
        Hashtable<String, Long> hashtable = new Hashtable<String, Long>(list.size());
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Timebucket timebucket = (Timebucket)list.get(i2);
            hashtable.put(timebucket.getTimebucketName(), timebucket.getTimebucketId());
        }
        return hashtable;
    }

    public static Hashtable getTimebucketIdToObject() {
        List list = MonitorBroker.getNoUseStateTimebuckets();
        Hashtable<Long, Timebucket> hashtable = new Hashtable<Long, Timebucket>(list.size());
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Timebucket timebucket = (Timebucket)list.get(i2);
            hashtable.put(new Long(timebucket.getTimebucketId()), timebucket);
        }
        return hashtable;
    }

    public static long getWeekDayId() {
        return _weekDayId;
    }

    public static List getNoUseStateTimebuckets() {
        List list = null;
        try {
            list = (List)_rmiAdaptor.invoke(MONITOR_OBJECT_NAME, "getNoUseStateTimebuckets", null, null);
        }
        catch (Exception exception) {
            _logger.error((Object)exception);
        }
        return list;
    }

    public static List getAllFlagedRemoteHosts() {
        List list = null;
        try {
            list = (List)_rmiAdaptor.invoke(MONITOR_OBJECT_NAME, "getAllFlagedRemoteHosts", null, null);
        }
        catch (Exception exception) {
            _logger.error((Object)"Get remote hosts ", (Throwable)exception);
        }
        return list;
    }

    public static List getAllRemoteHostNames() {
        List list = null;
        try {
            list = (List)_rmiAdaptor.invoke(MONITOR_OBJECT_NAME, "getAllRemoteHostNames", null, null);
        }
        catch (Exception exception) {
            _logger.error((Object)"Get remote host names ", (Throwable)exception);
        }
        return list;
    }

    public static List getRemoteHosts(int n2) {
        List list = null;
        try {
            list = (List)_rmiAdaptor.invoke(MONITOR_OBJECT_NAME, "getRemoteHosts", new Object[]{n2}, new String[]{"int"});
        }
        catch (Exception exception) {
            _logger.error((Object)"Get remote hosts ", (Throwable)exception);
        }
        return list;
    }

    public static List getRemoteHosts() {
        List list = null;
        try {
            list = (List)_rmiAdaptor.invoke(MONITOR_OBJECT_NAME, "getRemoteHosts", null, null);
        }
        catch (Exception exception) {
            _logger.error((Object)"Get remote hosts ", (Throwable)exception);
        }
        return list;
    }

    public static List getInverseDependencies(int n2) {
        List list = null;
        try {
            list = (List)_rmiAdaptor.invoke(MONITOR_OBJECT_NAME, "getInverseDependencies", new Object[]{n2}, new String[]{"int"});
        }
        catch (Exception exception) {
            _logger.error((Object)"Get inverse dependencies ", (Throwable)exception);
        }
        return list;
    }

    public static List getDisableDependencies(int n2) {
        List list = null;
        try {
            list = (List)_rmiAdaptor.invoke(MONITOR_OBJECT_NAME, "getDisableDependencies", new Object[]{n2}, new String[]{"int"});
        }
        catch (Exception exception) {
            _logger.error((Object)"Get disable dependencies ", (Throwable)exception);
        }
        return list;
    }

    public static List getAllDependencies() {
        List list = null;
        try {
            list = (List)_rmiAdaptor.invoke(MONITOR_OBJECT_NAME, "getAllDependencies", null, null);
        }
        catch (Exception exception) {
            _logger.error((Object)"Get all dependencies ", (Throwable)exception);
        }
        return list;
    }

    public static void updateConfigProperties(Map map) {
        try {
            _rmiAdaptor.invoke(MONITOR_OBJECT_NAME, "updateConfigProperties", new Object[]{map}, new String[]{Map.class.getName()});
        }
        catch (Exception exception) {
            _logger.error((Object)"Update performance config properties ", (Throwable)exception);
        }
    }

    public static Map getConfigProperties() {
        Map map = null;
        try {
            map = (Map)_rmiAdaptor.invoke(MONITOR_OBJECT_NAME, "getConfigProperties", null, null);
        }
        catch (Exception exception) {
            _logger.error((Object)"Get performance config properties ", (Throwable)exception);
        }
        return map;
    }

    public static PerformanceGraph getPerformanceGraph(int n2) {
        PerformanceGraph performanceGraph = null;
        try {
            performanceGraph = (PerformanceGraph)_rmiAdaptor.invoke(MONITOR_OBJECT_NAME, "getPerformanceGraph", new Object[]{n2}, new String[]{"int"});
        }
        catch (Exception exception) {
            _logger.error((Object)"Get min, max records: ", (Throwable)exception);
        }
        return performanceGraph;
    }

    public static List getQueryResult(int n2, long l2, int n3, long l3, long l4, int n4) {
        List list = null;
        try {
            list = (List)_rmiAdaptor.invoke(MONITOR_OBJECT_NAME, "getQueryResult", new Object[]{n2, l2, n3, l3, l4, n4}, new String[]{"int", "long", "int", "long", "long", "int"});
        }
        catch (Exception exception) {
            _logger.error((Object)"Get query result list ", (Throwable)exception);
        }
        return list;
    }

    public static List getRecentQueryResults(int[] nArray, int n2, int n3, String string, int n4, boolean bl2) {
        List list = null;
        try {
            list = (List)_rmiAdaptor.invoke(MONITOR_OBJECT_NAME, "getRecentQueryResults", new Object[]{nArray, n2, n3, string, n4, bl2}, new String[]{int[].class.getName(), "int", "int", String.class.getName(), "int", "boolean"});
        }
        catch (Exception exception) {
            _logger.error((Object)"Get recent query results ", (Throwable)exception);
        }
        return list;
    }

    public static List getHostDebugDataList(Monitor monitor) {
        List list = null;
        try {
            list = (List)_rmiAdaptor.invoke(MONITOR_OBJECT_NAME, "getTestRunResults", new Object[]{monitor}, new String[]{Monitor.class.getName()});
        }
        catch (Exception exception) {
            _logger.error((Object)exception);
        }
        return list;
    }

    public static List getHostDebugDataList(int n2) {
        List list = null;
        try {
            list = (List)_rmiAdaptor.invoke(MONITOR_OBJECT_NAME, "getTestRunResults", new Object[]{n2}, new String[]{"int"});
        }
        catch (Exception exception) {
            _logger.error((Object)"Get host debug data list ", (Throwable)exception);
        }
        return list;
    }

    public static byte[] getMonitorXML() {
        byte[] byArray = null;
        try {
            byArray = (byte[])_rmiAdaptor.invoke(MONITOR_OBJECT_NAME, "getMonitorXML", new Object[]{"client-monitor.xml"}, new String[]{"java.lang.String"});
        }
        catch (Exception exception) {
            _logger.error((Object)"Load monitor xml......  ", (Throwable)exception);
        }
        return byArray;
    }

    public static Map getConstantNameToId() {
        Map map = null;
        try {
            map = (Map)_rmiAdaptor.invoke(MONITOR_OBJECT_NAME, "getConstantNameToId", null, null);
        }
        catch (Exception exception) {
            _logger.error((Object)"Load name id......  ", (Throwable)exception);
        }
        return map;
    }

    public static Map getConstantIdToName() {
        Map map = null;
        try {
            map = (Map)_rmiAdaptor.invoke(MONITOR_OBJECT_NAME, "getConstantIdToName", null, null);
        }
        catch (Exception exception) {
            _logger.error((Object)"Load id name......  ", (Throwable)exception);
        }
        return map;
    }

    public static Map getID2TimebucketMap() {
        Map map = null;
        try {
            map = (Map)_rmiAdaptor.invoke(MONITOR_OBJECT_NAME, "getID2TimebucketMap", null, null);
        }
        catch (Exception exception) {
            _logger.error((Object)"getID2TimebucketMap", (Throwable)exception);
        }
        return map;
    }

    public static ProcessResult getWmiExecCommandResult(Object[] objectArray, String[] stringArray) {
        ProcessResult processResult = null;
        try {
            processResult = (ProcessResult)_rmiAdaptor.invoke(MONITOR_OBJECT_NAME, "getWmiCommandExecResult", objectArray, stringArray);
        }
        catch (Exception exception) {
            _logger.error((Object)"getWmiExceCommandResult", (Throwable)exception);
        }
        return processResult;
    }

    public static ResultValue getSshExecCommandResult(Object[] objectArray, String[] stringArray) {
        ResultValue resultValue = null;
        try {
            resultValue = (ResultValue)_rmiAdaptor.invoke(MONITOR_OBJECT_NAME, "getSshCommandExecResult", objectArray, stringArray);
        }
        catch (Exception exception) {
            _logger.error((Object)"getSshExceCommandResult", (Throwable)exception);
        }
        return resultValue;
    }

    public static String getServerConfigPath() {
        String string = null;
        try {
            string = (String)_rmiAdaptor.invoke(MONITOR_OBJECT_NAME, "getServerConfigPath", null, null);
        }
        catch (Exception exception) {
            _logger.error((Object)"getServerConfigPath", (Throwable)exception);
        }
        return string;
    }

    public static ProcessResult getProperties(Object[] objectArray, String[] stringArray) {
        ProcessResult processResult = null;
        try {
            processResult = (ProcessResult)_rmiAdaptor.invoke(MONITOR_OBJECT_NAME, "getProperties", objectArray, stringArray);
        }
        catch (Exception exception) {
            _logger.error((Object)"getProperties", (Throwable)exception);
        }
        return processResult;
    }

    public static boolean importMonitors(String string, long l2) {
        try {
            return (Boolean)_rmiAdaptor.invoke(MONITOR_OBJECT_NAME, "importMonitors", new Object[]{string, l2}, new String[]{String.class.getName(), Long.TYPE.getName()});
        }
        catch (Exception exception) {
            _logger.error((Object)"import monitors", (Throwable)exception);
            return false;
        }
    }

    public static List<Monitor> getAddMonitors() {
        try {
            return (List)_rmiAdaptor.invoke(MONITOR_OBJECT_NAME, "getAddMonitors", null, null);
        }
        catch (Exception exception) {
            _logger.error((Object)"get add monitors", (Throwable)exception);
            return null;
        }
    }

    public static String getImportErrorMessage() {
        try {
            return _rmiAdaptor.invoke(MONITOR_OBJECT_NAME, "getImportErrorMessage", null, null).toString();
        }
        catch (Exception exception) {
            _logger.error((Object)"get import error message", (Throwable)exception);
            return null;
        }
    }

    public static String getImportWarnMessage() {
        try {
            return _rmiAdaptor.invoke(MONITOR_OBJECT_NAME, "getImportWarnMessage", null, null).toString();
        }
        catch (Exception exception) {
            _logger.error((Object)"get import warning message", (Throwable)exception);
            return null;
        }
    }

    static {
        MONITOR_OBJECT_NAME = MBeanUtil.create("nMaster:service=PMDBMonitorProvider");
        _weekDayId = -1L;
        try {
            _rmiAdaptor = JNDIClient.getRMIAdaptor(0, false);
            Number number = (Number)_rmiAdaptor.invoke(MONITOR_OBJECT_NAME, "getWeekDayTimebucketId", null, null);
            _weekDayId = number.longValue();
        }
        catch (Exception exception) {
            _logger.error((Object)exception);
        }
    }
}

