/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.sysuptime.common.performance.Monitor;
import com.sysuptime.common.util.DomUtil;
import com.sysuptime.mainframe.msp.ClientProxy;
import com.sysuptime.mainframe.performance.ConfirmDialog;
import java.awt.Frame;
import java.io.File;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.tree.DefaultElement;
import org.openide.util.NbBundle;

public class MonitorExporterDialog
extends ConfirmDialog {
    private static final Logger _logger = Logger.getLogger((String)MonitorExporterDialog.class.getName());
    private static final String TITLE = _bundle.getString("title_monitorexporterdialog");
    private boolean _isModel;
    private Frame _owner;
    private List _monitorList;

    public MonitorExporterDialog(Frame frame, boolean bl2) {
        this._owner = frame;
        this._isModel = bl2;
        this.initComponent();
    }

    public MonitorExporterDialog(Frame frame, boolean bl2, List list) {
        this._owner = frame;
        this._isModel = bl2;
        this._monitorList = list;
        this.initComponent();
        this.pack();
    }

    private void initComponent() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogType(1);
        jFileChooser.setDialogTitle(TITLE);
        jFileChooser.setSize(400, 300);
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Monitor Data File";
            }
        });
        if (jFileChooser.showSaveDialog(this) == 0) {
            try {
                this.writeXMLFile(jFileChooser.getSelectedFile().getAbsolutePath());
            }
            catch (Exception exception) {
                _logger.error((Object)"", (Throwable)exception);
                JOptionPane.showMessageDialog(this, NbBundle.getMessage(MonitorExporterDialog.class, (String)"ExportMonitorHelper_message_file_error"));
            }
        }
    }

    private void writeXMLFile(String object) throws Exception {
        File file;
        if (!((String)object).trim().endsWith(".xml")) {
            object = (String)object + ".xml";
        }
        if ((file = new File((String)object)).exists()) {
            this.createXMLfile(file, true);
            return;
        }
        this.createXMLfile(file, false);
    }

    private void createXMLfile(File file, boolean bl2) throws Exception {
        DefaultElement defaultElement = new DefaultElement("Monitors");
        defaultElement.addAttribute("version", String.valueOf(7.0f));
        int n2 = this._monitorList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Monitor monitor = (Monitor)this._monitorList.get(i2);
            int n3 = monitor.getScheduleId();
            Element element = ClientProxy.getInstance().exportMonitor(n3);
            defaultElement.add(element);
        }
        Document document = DocumentHelper.createDocument((Element)defaultElement);
        if (!bl2) {
            DomUtil.write(document, file.getAbsolutePath(), false);
        } else {
            int n4 = JOptionPane.showConfirmDialog(this, NbBundle.getMessage(MonitorExporterDialog.class, (String)"ExportMonitorHelper_file_exist"), NbBundle.getMessage(MonitorExporterDialog.class, (String)"title_monitorexporterdialog"), 0);
            if (n4 == 0) {
                DomUtil.write(document, file.getAbsolutePath(), false);
            }
        }
    }

    @Override
    public Frame getOwner() {
        return this._owner;
    }

    public void setOwner(Frame frame) {
        this._owner = frame;
    }

    public boolean isModel() {
        return this._isModel;
    }

    public void setModel(boolean bl2) {
        this._isModel = bl2;
    }
}

