/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.common.util.StreamUtils;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.DialogProvider;
import com.sysuptime.mainframe.performance.FormImportDialog;
import com.sysuptime.mainframe.performance.MonitorBroker;
import com.sysuptime.mainframe.performance.NonNegativeShortValidator;
import com.sysuptime.mainframe.performance.NonNullValidator;
import com.sysuptime.mainframe.performance.OperationDialog;
import com.sysuptime.mainframe.performance.PerformanceUIUtil;
import com.sysuptime.mainframe.performance.PositiveIntValidator;
import com.sysuptime.mainframe.performance.ReadOnlyTableModel;
import com.sysuptime.mainframe.performance.SelectionValidator;
import com.sysuptime.mainframe.performance.SingletonValidator;
import com.sysuptime.mainframe.performance.URLValidator;
import com.sysuptime.mainframe.performance.UrlAction;
import com.sysuptime.mainframe.util.SwingUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.openide.util.NbBundle;

public class UrlItemDialog
extends OperationDialog {
    private static final String URL = _bundle.getString("url");
    private static final String TIMEOUT = _bundle.getString("timeout");
    private static final String RETRIES = _bundle.getString("retries");
    private static final String METHOD = _bundle.getString("label_method");
    private static final String HEAD = _bundle.getString("combobox_head");
    private static final String GET = _bundle.getString("combobox_get");
    private static final String POST = _bundle.getString("combobox_post");
    private static final String OPTIONS = _bundle.getString("combobox_options");
    private static final String PUT = _bundle.getString("combobox_put");
    private static final String HTTP_SERVER = _bundle.getString("combobox_httpserver");
    private static final String HTTP_PROXY = _bundle.getString("combobox_httpproxy");
    private static final String AUTHENTICATION = _bundle.getString("label_authentication");
    private static final String PROXY = _bundle.getString("label_useproxy");
    private static final String FORM = _bundle.getString("label_form");
    private static final String ADDRESS = _bundle.getString("label_address");
    private static final String PORT = _bundle.getString("port");
    private static final String DOMAIN = _bundle.getString("label_domain");
    private static final String MESSAGE_URL = _bundle.getString("message_url");
    private static final String TIP_IMPORT_DIALOG = _bundle.getString("tip_importdialog");
    private static final String[] COMBOBOX_METHOD = new String[]{GET, POST, HEAD, OPTIONS, PUT};
    private static final String[] COLUMNS = new String[]{DialogConstants.LABEL_NAME, DialogConstants.LABEL_VALUE};
    private JTextField _url;
    private String _checkedUrl;
    private JTextField _timeout;
    private JTextField _retries;
    private int _checkedTimeout;
    private short _checkedRetries;
    private JComboBox _methodBox;
    private AuthenticationPanel _authentication;
    private ProxyPanel _proxy;
    private FormPanel _form;
    private JCheckBox _authenticationBox;
    private JCheckBox _formBox;
    private JCheckBox _proxyBox;
    private UrlAction _owner;
    private boolean _isAdded;
    private URLAction _action = new URLAction();

    public UrlItemDialog(UrlAction urlAction, String string, boolean bl2, boolean bl3) {
        super(urlAction._parent, string, bl2);
        this.initHttpServer(urlAction, bl3);
        this.initComponent();
        this.initUserData();
    }

    private void initHttpServer(JDialog jDialog, boolean bl2) {
        this._owner = (UrlAction)jDialog;
        this._isAdded = bl2;
    }

    private void initComponent() {
        Container container = this.getContentPane();
        container.add((Component)this.getBodyPanel(), "Center");
        container.add((Component)this.getConfirmPanel(), "South");
        this.pack();
    }

    private JPanel getBodyPanel() {
        FormLayout formLayout = new FormLayout("p,3dlu,p:g,3dlu,p", "p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addLabel(URL, cellConstraints.xy(1, 1));
        this._url = new JTextField("http://");
        this._url.setToolTipText(NbBundle.getMessage(UrlItemDialog.class, (String)"MSG_URL_FIELD_TIP"));
        this._url.setPreferredSize(DialogConstants.URL_SIZE);
        panelBuilder.add((Component)this._url, cellConstraints.xy(3, 1));
        panelBuilder.addLabel(TIMEOUT, cellConstraints.xy(1, 3));
        this._timeout = new JTextField("10000");
        this._timeout.setPreferredSize(DialogConstants.XLONG_SIZE);
        panelBuilder.add((Component)this._timeout, cellConstraints.xy(3, 3));
        panelBuilder.addLabel(_bundle.getString("MILLISECONDS"), cellConstraints.xy(5, 3));
        panelBuilder.addLabel(RETRIES, cellConstraints.xy(1, 5));
        this._retries = new JTextField("0");
        this._retries.setPreferredSize(DialogConstants.XLONG_SIZE);
        panelBuilder.add((Component)this._retries, cellConstraints.xy(3, 5));
        panelBuilder.addLabel(METHOD, cellConstraints.xy(1, 7));
        this._methodBox = new JComboBox<String>(COMBOBOX_METHOD);
        this._methodBox.setPreferredSize(DialogConstants.XLONG_SIZE);
        MethodAction methodAction = new MethodAction();
        this._methodBox.addItemListener(methodAction);
        panelBuilder.add((Component)this._methodBox, cellConstraints.xy(3, 7));
        this._authenticationBox = new JCheckBox(AUTHENTICATION);
        this._authenticationBox.addItemListener(methodAction);
        panelBuilder.add((Component)this._authenticationBox, cellConstraints.xy(1, 9));
        this._authentication = new AuthenticationPanel();
        this._authentication.getPanel().setVisible(false);
        panelBuilder.add((Component)this._authentication.getPanel(), cellConstraints.xywh(1, 11, 5, 1));
        this._proxyBox = new JCheckBox(PROXY);
        this._proxyBox.addItemListener(methodAction);
        this._proxy = new ProxyPanel();
        this._proxy.getPanel().setVisible(false);
        this._formBox = new JCheckBox(FORM);
        this._formBox.setVisible(false);
        this._formBox.addItemListener(methodAction);
        panelBuilder.add((Component)this._formBox, cellConstraints.xy(1, 17));
        this._form = new FormPanel();
        this._form.getPanel().setVisible(false);
        panelBuilder.add((Component)this._form.getPanel(), cellConstraints.xywh(1, 19, 5, 1));
        return panelBuilder.getPanel();
    }

    private void initUserData() {
        if (!this._isAdded) {
            List list = (List)this._owner.getSelectedComboParameter();
            this._url.setText(this.getSimpleParameter(list, 0));
            this._timeout.setText(this.getSimpleParameter(list, 1));
            this._retries.setText(this.getSimpleParameter(list, 2));
            this._methodBox.setSelectedIndex(Integer.parseInt(this.getSimpleParameter(list, 3)));
            this.initAuths((List)list.get(4));
            this.initProxies((List)list.get(5));
            this.initForms((List)list.get(6));
        } else {
            Map map = MonitorBroker.getConfigProperties();
            String string = map.get("performance.proxyHost").toString();
            if (string != null && string.length() != 0) {
                this._proxyBox.setSelected(true);
                this._proxy._address.setText(string);
                this._proxy._address.setCaretPosition(0);
                this._proxy._port.setText(map.get("performance.proxyPort").toString());
                this._proxy._port.setCaretPosition(0);
            }
        }
    }

    private String getSimpleParameter(List list, int n2) {
        return (String)((List)list.get(n2)).get(0);
    }

    private void initAuths(List list) {
        int n2;
        int n3 = list.size();
        String[] stringArray = new String[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            stringArray[n2] = (String)list.get(n2);
        }
        n2 = Integer.parseInt(stringArray[0]);
        if (n2 == 0) {
            this._authenticationBox.setSelected(true);
            this._authentication.getPanel().setVisible(true);
            int n4 = Integer.parseInt(stringArray[1]);
            if (n4 == 0) {
                this._authentication._serverRadio.setSelected(true);
            } else {
                this._authentication._proxyRadio.setSelected(true);
            }
            this._authentication._userName.setText(stringArray[2]);
            this._authentication._password.setText(stringArray[3]);
            this._authentication._host.setText(stringArray[4]);
            this._authentication._domain.setText(stringArray[5]);
        }
    }

    private void initProxies(List list) {
        int n2;
        int n3 = list.size();
        String[] stringArray = new String[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            stringArray[n2] = (String)list.get(n2);
        }
        n2 = Integer.parseInt(stringArray[0]);
        if (n2 == 0) {
            this._proxyBox.setSelected(true);
            this._proxy.getPanel().setVisible(true);
            this._proxy._address.setText(stringArray[1]);
            this._proxy._port.setText(stringArray[2]);
        }
    }

    private void initForms(List list) {
        int n2;
        int n3 = list.size();
        String[] stringArray = new String[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            stringArray[n2] = (String)list.get(n2);
        }
        n2 = Integer.parseInt(stringArray[0]);
        if (n2 == 0) {
            this._formBox.setVisible(true);
            this._formBox.setSelected(true);
            this._form.getPanel().setVisible(true);
            for (int i2 = 1; i2 < n3; i2 += 2) {
                this._form._formModel.addRow(new String[]{stringArray[i2], stringArray[i2 + 1]});
            }
        }
    }

    private void resetMethods() {
        String string = (String)this._methodBox.getSelectedItem();
        if (string.equals(POST)) {
            this._authenticationBox.setVisible(true);
            this._formBox.setVisible(true);
        } else {
            this._authenticationBox.setVisible(true);
            this._formBox.setVisible(false);
            this._formBox.setSelected(false);
        }
        this.setSize(this.getPreferredSize());
    }

    private void doDefaultProxy() {
        Map map = MonitorBroker.getConfigProperties();
        this._proxy._address.setText(map.get("performance.proxyHost").toString());
        this._proxy._address.setCaretPosition(0);
        this._proxy._port.setText(map.get("performance.proxyPort").toString());
        this._proxy._port.setCaretPosition(0);
    }

    private void doImport() {
        FormImportDialog formImportDialog = DialogProvider.createFormImportDialog(this);
        if (formImportDialog.isPut()) {
            this.clearForm();
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(formImportDialog.getFilePath());
                String string = StreamUtils.getInput(fileInputStream);
                StreamUtils.close(null, null, fileInputStream);
                Prop prop = UrlItemDialog.getAction(string, formImportDialog.getAction());
                int n2 = prop.getEnd();
                int n3 = string.indexOf("</form>", n2);
                if (n3 != -1) {
                    this._form._formModel.addRow(new String[]{"action", formImportDialog.getAction()});
                    this.addPairs(string, n2, n3);
                }
            }
            catch (Exception exception) {
                this._logger.error((Object)"Import file... ", (Throwable)exception);
            }
        }
    }

    private static Prop getAction(String string, String string2) {
        int n2 = 0;
        Prop prop = null;
        while ((prop = UrlItemDialog.getValue(string, "action=", n2)).getEnd() != -1) {
            if (string2.equalsIgnoreCase(prop.getValue())) {
                return prop;
            }
            n2 = prop.getEnd();
        }
        return prop;
    }

    private void addPairs(String string, int n2, int n3) {
        if ((n2 = string.indexOf("<", n2)) != -1) {
            while (true) {
                Prop prop = UrlItemDialog.getValue(string, "name=", n2);
                System.out.print("Name=>>>>>>>>>> " + prop.getValue());
                if (prop.getEnd() == -1) {
                    return;
                }
                if (prop.getEnd() > n3) {
                    return;
                }
                int n4 = string.indexOf(">", prop.getEnd());
                Prop prop2 = UrlItemDialog.getValue(string, "value=", prop.getEnd());
                if (prop2.getEnd() == -1 || prop2.getEnd() > n4) {
                    prop2.setValue("");
                    n2 = n4;
                } else {
                    n2 = prop2.getEnd();
                }
                this._form._formModel.addRow(new String[]{prop.getValue(), prop2.getValue()});
            }
        }
    }

    private static Prop getValue(String string, String string2, int n2) {
        int n3 = string.indexOf(string2, n2);
        Prop prop = new Prop();
        if (n3 != -1) {
            int n4 = n3 + string2.length();
            int n5 = string.indexOf(">", n4);
            if (n5 == -1) {
                return prop;
            }
            int n6 = string.indexOf("/", n4);
            if (n6 != -1 && n6 == n5 - 1) {
                n5 = n6;
            }
            int n7 = string.indexOf(" ", n4);
            String string3 = null;
            if (n7 == -1) {
                prop.setEnd(n5);
                string3 = string.substring(n4, n5).trim();
            } else if (n7 > n5) {
                prop.setEnd(n5);
                string3 = string.substring(n4, n5).trim();
            } else {
                prop.setEnd(n7);
                string3 = string.substring(n4, n7).trim();
            }
            int n8 = string3.indexOf("\"");
            if (n8 != -1) {
                int n9;
                if ((n9 = string3.indexOf("\"", ++n8)) != -1) {
                    prop.setValue(string3.substring(n8, n9).trim());
                }
            } else {
                prop.setValue(string3);
            }
        }
        return prop;
    }

    private void clearForm() {
        DefaultCellEditor defaultCellEditor = (DefaultCellEditor)this._form._formTable.getCellEditor();
        if (defaultCellEditor != null) {
            defaultCellEditor.stopCellEditing();
        }
        int n2 = this._form._formModel.getRowCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            this._form._formModel.removeRow(0);
        }
    }

    @Override
    protected void addItem() {
        DialogProvider.createFormItemDialog(this, DialogConstants.BUTTON_NEW, true);
    }

    @Override
    protected void removeItem() {
        int n2 = this._form._formTable.getSelectedRow();
        Object object = SingletonValidator.checkAllDialog(this, DialogConstants.MESSAGE_ONE_ROW, n2, SelectionValidator.CLASS);
        if (object == null) {
            return;
        }
        PerformanceUIUtil.removeRow(this._form._formTable, this._form._formModel, n2);
    }

    @Override
    protected void modifyItem() {
        int n2 = this._form._formTable.getSelectedRow();
        Object object = SingletonValidator.checkAllDialog(this, DialogConstants.MESSAGE_ONE_ROW, n2, SelectionValidator.CLASS);
        if (object == null) {
            return;
        }
        DialogProvider.createFormItemDialog(this, DialogConstants.BUTTON_NEW, false);
    }

    public void operateFormItem(String string, String string2, boolean bl2) {
        if (bl2) {
            this._form._formModel.addRow(new String[]{string, string2});
        } else {
            int n2 = this._form._formTable.getSelectedRow();
            this._form._formModel.setValueAt(string, n2, 0);
            this._form._formModel.setValueAt(string2, n2, 1);
        }
    }

    public String[] getSelectedFormItem() {
        int n2 = this._form._formTable.getSelectedRow();
        return new String[]{(String)this._form._formTable.getValueAt(n2, 0), (String)this._form._formTable.getValueAt(n2, 1)};
    }

    @Override
    protected void okDialog() {
        if (this.checkHttpServer()) {
            boolean bl2 = this._owner.operateComboParameter(this._checkedUrl, this.getParameter(), this._isAdded);
            if (!bl2) {
                JOptionPane.showMessageDialog(this, MESSAGE_URL);
                return;
            }
            this.dispose();
        }
    }

    private Object getParameter() {
        int n2 = this._methodBox.getSelectedIndex();
        AuthenticationPanel authenticationPanel = null;
        if (this._authenticationBox.isSelected()) {
            authenticationPanel = this._authentication;
        }
        ProxyPanel proxyPanel = null;
        if (this._proxyBox.isSelected()) {
            proxyPanel = this._proxy;
        }
        FormPanel formPanel = null;
        if (this._formBox.isSelected()) {
            formPanel = this._form;
        }
        return UrlItemDialog.createParameter(this._checkedUrl, this._checkedTimeout, this._checkedRetries, n2, authenticationPanel, proxyPanel, formPanel);
    }

    public static List createParameter(String string, int n2, short s2, int n3, AuthenticationPanel authenticationPanel, ProxyPanel proxyPanel, FormPanel formPanel) {
        ArrayList arrayList = new ArrayList();
        UrlItemDialog.addUrl(arrayList, string);
        UrlItemDialog.addTimeout(arrayList, n2);
        UrlItemDialog.addRetries(arrayList, s2);
        UrlItemDialog.addMethod(arrayList, n3);
        UrlItemDialog.addAuth(arrayList, authenticationPanel);
        UrlItemDialog.addProxy(arrayList, proxyPanel);
        UrlItemDialog.addForm(arrayList, formPanel);
        return arrayList;
    }

    private static void addUrl(List list, String string) {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(string);
        list.add(arrayList);
    }

    private static void addTimeout(List list, int n2) {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(String.valueOf(n2));
        list.add(arrayList);
    }

    private static void addRetries(List list, int n2) {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(String.valueOf(n2));
        list.add(arrayList);
    }

    private static void addMethod(List list, int n2) {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(String.valueOf(n2));
        list.add(arrayList);
    }

    private static void addAuth(List list, AuthenticationPanel authenticationPanel) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (authenticationPanel != null) {
            arrayList.add(String.valueOf(0));
            if (authenticationPanel._serverRadio.isSelected()) {
                arrayList.add(String.valueOf(0));
            } else {
                arrayList.add(String.valueOf(1));
            }
            arrayList.add(authenticationPanel._checkedUserName);
            arrayList.add(authenticationPanel._checkedPassword);
            arrayList.add(authenticationPanel._checkedHost);
            arrayList.add(authenticationPanel._checkedDomain);
        } else {
            arrayList.add(String.valueOf(1));
        }
        list.add(arrayList);
    }

    private static void addProxy(List list, ProxyPanel proxyPanel) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (proxyPanel != null) {
            arrayList.add(String.valueOf(0));
            arrayList.add(proxyPanel._address.getText());
            arrayList.add(proxyPanel._port.getText());
        } else {
            arrayList.add(String.valueOf(1));
        }
        list.add(arrayList);
    }

    private static void addForm(List list, FormPanel formPanel) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (formPanel != null) {
            arrayList.add(String.valueOf(0));
            int n2 = formPanel._formModel.getRowCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                arrayList.add(formPanel._formModel.getValueAt(i2, 0));
                arrayList.add(formPanel._formModel.getValueAt(i2, 1));
            }
        } else {
            arrayList.add(String.valueOf(1));
        }
        list.add(arrayList);
    }

    private boolean checkHttpServer() {
        String string = (String)SingletonValidator.checkAllDialog(this, URL, this._url.getText(), URLValidator.CLASS);
        if (string == null) {
            return false;
        }
        Integer n2 = (Integer)SingletonValidator.checkAllDialog(this, TIMEOUT, this._timeout.getText(), PositiveIntValidator.CLASS);
        if (n2 == null) {
            return false;
        }
        Short s2 = (Short)SingletonValidator.checkAllDialog(this, RETRIES, this._retries.getText(), NonNegativeShortValidator.CLASS);
        if (s2 == null) {
            return false;
        }
        if (this._authenticationBox.isSelected()) {
            String string2 = (String)SingletonValidator.checkAllDialog(this, DialogConstants.LABEL_USER_NAME, this._authentication._userName.getText(), NonNullValidator.CLASS);
            if (string2 == null) {
                return false;
            }
            String string3 = (String)SingletonValidator.checkAllDialog(this, DialogConstants.LABEL_PASSWORD, String.valueOf(this._authentication._password.getPassword()), NonNullValidator.CLASS);
            if (string3 == null) {
                return false;
            }
            String string4 = this._authentication._host.getText();
            String string5 = this._authentication._domain.getText();
            if (string4.length() == 0) {
                if (string5.length() != 0) {
                    string5 = (String)SingletonValidator.checkAllDialog(this, DOMAIN, this._authentication._domain.getText(), NonNullValidator.CLASS);
                    if (string5 == null) {
                        return false;
                    }
                    string4 = (String)SingletonValidator.checkAllDialog(this, DialogConstants.LABEL_HOST, this._authentication._host.getText(), NonNullValidator.CLASS);
                    if (string4 == null) {
                        return false;
                    }
                }
            } else {
                string4 = (String)SingletonValidator.checkAllDialog(this, DialogConstants.LABEL_HOST, this._authentication._host.getText(), NonNullValidator.CLASS);
                if (string4 == null) {
                    return false;
                }
                string5 = (String)SingletonValidator.checkAllDialog(this, DOMAIN, this._authentication._domain.getText(), NonNullValidator.CLASS);
                if (string5 == null) {
                    return false;
                }
            }
            this._authentication._checkedUserName = string2;
            this._authentication._checkedPassword = string3;
            this._authentication._checkedHost = string4;
            this._authentication._checkedDomain = string5;
        }
        if (this._formBox.isSelected() && this._form._formModel.getRowCount() == 0) {
            JOptionPane.showMessageDialog(this, DialogConstants.MESSAGE_NULL_RECORD);
            return false;
        }
        this._checkedUrl = string;
        this._checkedTimeout = n2;
        this._checkedRetries = s2;
        return true;
    }

    private class URLAction
    implements ActionListener {
        private URLAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object.equals(UrlItemDialog.this._form._import)) {
                UrlItemDialog.this.doImport();
            } else if (object.equals(UrlItemDialog.this._proxy._default)) {
                UrlItemDialog.this.doDefaultProxy();
            }
        }
    }

    private class MethodAction
    implements ItemListener {
        private MethodAction() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            ItemSelectable itemSelectable = itemEvent.getItemSelectable();
            if (itemSelectable.equals(UrlItemDialog.this._methodBox)) {
                if (itemEvent.getStateChange() == 1) {
                    UrlItemDialog.this.resetMethods();
                }
            } else if (itemSelectable.equals(UrlItemDialog.this._authenticationBox)) {
                if (UrlItemDialog.this._authenticationBox.isSelected()) {
                    UrlItemDialog.this._authentication.getPanel().setVisible(true);
                } else {
                    UrlItemDialog.this._authentication.getPanel().setVisible(false);
                }
                UrlItemDialog.this.setSize(UrlItemDialog.this.getPreferredSize());
            } else if (itemSelectable.equals(UrlItemDialog.this._proxyBox)) {
                if (UrlItemDialog.this._proxyBox.isSelected()) {
                    UrlItemDialog.this._proxy.getPanel().setVisible(true);
                } else {
                    UrlItemDialog.this._proxy.getPanel().setVisible(false);
                }
                UrlItemDialog.this.setSize(UrlItemDialog.this.getPreferredSize());
            } else if (itemSelectable.equals(UrlItemDialog.this._formBox)) {
                if (UrlItemDialog.this._formBox.isSelected()) {
                    UrlItemDialog.this._form.getPanel().setVisible(true);
                } else {
                    UrlItemDialog.this._form.getPanel().setVisible(false);
                }
                UrlItemDialog.this.setSize(UrlItemDialog.this.getPreferredSize());
            }
        }
    }

    private class AuthenticationPanel {
        private JRadioButton _serverRadio;
        private JRadioButton _proxyRadio;
        private JTextField _userName;
        private JPasswordField _password;
        private JTextField _host;
        private JTextField _domain;
        private String _checkedUserName;
        private String _checkedPassword;
        private String _checkedHost;
        private String _checkedDomain;
        private PanelBuilder _builder;

        public AuthenticationPanel() {
            FormLayout formLayout = new FormLayout("FILL:136PX:NONE,FILL:14PX:NONE,FILL:136PX:GROW(1.0)", "CENTER:DEFAULT:NONE,CENTER:5PX:NONE,CENTER:24PX:NONE,CENTER:5PX:NONE,CENTER:24PX:NONE,CENTER:5PX:NONE,CENTER:DEFAULT:NONE,CENTER:18PX:NONE,CENTER:5PX:NONE,CENTER:24PX:NONE,CENTER:18PX:NONE,CENTER:5PX:NONE");
            this._builder = new PanelBuilder(formLayout);
            this._builder.setBorder((Border)new TitledBorder(""));
            CellConstraints cellConstraints = new CellConstraints();
            this._serverRadio = new JRadioButton(HTTP_SERVER, true);
            this._proxyRadio = new JRadioButton(HTTP_PROXY);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this._serverRadio);
            buttonGroup.add(this._proxyRadio);
            this._builder.addLabel(DialogConstants.LABEL_USER_NAME, cellConstraints.xy(1, 3));
            this._userName = new JTextField();
            this._userName.setPreferredSize(DialogConstants.LONG_SIZE);
            this._builder.add((Component)this._userName, cellConstraints.xy(3, 3));
            this._builder.addLabel(DialogConstants.LABEL_PASSWORD, cellConstraints.xy(1, 5));
            this._password = new JPasswordField();
            this._password.setPreferredSize(DialogConstants.LONG_SIZE);
            this._builder.add((Component)this._password, cellConstraints.xy(3, 5));
            this._builder.addLabel(DialogConstants.LABEL_HOST, cellConstraints.xy(1, 7));
            this._host = new JTextField();
            this._host.setPreferredSize(DialogConstants.LONG_SIZE);
            this._builder.addLabel(DialogConstants.LABEL_DIGEST_AUTHENTICATION, cellConstraints.xywh(1, 8, 3, 1));
            this._builder.add((Component)this._host, cellConstraints.xy(3, 7));
            this._builder.addLabel(DOMAIN, cellConstraints.xywh(1, 10, 1, 1));
            this._builder.addLabel(DialogConstants.LABEL_DIGEST_AUTHENTICATION, cellConstraints.xywh(1, 11, 3, 1));
            this._domain = new JTextField();
            this._domain.setPreferredSize(DialogConstants.LONG_SIZE);
            this._builder.add((Component)this._domain, cellConstraints.xywh(3, 10, 1, 1));
            this.addFillComponents(this._builder.getPanel(), new int[]{2}, new int[]{2, 4, 6, 9, 12});
        }

        void addFillComponents(Container container, int[] nArray, int[] nArray2) {
            int n2;
            Dimension dimension = new Dimension(10, 10);
            boolean bl2 = false;
            CellConstraints cellConstraints = new CellConstraints();
            if (nArray.length > 0 && nArray2.length > 0 && nArray[0] == 1 && nArray2[0] == 1) {
                container.add(Box.createRigidArea(dimension), cellConstraints.xy(1, 1));
                bl2 = true;
            }
            for (n2 = 0; n2 < nArray.length; ++n2) {
                if (nArray[n2] == 1 && bl2) continue;
                container.add(Box.createRigidArea(dimension), cellConstraints.xy(nArray[n2], 1));
            }
            for (n2 = 0; n2 < nArray2.length; ++n2) {
                if (nArray2[n2] == 1 && bl2) continue;
                container.add(Box.createRigidArea(dimension), cellConstraints.xy(1, nArray2[n2]));
            }
        }

        public JPanel getPanel() {
            return this._builder.getPanel();
        }
    }

    private class ProxyPanel {
        private JTextField _address;
        private JTextField _port;
        private PanelBuilder _builder;
        private JButton _default;

        public ProxyPanel() {
            FormLayout formLayout = new FormLayout("p,3dlu,p:g,3dlu,p,3dlu,p:g,3dlu,p", "p");
            this._builder = new PanelBuilder(formLayout);
            this._builder.setBorder((Border)new TitledBorder(""));
            CellConstraints cellConstraints = new CellConstraints();
            this._builder.addLabel(ADDRESS, cellConstraints.xy(1, 1));
            this._address = new JTextField();
            this._address.setPreferredSize(DialogConstants.LONG_SIZE);
            this._builder.add((Component)this._address, cellConstraints.xy(3, 1));
            this._builder.addLabel(PORT, cellConstraints.xy(5, 1));
            this._port = new JTextField();
            this._port.setPreferredSize(DialogConstants.SHORT_SIZE);
            this._builder.add((Component)this._port, cellConstraints.xy(7, 1));
            this._default = new JButton(DialogConstants.BUTTON_DEFAULT);
            this._default.setPreferredSize(DialogConstants.OPERATE_SIZE);
            this._default.addActionListener(UrlItemDialog.this._action);
            this._builder.add((Component)this._default, cellConstraints.xy(9, 1));
        }

        public JPanel getPanel() {
            return this._builder.getPanel();
        }
    }

    private class FormPanel {
        private JTable _formTable;
        private ReadOnlyTableModel _formModel;
        private PanelBuilder _builder;
        private JButton _import;

        public FormPanel() {
            FormLayout formLayout = new FormLayout("p:grow,3dlu,p", "p,3dlu,p,3dlu,p:g");
            this._builder = new PanelBuilder(formLayout);
            this._builder.setBorder((Border)new TitledBorder(""));
            CellConstraints cellConstraints = new CellConstraints();
            this._formModel = new ReadOnlyTableModel(null, COLUMNS);
            this._formTable = SwingUtil.createJTable(this._formModel);
            PerformanceUIUtil.setGraceHeader(this._formTable);
            this._formTable.setSelectionMode(0);
            this._formTable.setPreferredScrollableViewportSize(new Dimension(150, 200));
            JScrollPane jScrollPane = new JScrollPane(this._formTable);
            jScrollPane.setBorder(BorderFactory.createEtchedBorder());
            this._builder.add((Component)jScrollPane, cellConstraints.xywh(1, 1, 1, 5));
            this._import = new JButton(DialogConstants.BUTTON_IMPORT);
            this._import.setPreferredSize(DialogConstants.OPERATE_SIZE);
            this._import.setToolTipText(TIP_IMPORT_DIALOG);
            this._import.addActionListener(UrlItemDialog.this._action);
            this._builder.add((Component)this._import, cellConstraints.xy(3, 1));
            this._builder.add((Component)UrlItemDialog.this.getOperationPanel(false, true), cellConstraints.xy(3, 3));
        }

        public JPanel getPanel() {
            return this._builder.getPanel();
        }
    }

    private static class Prop {
        int _end = -1;
        String _value;

        private Prop() {
        }

        void setEnd(int n2) {
            this._end = n2;
        }

        void setValue(String string) {
            this._value = string;
        }

        int getEnd() {
            return this._end;
        }

        String getValue() {
            return this._value;
        }
    }
}

