/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.trapreceiver;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.common.trapreceiver.EscalationEmailParameter;
import com.sysuptime.common.trapreceiver.EscalationSchedule;
import com.sysuptime.common.trapreceiver.TimeBasedEmails;
import com.sysuptime.common.util.ICommonBundle;
import com.sysuptime.mainframe.Startup;
import com.sysuptime.mainframe.msp.ClientProxy;
import com.sysuptime.mainframe.trapreceiver.AlarmActionsDialog;
import com.sysuptime.mainframe.trapreceiver.EscalationEmailDialog;
import com.sysuptime.mainframe.trapreceiver.EscalationPanel$1;
import com.sysuptime.mainframe.trapreceiver.EscalationPanel$2;
import com.sysuptime.mainframe.trapreceiver.EscalationPanel$3;
import com.sysuptime.mainframe.trapreceiver.EscalationPanel$4;
import com.sysuptime.mainframe.trapreceiver.EscalationPanel$5;
import com.sysuptime.mainframe.trapreceiver.EscalationPanel$6;
import com.sysuptime.mainframe.util.FormUtils;
import com.sysuptime.mainframe.util.SwingUtil;
import com.sysuptime.mainframe.util.TableSorter;
import com.sysuptime.server.msp.Command;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class EscalationPanel
extends JPanel
implements Serializable,
CaretListener {
    private static final Logger _logger = Logger.getLogger((String)EscalationPanel.class.getName());
    public static final String OBJECT_NAME = "nMaster:service=EscalationScheduleProvider";
    private static final String COL_TIME = EscalationPanel.a("Escalation_table_col_time");
    private static final String COL_SEVERITY = EscalationPanel.a("Escalation_table_col_severity");
    private static final String COL_SUBJECT = EscalationPanel.a("Escalation_table_col_subject");
    private static final String COL_EMAIL = EscalationPanel.a("Escalation_table_col_email");
    private static final String[] COLUMNS = new String[]{COL_TIME, COL_SEVERITY, COL_SUBJECT, COL_EMAIL};
    private JCheckBox _enabled = new JCheckBox(EscalationPanel.a("LBL_escalation_enabled"));
    private JTextField _checkTimeField = new JTextField();
    private Map _emailTimePairList = new HashMap();
    private JTable _emailTable;
    private TableSorter _sorter;
    private DefaultTableModel _defaultTableModel = new DefaultTableModel();
    private JButton _addBtn;
    private JButton _modifyBtn;
    private JButton _deleteBtn;
    private JButton _applyBtn;
    private int _scheduleId;
    private long _startTime;
    public static List _timeList = new ArrayList();

    public EscalationPanel() {
        this.add((Component)this.createPanel(), "Center");
        this.a();
    }

    private void a() {
        this._checkTimeField.addCaretListener(this);
        this._enabled.addActionListener(new EscalationPanel$1(this));
        this._addBtn.addActionListener(new EscalationPanel$2(this));
        this._modifyBtn.addActionListener(new EscalationPanel$3(this));
        this._deleteBtn.addActionListener(new EscalationPanel$4(this));
        this._applyBtn.addActionListener(new EscalationPanel$5(this));
        SwingUtilities.invokeLater(() -> {
            block6: {
                block5: {
                    Command[] commandArray = AlarmActionsDialog.A();
                    try {
                        EscalationSchedule escalationSchedule = ClientProxy.getInstance().getEscalationData();
                        this._enabled.setSelected(escalationSchedule.isEnabled());
                        this._checkTimeField.setText("" + escalationSchedule.getPeriod() / 60000L);
                        this._scheduleId = escalationSchedule.getScheduleId();
                        this._startTime = escalationSchedule.getStartDateTime();
                        this._emailTimePairList.clear();
                        _timeList.clear();
                        List list = escalationSchedule.getEmailParameterList();
                        if (list == null) break block5;
                        int n2 = list.size();
                        for (int i2 = 0; i2 < n2; ++i2) {
                            EscalationEmailParameter escalationEmailParameter = (EscalationEmailParameter)list.get(i2);
                            Integer n3 = new Integer(escalationEmailParameter.getActiveTime() / 60000);
                            Object[] objectArray = new Object[]{n3, escalationEmailParameter.getSeverity(), escalationEmailParameter.getEmailSubject(), escalationEmailParameter.getEmailTimeString()};
                            try {
                                this._defaultTableModel.addRow(objectArray);
                                this._emailTimePairList.put(escalationEmailParameter.getActiveTime(), escalationEmailParameter.getEmailTimePairList());
                                _timeList.add(escalationEmailParameter.getActiveTime());
                                if (commandArray != null) break block6;
                                if (commandArray == null) continue;
                                break;
                            }
                            catch (Exception exception) {
                                throw EscalationPanel.a(exception);
                            }
                        }
                    }
                    catch (Exception exception) {
                        _logger.error((Object)"init failed", (Throwable)exception);
                    }
                }
                this.c();
            }
        });
        this._applyBtn.setEnabled(false);
    }

    public JPanel createPanel() {
        Command[] commandArray = AlarmActionsDialog.A();
        JPanel jPanel = new JPanel();
        FormLayout formLayout = new FormLayout("FILL:DEFAULT:NONE,FILL:158PX:NONE,FILL:217PX:NONE,FILL:86PX:NONE,FILL:6PX:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE", "CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE");
        CellConstraints cellConstraints = new CellConstraints();
        jPanel.setLayout((LayoutManager)formLayout);
        this._enabled.setText(EscalationPanel.a("LBL_escalation_enabled"));
        jPanel.add((Component)this._enabled, cellConstraints.xywh(2, 2, 2, 1));
        JLabel jLabel = new JLabel();
        jLabel.setText(EscalationPanel.a("LBL_check_every"));
        jPanel.add((Component)jLabel, cellConstraints.xywh(2, 4, 2, 1));
        jPanel.add((Component)this._checkTimeField, cellConstraints.xywh(4, 4, 2, 1));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(" " + ICommonBundle.MINUTES);
        jPanel.add((Component)jLabel2, cellConstraints.xy(6, 4));
        this._defaultTableModel = new EscalationPanel$6(this, null, COLUMNS);
        Command[] commandArray2 = commandArray;
        this._sorter = new TableSorter(this._defaultTableModel);
        this._emailTable = SwingUtil.createJTable(this._sorter);
        this._emailTable.setPreferredScrollableViewportSize(new Dimension(250, 250));
        this._emailTable.getColumnModel().getColumn(0).setPreferredWidth(50);
        this._emailTable.getColumnModel().getColumn(1).setPreferredWidth(20);
        this._emailTable.getColumnModel().getColumn(2).setPreferredWidth(20);
        this._emailTable.getColumnModel().getColumn(3).setPreferredWidth(160);
        this._emailTable.setRowSelectionAllowed(true);
        this._emailTable.setSelectionMode(0);
        this._sorter.setSortingStatus(0, 1);
        JScrollPane jScrollPane = new JScrollPane(this._emailTable);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add((Component)jScrollPane, cellConstraints.xywh(2, 8, 3, 7));
        this._addBtn = new JButton(ICommonBundle.ADD);
        jPanel.add((Component)this._addBtn, cellConstraints.xy(6, 8));
        this._modifyBtn = new JButton(ICommonBundle.MODIFY);
        jPanel.add((Component)this._modifyBtn, cellConstraints.xy(6, 10));
        this._deleteBtn = new JButton(ICommonBundle.DELETE);
        jPanel.add((Component)this._deleteBtn, cellConstraints.xy(6, 12));
        this._applyBtn = new JButton(ICommonBundle.APPLY);
        jPanel.add((Component)this._applyBtn, cellConstraints.xy(4, 16));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(EscalationPanel.a("LBL_sending_email"));
        jPanel.add((Component)jLabel3, cellConstraints.xyw(2, 6, 2));
        FormUtils.addFillComponents(jPanel, new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}, new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16});
        if (commandArray2 != null) {
            Command.b(new int[3]);
        }
        return jPanel;
    }

    private void b() {
        block13: {
            this._applyBtn.setEnabled(true);
            if (this._enabled.isSelected()) {
                boolean bl2;
                String string = this._checkTimeField.getText();
                try {
                    if (string.trim().length() == 0) {
                        this._applyBtn.setEnabled(false);
                        return;
                    }
                }
                catch (Exception exception) {
                    throw EscalationPanel.a(exception);
                }
                boolean bl3 = false;
                try {
                    if (Integer.parseInt(string) > 0) {
                        bl3 = true;
                    }
                }
                catch (Exception exception) {
                    this._applyBtn.setEnabled(false);
                    return;
                }
                int n2 = this._emailTable.getRowCount();
                try {
                    bl2 = n2 > 0;
                }
                catch (Exception exception) {
                    throw EscalationPanel.a(exception);
                }
                boolean bl4 = bl2;
                try {
                    try {
                        if (bl3 && bl4) break block13;
                    }
                    catch (Exception exception) {
                        throw EscalationPanel.a(exception);
                    }
                    this._applyBtn.setEnabled(false);
                }
                catch (Exception exception) {
                    throw EscalationPanel.a(exception);
                }
            }
        }
    }

    private void c() {
        boolean bl2 = this._enabled.isSelected();
        this._checkTimeField.setEnabled(bl2);
        this._emailTable.setEnabled(bl2);
        this._addBtn.setEnabled(bl2);
        this._modifyBtn.setEnabled(bl2);
        this._deleteBtn.setEnabled(bl2);
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        this.b();
    }

    private void d() {
        EscalationEmailDialog escalationEmailDialog = new EscalationEmailDialog(Startup.getFrame(), true);
        escalationEmailDialog.pack();
        SwingUtil.centerOnFrame(Startup.getFrame(), escalationEmailDialog);
        escalationEmailDialog.setVisible(true);
        if (escalationEmailDialog.isOK()) {
            EscalationEmailParameter escalationEmailParameter = escalationEmailDialog.getParameter();
            Integer n2 = new Integer(escalationEmailParameter.getActiveTime() / 60000);
            String string = escalationEmailParameter.getSeverity();
            String string2 = escalationEmailParameter.getEmailSubject();
            String string3 = escalationEmailParameter.getEmailTimeString();
            Object[] objectArray = new Object[]{n2, string, string2, string3};
            this._defaultTableModel.addRow(objectArray);
            this._emailTimePairList.put(escalationEmailParameter.getActiveTime(), escalationEmailParameter.getEmailTimePairList());
            _timeList.add(escalationEmailParameter.getActiveTime());
            this._defaultTableModel.fireTableDataChanged();
            this.b();
        }
    }

    private void e() {
        int n2 = this._emailTable.getSelectedRow();
        if (n2 < 0 || n2 > this._sorter.getRowCount()) {
            JOptionPane.showMessageDialog(this, EscalationPanel.a("MSG_select_email_table"));
            return;
        }
        int n3 = this._sorter.modelIndex(n2);
        EscalationEmailParameter escalationEmailParameter = this.a(n3);
        _timeList.remove((Object)escalationEmailParameter.getActiveTime());
        EscalationEmailDialog escalationEmailDialog = new EscalationEmailDialog(Startup.getFrame(), true, escalationEmailParameter);
        escalationEmailDialog.pack();
        SwingUtil.centerOnFrame(Startup.getFrame(), escalationEmailDialog);
        escalationEmailDialog.setVisible(true);
        if (escalationEmailDialog.isOK()) {
            this._emailTimePairList.remove(escalationEmailParameter.getActiveTime());
            escalationEmailParameter = escalationEmailDialog.getParameter();
            this._defaultTableModel.setValueAt(escalationEmailParameter.getSeverity(), n3, 1);
            Integer n4 = new Integer(escalationEmailParameter.getActiveTime() / 60000);
            this._defaultTableModel.setValueAt(n4, n3, 0);
            this._defaultTableModel.setValueAt(escalationEmailParameter.getEmailSubject(), n3, 2);
            this._defaultTableModel.setValueAt(escalationEmailParameter.getEmailTimeString(), n3, 3);
            this._emailTimePairList.put(escalationEmailParameter.getActiveTime(), escalationEmailParameter.getEmailTimePairList());
            this._defaultTableModel.fireTableDataChanged();
        }
        _timeList.add(escalationEmailParameter.getActiveTime());
        this.b();
    }

    private void f() {
        int n2 = this._emailTable.getSelectedRow();
        if (n2 < 0 || n2 > this._sorter.getRowCount()) {
            JOptionPane.showMessageDialog(this, EscalationPanel.a("MSG_select_email_table"));
            return;
        }
        int n3 = this._sorter.modelIndex(n2);
        EscalationEmailParameter escalationEmailParameter = this.a(n3);
        this._emailTimePairList.remove(escalationEmailParameter.getActiveTime());
        _timeList.remove((Object)escalationEmailParameter.getActiveTime());
        this._defaultTableModel.removeRow(n3);
        this._defaultTableModel.fireTableDataChanged();
        this.b();
    }

    private void g() {
        block21: {
            block20: {
                EscalationSchedule escalationSchedule;
                Command[] commandArray;
                block17: {
                    long l2;
                    block19: {
                        block18: {
                            long l3 = ClientProxy.getInstance().getProbe().getId();
                            commandArray = AlarmActionsDialog.A();
                            if (!ClientProxy.getInstance().isActive(l3)) {
                                return;
                            }
                            if (this._emailTable.getRowCount() < 0) {
                                JOptionPane.showMessageDialog(this, EscalationPanel.a("MSG_email_table"));
                                return;
                            }
                            if (this.h() != 0) {
                                if (this.h() == 2) {
                                    JOptionPane.showMessageDialog(this, EscalationPanel.a("MSG_time_margin_warning"));
                                    return;
                                }
                                if (this.h() == 1) {
                                    JOptionPane.showMessageDialog(this, EscalationPanel.a("MSG_email_time_warning"));
                                    return;
                                }
                            }
                            escalationSchedule = new EscalationSchedule();
                            escalationSchedule.setScheduleId(this._scheduleId);
                            escalationSchedule.setEnabled(this._enabled.isSelected());
                            if (!this._enabled.isSelected()) break block18;
                            if (this._startTime < 10000L || this._startTime == Long.MAX_VALUE) {
                                this._startTime = System.currentTimeMillis();
                            }
                            escalationSchedule.setStartDateTime(this._startTime);
                            if (commandArray == null) break block19;
                        }
                        escalationSchedule.setEnabled(false);
                    }
                    if ((l2 = Long.parseLong(this._checkTimeField.getText()) * 60000L) < 60000L) {
                        l2 = 60000L;
                    }
                    escalationSchedule.setPeriod(l2);
                    ArrayList<EscalationEmailParameter> arrayList = new ArrayList<EscalationEmailParameter>();
                    int n2 = this._defaultTableModel.getRowCount();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        EscalationEmailParameter escalationEmailParameter = this.a(i2);
                        escalationEmailParameter.setEmailGroupName(TimeBasedEmails.toXML(escalationEmailParameter.getEmailTimePairList()));
                        arrayList.add(escalationEmailParameter);
                        if (commandArray == null) {
                            if (commandArray == null) continue;
                        }
                        break block17;
                    }
                    escalationSchedule.setEmailParameterList(arrayList);
                }
                if (!this.a(escalationSchedule)) break block20;
                this._applyBtn.setEnabled(false);
                if (commandArray == null) break block21;
            }
            JOptionPane.showMessageDialog(this, EscalationPanel.a("MSG_schedule_update_failed"), ICommonBundle.ERROR, 0);
        }
    }

    private boolean a(EscalationSchedule escalationSchedule) {
        try {
            return ClientProxy.getInstance().modifyEscalation(escalationSchedule);
        }
        catch (Exception exception) {
            _logger.error((Object)"modify escalation", (Throwable)exception);
            return false;
        }
    }

    private EscalationEmailParameter a(int n2) {
        String string = String.valueOf(this._defaultTableModel.getValueAt(n2, 1));
        Integer n3 = (Integer)this._defaultTableModel.getValueAt(n2, 0);
        String string2 = String.valueOf(this._defaultTableModel.getValueAt(n2, 2));
        String string3 = String.valueOf(this._defaultTableModel.getValueAt(n2, 3));
        int n4 = n3 * 60000;
        EscalationEmailParameter escalationEmailParameter = new EscalationEmailParameter(string, n4, string2, string3);
        escalationEmailParameter.setEmailTimePairList((List)this._emailTimePairList.get(n4));
        return escalationEmailParameter;
    }

    private int h() {
        int n2;
        block4: {
            int n3 = 0;
            int n4 = this._defaultTableModel.getRowCount();
            Command[] commandArray = AlarmActionsDialog.A();
            block0: while (true) {
                int n5 = n3;
                int n6 = n4;
                block1: while (n5 < n6) {
                    int n7;
                    n2 = n7 = ((Integer)this._defaultTableModel.getValueAt(n3, 0)).intValue();
                    if (commandArray != null) break block4;
                    if (n2 < Integer.parseInt(this._checkTimeField.getText())) {
                        return 1;
                    }
                    int n8 = this._defaultTableModel.getRowCount();
                    for (int i2 = n3 + 1; i2 < n8; ++i2) {
                        int n9 = (Integer)this._defaultTableModel.getValueAt(i2, 0);
                        n5 = Math.abs(n9 - n7);
                        n6 = Integer.parseInt(this._checkTimeField.getText());
                        if (commandArray != null) continue block1;
                        if (n5 >= n6) continue;
                        return 2;
                    }
                    ++n3;
                    if (commandArray == null) continue block0;
                }
                break;
            }
            n2 = 0;
        }
        return n2;
    }

    private static String a(String string) {
        return NbBundle.getMessage(EscalationPanel.class, (String)string);
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

