/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.graphtodb;

import com.ireasoning.app.mibbrowser.f.e;
import com.ireasoning.protocol.TimeoutException;
import com.ireasoning.protocol.snmp.SnmpSession;
import com.sysuptime.common.alarm.PortUtilAlarm;
import com.sysuptime.common.graph.GraphScheduleBean;
import com.sysuptime.common.graph.PortScheduleBean;
import com.sysuptime.common.model.EthernetInterface;
import com.sysuptime.common.model.NetworkInterface;
import com.sysuptime.common.model.NetworkNodeBean;
import com.sysuptime.common.model.TopologyData;
import com.sysuptime.server.discovery.GraphDao;
import com.sysuptime.server.graphtodb.GraphScheduleExecutorProxy;
import com.sysuptime.server.graphtodb.GraphScheduleProcessor;
import com.sysuptime.server.msp.ActionProxy;
import com.sysuptime.server.util.ServerConfig;
import com.sysuptime.server.util.SnmpUtil;
import com.sysuptime.server.util.SystemStatus;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PortScheduleExecutor {
    private static final Logger _logger = Logger.getLogger((String)PortScheduleExecutor.class.getName());
    public static final String PORT_WARNING_FROM = "portWarning.from";
    public static final String PORT_WARNING_TO = "portWarning.to";
    public static final String PORT_WARNING_DEVICE_TYPES = "portWarning.deviceTypes";
    public static final PortScheduleExecutor INSTANCE = new PortScheduleExecutor();
    private Map<NetworkNodeBean, e> _collectors = new Hashtable<NetworkNodeBean, e>();
    private List<PortUtilAlarm> _portUtilizationAlarms;

    private PortScheduleExecutor() {
    }

    public static PortScheduleBean getSchedule() {
        GraphScheduleBean graphScheduleBean = GraphScheduleProcessor.getScheduleDataById(2);
        if (graphScheduleBean == null) {
            return null;
        }
        PortScheduleBean portScheduleBean = new PortScheduleBean();
        portScheduleBean.setSuspended(graphScheduleBean.isSuspended());
        portScheduleBean.setPeriod(graphScheduleBean.getPeriod());
        portScheduleBean.setTimeout(graphScheduleBean.getTimeout());
        portScheduleBean.setRetries(graphScheduleBean.getRetries());
        String string = ServerConfig.getProperty(PORT_WARNING_FROM, "50");
        String string2 = ServerConfig.getProperty(PORT_WARNING_TO, "80");
        String string3 = ServerConfig.getProperty(PORT_WARNING_DEVICE_TYPES, PortScheduleBean.getDefaultDeviceTypes());
        portScheduleBean.setFrom(Double.parseDouble(string));
        portScheduleBean.setTo(Double.parseDouble(string2));
        portScheduleBean.setDeviceTypes(string3);
        return portScheduleBean;
    }

    public void doSnmpSchedule(Integer n2) {
        block6: {
            block7: {
                String string = GraphScheduleExecutorProxy.b();
                if (SystemStatus.isDiscovering()) {
                    return;
                }
                PortScheduleBean portScheduleBean = PortScheduleExecutor.getSchedule();
                if (portScheduleBean == null) {
                    return;
                }
                boolean bl2 = portScheduleBean.isSuspended();
                if (bl2) {
                    _logger.info((Object)("schedule id " + n2 + " is suspended"));
                    return;
                }
                this.a();
                TopologyData topologyData = GraphDao.createData();
                if (topologyData == null || topologyData.isEmpty()) break block6;
                this.a(topologyData, portScheduleBean);
                if (!SystemStatus.isDiscovering()) break block7;
                this._portUtilizationAlarms = null;
                if (string == null) break block6;
            }
            ActionProxy.getInstance().updateGraphByPortAlarms(null, "GraphScheduleCallback", "updatePortUtilizationAlarms", new Class[]{List.class}, new Object[]{this._portUtilizationAlarms});
        }
    }

    public List<PortUtilAlarm> getPortUtilizationAlarms() {
        return this._portUtilizationAlarms;
    }

    private void a(TopologyData topologyData, PortScheduleBean portScheduleBean) {
        Set set = topologyData.getAllBeans();
        Iterator iterator = set.iterator();
        String string = GraphScheduleExecutorProxy.b();
        while (iterator.hasNext()) {
            NetworkNodeBean networkNodeBean = (NetworkNodeBean)iterator.next();
            if (networkNodeBean.isSnmpEnabled() && portScheduleBean.supportType(networkNodeBean.getClass())) {
                this.a(networkNodeBean, portScheduleBean);
            }
            if (string == null) continue;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void a(NetworkNodeBean networkNodeBean, PortScheduleBean portScheduleBean) {
        String string;
        e e10;
        block10: {
            e10 = this._collectors.get(networkNodeBean);
            string = GraphScheduleExecutorProxy.b();
            if (e10 == null) {
                e10 = this.b(networkNodeBean, portScheduleBean);
                if (e10 == null) return;
                try {
                    this._collectors.put(networkNodeBean, e10);
                    if (string == null) break block10;
                    return;
                    catch (Exception exception) {
                        throw PortScheduleExecutor.a(exception);
                    }
                }
                catch (Exception exception) {
                    throw PortScheduleExecutor.a(exception);
                }
            }
        }
        if (this._collectors == null) return;
        try {
            e10.updateData();
            this.a(networkNodeBean, e10, portScheduleBean);
            return;
        }
        catch (Exception exception) {
            NetworkInterface[] networkInterfaceArray = networkNodeBean.getInterfaces();
            int n2 = networkInterfaceArray.length;
            for (int i2 = 1; i2 < n2; ++i2) {
                EthernetInterface ethernetInterface = (EthernetInterface)networkInterfaceArray[i2];
                SnmpSession snmpSession = e10.getSession();
                snmpSession.getTarget().setHost(ethernetInterface.getIpAddress());
                try {
                    e10.updateData();
                    this.a(networkNodeBean, e10, portScheduleBean);
                    return;
                }
                catch (Exception exception2) {
                    if (string == null) continue;
                }
            }
        }
    }

    private void a(NetworkNodeBean networkNodeBean, e e10, PortScheduleBean portScheduleBean) {
        NetworkInterface[] networkInterfaceArray = networkNodeBean.getInterfaces();
        int n2 = networkInterfaceArray.length;
        String string = GraphScheduleExecutorProxy.b();
        for (int i2 = 0; i2 < n2; ++i2) {
            EthernetInterface ethernetInterface = (EthernetInterface)networkInterfaceArray[i2];
            int n3 = ethernetInterface.getIfIndex();
            if (n3 <= 0) continue;
            double d10 = e10.getBandwidthPercent(n3, ethernetInterface.getIfSpeed() * 1000000L);
            PortUtilAlarm portUtilAlarm = new PortUtilAlarm(networkNodeBean.getCustomerID(), networkNodeBean.getID(), ethernetInterface.getIpAddress(), System.currentTimeMillis());
            portUtilAlarm.setPortUtilization(d10);
            portUtilAlarm.setSeverity(portScheduleBean.getSeverity(d10));
            this.a(portUtilAlarm);
            if (string == null) continue;
        }
    }

    private synchronized void a() {
        if (this._portUtilizationAlarms != null) {
            this._portUtilizationAlarms.clear();
        }
    }

    private synchronized void a(PortUtilAlarm portUtilAlarm) {
        if (this._portUtilizationAlarms == null) {
            this._portUtilizationAlarms = new ArrayList<PortUtilAlarm>();
        }
        this._portUtilizationAlarms.add(portUtilAlarm);
    }

    private e b(NetworkNodeBean networkNodeBean, PortScheduleBean portScheduleBean) {
        SnmpSession snmpSession = SnmpUtil.createSession(networkNodeBean.getFirstIp(), networkNodeBean.getReadCommunity(), portScheduleBean.getTimeout());
        snmpSession.setRetries(portScheduleBean.getRetries());
        try {
            e e10 = new e(snmpSession);
            if (2 == e10.getErrorCode()) {
                return this.c(networkNodeBean, portScheduleBean);
            }
            return e10;
        }
        catch (Exception exception) {
            return this.c(networkNodeBean, portScheduleBean);
        }
    }

    private e c(NetworkNodeBean networkNodeBean, PortScheduleBean portScheduleBean) {
        NetworkInterface[] networkInterfaceArray = networkNodeBean.getInterfaces();
        String string = GraphScheduleExecutorProxy.b();
        int n2 = networkInterfaceArray.length;
        for (int i2 = 1; i2 < n2; ++i2) {
            EthernetInterface ethernetInterface = (EthernetInterface)networkInterfaceArray[i2];
            SnmpSession snmpSession = SnmpUtil.createSession(ethernetInterface.getIpAddress(), networkNodeBean.getReadCommunity(), portScheduleBean.getTimeout());
            snmpSession.setRetries(portScheduleBean.getRetries());
            try {
                e e10 = new e(snmpSession);
                if (2 == e10.getErrorCode()) {
                    return null;
                }
                return e10;
            }
            catch (TimeoutException timeoutException) {
                _logger.error((Object)("Query timed out:" + portScheduleBean));
                continue;
            }
            catch (Exception exception) {
                _logger.error((Object)"", (Throwable)exception);
            }
            if (string == null) continue;
        }
        return null;
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

