/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.performance;

import com.openapi.performance.IExecutorParameter;
import com.openapi.performance.IQueryExecutor;
import com.openapi.performance.ResultTypeValue;
import com.sysuptime.common.performance.QueryParameter;
import com.sysuptime.common.performance.ResultValue;
import com.sysuptime.common.util.StringUtil;
import com.sysuptime.server.performance.AbstractExecutor;
import com.sysuptime.server.performance.ExecutorHelper;
import com.sysuptime.server.performance.PerformanceServerUtil;
import com.sysuptime.server.performance.QueryFactory;
import com.sysuptime.server.util.ServerBundle;
import java.util.Hashtable;
import java.util.List;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.apache.log4j.Logger;

public class DnsExecutor
extends AbstractExecutor
implements IQueryExecutor {
    protected static Logger _logger = Logger.getLogger((String)DnsExecutor.class.getName());
    public static final long DNS_SERVER_HOST_NOT_FOUND = ServerBundle.getParsedMessage("DNS_SERVER_HOST_NOT_FOUND");
    public static final long RESOLVING_HOST_NOT_MATCH = ServerBundle.getParsedMessage("RESOLVING_HOST_NOT_MATCH");
    public static int DNS_RTT;
    protected static int[] RESULT_TYPES_1;

    @Override
    public ResultValue[] startExecuting(IExecutorParameter iExecutorParameter) {
        String string = iExecutorParameter.getHostName();
        QueryParameter queryParameter = iExecutorParameter.getQueryParameter();
        List<ResultTypeValue> list = iExecutorParameter.getResultTypeValues();
        int[] nArray = PerformanceServerUtil.getResultTypes(list);
        try {
            if (PerformanceServerUtil.isOurCategory(nArray, RESULT_TYPES_1)) {
                return new ResultValue[]{this.a(string, queryParameter.getList())};
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DnsExecutor.a(illegalArgumentException);
        }
        throw new IllegalArgumentException("No such all result types " + nArray + " on ping");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultValue a(String string, List list) {
        ResultValue resultValue = QueryFactory.createResultValueObject();
        int n2 = ExecutorHelper.b();
        resultValue.setResultType(DNS_RTT);
        Context context = null;
        try {
            long l2;
            block30: {
                boolean bl2;
                Object object;
                block31: {
                    Attribute attribute;
                    String string2;
                    block29: {
                        l2 = System.currentTimeMillis();
                        Hashtable<String, String> hashtable = new Hashtable<String, String>();
                        hashtable.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
                        StringBuffer stringBuffer = new StringBuffer("dns://");
                        stringBuffer.append(string);
                        stringBuffer.append(":");
                        Object e10 = list.get(1);
                        stringBuffer.append(e10);
                        stringBuffer.append("/");
                        hashtable.put("java.naming.provider.url", stringBuffer.toString());
                        String string3 = list.get(2).toString();
                        hashtable.put("com.sun.jndi.dns.timeout.initial", string3);
                        String string4 = list.get(3).toString();
                        hashtable.put("com.sun.jndi.dns.timeout.retries", string4);
                        context = new InitialDirContext(hashtable);
                        String string5 = list.get(0).toString();
                        Attributes attributes = context.getAttributes(string5, new String[]{"A"});
                        string2 = null;
                        if (attributes != null) {
                            attribute = attributes.get("A");
                            try {
                                if (attribute == null || attribute.size() <= 0) break block29;
                            }
                            catch (Exception exception) {
                                throw DnsExecutor.a(exception);
                            }
                            string2 = attribute.get(0).toString();
                        }
                    }
                    attribute = list.get(4);
                    try {
                        if (attribute == null || attribute.toString().length() == 0) break block30;
                    }
                    catch (Exception exception) {
                        throw DnsExecutor.a(exception);
                    }
                    boolean bl3 = false;
                    if (string2 != null) {
                        object = StringUtil.split2(attribute.toString(), "; ");
                        int n3 = ((String[])object).length;
                        for (int i2 = 0; i2 < n3; ++i2) {
                            try {
                                bl2 = object[i2].equals(string2);
                                if (n2 == 0) break block31;
                                if (!bl2) continue;
                            }
                            catch (Exception exception) {
                                throw DnsExecutor.a(exception);
                            }
                            bl3 = true;
                            if (n2 != 0) continue;
                        }
                    }
                    bl2 = bl3;
                }
                if (!bl2) {
                    resultValue.setResultState("E");
                    resultValue.setValue(RESOLVING_HOST_NOT_MATCH);
                    object = resultValue;
                    return object;
                }
            }
            long l3 = System.currentTimeMillis();
            resultValue.setResultState("N");
            resultValue.setValue(l3 - l2);
        }
        catch (CommunicationException communicationException) {
            _logger.warn((Object)("Communication failed:" + communicationException));
            this._errorbuf.append(communicationException);
            resultValue.setValue(DNS_SERVER_HOST_NOT_FOUND);
            resultValue.setResultState("E");
        }
        catch (Exception exception) {
            _logger.warn((Object)"Parsed domain name", (Throwable)exception);
            this._errorbuf.append(exception);
            resultValue.setValue(DNS_SERVER_HOST_NOT_FOUND);
            resultValue.setResultState("E");
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (Exception exception) {}
            }
        }
        return resultValue;
    }

    static {
        try {
            DNS_RTT = ExecutorHelper.getId("DNS_RTT");
            RESULT_TYPES_1 = new int[]{DNS_RTT};
        }
        catch (Exception exception) {
            _logger.error((Object)exception);
        }
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

