/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.performance;

import com.sysuptime.common.performance.Monitor;
import com.sysuptime.common.util.TextProcessor;
import com.sysuptime.server.performance.ProtocolQueryReader;
import com.sysuptime.server.util.DefaultConnection;
import com.sysuptime.server.util.SqlUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class ProtocolQueryWriter {
    private static final Logger _logger = Logger.getLogger((String)ProtocolQueryWriter.class.getName());

    private ProtocolQueryWriter() {
    }

    public static void storeProtocolQueryData(Connection connection, Monitor monitor) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            String string = "INSERT INTO PM_PROTOCOL_QUERY (schedule_id_c, target_type_c, parameters_c, protocol_type_c, is_saved_c, actions_c ) VALUES(?,?,?,?,?,?)";
            preparedStatement = connection.prepareStatement(string);
            ProtocolQueryWriter.a(preparedStatement, monitor);
            preparedStatement.executeUpdate();
            ProtocolQueryReader.updateCache(monitor.getScheduleId(), monitor.getProtocolType());
        }
        catch (Exception exception) {
            try {
                _logger.error((Object)"", (Throwable)exception);
                throw new SQLException("Store pm_protocol_query data " + exception.toString());
            }
            catch (Throwable throwable) {
                DefaultConnection.closeStatement(preparedStatement);
                throw throwable;
            }
        }
        DefaultConnection.closeStatement(preparedStatement);
    }

    private static void a(PreparedStatement preparedStatement, Monitor monitor) throws Exception {
        int n2 = monitor.getScheduleId();
        preparedStatement.setInt(1, n2);
        String string = monitor.getTargetType().toText();
        preparedStatement.setString(2, string);
        String string2 = monitor.getQueryParameters().toText();
        preparedStatement.setString(3, TextProcessor.encodeToBase64Format(string2, "aBCde1235EaaaaNbbbbb"));
        short s2 = monitor.getProtocolType();
        preparedStatement.setShort(4, s2);
        boolean bl2 = monitor.isSaved();
        SqlUtil.setBoolean(preparedStatement, 5, bl2);
        String string3 = monitor.getActions();
        if (string3 != null) {
            string3 = TextProcessor.encodeToBase64Format(string3, "aBCde1235EaaaaNbbbbb");
        }
        preparedStatement.setString(6, string3);
    }
}

