/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.performance;

import com.jcraft.jsch.JSchException;
import com.openapi.performance.IExecutorParameter;
import com.openapi.performance.IQueryExecutor;
import com.openapi.performance.ResultTypeValue;
import com.sysuptime.common.performance.QueryParameter;
import com.sysuptime.common.performance.RemoteHost;
import com.sysuptime.common.performance.ResultValue;
import com.sysuptime.common.util.SshConnection;
import com.sysuptime.common.util.SshConnection$AuthenticationException;
import com.sysuptime.server.performance.AbstractExecutor;
import com.sysuptime.server.performance.ExecutorHelper;
import com.sysuptime.server.performance.OpenConnectionsCache;
import com.sysuptime.server.performance.PerformanceServerUtil;
import com.sysuptime.server.performance.QueryFactory;
import com.sysuptime.server.performance.RemoteHostProcessor;
import com.sysuptime.server.util.ServerBundle;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class SshExecutor
extends AbstractExecutor
implements IQueryExecutor {
    protected static Logger _logger = Logger.getLogger((String)SshExecutor.class.getName());
    private static final long SSH_AUTH_FAIL = ServerBundle.getParsedMessage("SSH_AUTH_FAIL");
    private static final long SSH_IO_ERROR = ServerBundle.getParsedMessage("SSH_IO_ERROR");
    private static final long SSH_UNKNOWN_ERROR = ServerBundle.getParsedMessage("SSH_UNKNOWN_ERROR");
    private static final long SSH_ILLEGAL_COMMAND = ServerBundle.getParsedMessage("SSH_ILLEGAL_COMMAND");
    private static int SSH_RESPONSE_TIME;
    private static int SSH_CONTENT_MATCH;
    protected static int[] RESULT_TYPES_1;

    @Override
    public ResultValue[] startExecuting(IExecutorParameter iExecutorParameter) {
        QueryParameter queryParameter = iExecutorParameter.getQueryParameter();
        List<ResultTypeValue> list = iExecutorParameter.getResultTypeValues();
        int[] nArray = PerformanceServerUtil.getResultTypes(list);
        if (PerformanceServerUtil.isOurCategory(nArray, RESULT_TYPES_1)) {
            List list2 = queryParameter.getList();
            long l2 = Long.parseLong(list2.get(0).toString());
            String string = list2.get(1).toString();
            int n2 = Integer.parseInt(list2.get(2).toString());
            return this.a(l2, string, n2, nArray, list, iExecutorParameter.getMonitorId());
        }
        throw new IllegalArgumentException("No such result types " + Arrays.toString(nArray));
    }

    private ResultValue[] a(long l2, String string, int n2, int[] nArray, List list, int n3) {
        HashMap<Integer, ResultValue> hashMap;
        block14: {
            ResultValue resultValue;
            block16: {
                hashMap = new HashMap<Integer, ResultValue>();
                RemoteHost remoteHost = null;
                int n4 = ExecutorHelper.c();
                try {
                    remoteHost = RemoteHostProcessor.getRemoteHostByHostId(l2);
                }
                catch (Exception exception) {
                    _logger.error((Object)exception);
                }
                try {
                    if (remoteHost == null) {
                        throw new IllegalArgumentException("SSH remote host is not found, please validate the pm_remote_host table");
                    }
                }
                catch (Exception exception) {
                    throw SshExecutor.a(exception);
                }
                long l3 = System.currentTimeMillis();
                resultValue = this.getSSHResult(n2, remoteHost, string.trim(), n3);
                try {
                    block15: {
                        try {
                            try {
                                block13: {
                                    try {
                                        if (!resultValue.isNormal()) break block13;
                                        PerformanceServerUtil.putResults(hashMap, (String)resultValue.getValue(), list, SSH_CONTENT_MATCH);
                                        hashMap.put(SSH_RESPONSE_TIME, QueryFactory.createResultValueObject(SSH_RESPONSE_TIME, "N", System.currentTimeMillis() - l3));
                                        if (n4 == 0) break block14;
                                    }
                                    catch (Exception exception) {
                                        throw SshExecutor.a(exception);
                                    }
                                }
                                if (!resultValue.isDynamicError()) break block15;
                            }
                            catch (Exception exception) {
                                throw SshExecutor.a(exception);
                            }
                            hashMap.put(SSH_RESPONSE_TIME, QueryFactory.createResultValueObject(SSH_RESPONSE_TIME, "E", SSH_UNKNOWN_ERROR, resultValue.getErrorUnknownMessage(), true));
                            if (n4 == 0) break block16;
                        }
                        catch (Exception exception) {
                            throw SshExecutor.a(exception);
                        }
                    }
                    hashMap.put(SSH_RESPONSE_TIME, QueryFactory.createResultValueObject(SSH_RESPONSE_TIME, resultValue.getResultState(), resultValue.getValue()));
                }
                catch (Exception exception) {
                    throw SshExecutor.a(exception);
                }
            }
            resultValue.setResultType(SSH_CONTENT_MATCH);
            hashMap.put(SSH_CONTENT_MATCH, resultValue);
        }
        return PerformanceServerUtil.getResultValues(nArray, hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public ResultValue getSSHResult(int var1_1, RemoteHost var2_2, String var3_3, int var4_4) {
        block22: {
            var6_5 = QueryFactory.createResultValueObject();
            var7_6 = null;
            var5_7 = ExecutorHelper.c();
            try {
                block23: {
                    block21: {
                        try {
                            var7_6 = (SshConnection)OpenConnectionsCache.getConnection(var2_2, var1_1, var4_4);
                        }
                        catch (SshConnection$AuthenticationException var8_8) {
                            SshExecutor._logger.warn((Object)"SSH authentication failed.");
                            var6_5.setResultState("E");
                            var6_5.setValue(SshExecutor.SSH_AUTH_FAIL);
                            var9_13 = var6_5;
                            OpenConnectionsCache.removeConnection(var2_2, var4_4, false);
                            return var9_13;
                        }
                        var8_9 = var7_6.execute(var3_3);
                        var9_14 = var7_6.getStdoutRet();
                        var10_15 = var7_6.getStderrRet();
                        try {
                            if (var8_9 == 0) {
                                var6_5.setResultState("N");
                                if (var9_14.length() <= 0) break block21;
                            }
                            ** GOTO lbl32
                        }
                        catch (SshConnection$AuthenticationException v0) {
                            throw SshExecutor.a(v0);
                        }
                        var9_14 = PerformanceServerUtil.removeTerminalEmulationCharacters(var9_14);
                    }
                    var6_5.setValue(var9_14);
                    if (var5_7 == 0) break block22;
lbl32:
                    // 3 sources

                    if (var8_9 != 127) ** GOTO lbl44
                    break block23;
                    catch (SshConnection$AuthenticationException v1) {
                        throw SshExecutor.a(v1);
                    }
                }
                try {
                    block24: {
                        var6_5.setResultState("E");
                        var6_5.setValue(SshExecutor.SSH_ILLEGAL_COMMAND);
                        if (var5_7 == 0) break block22;
                        break block24;
                        catch (SshConnection$AuthenticationException v2) {
                            throw SshExecutor.a(v2);
                        }
                    }
                    var6_5.setResultState("E");
                    var6_5.setValue(SshExecutor.SSH_UNKNOWN_ERROR);
                    var6_5.setErrorUnknownMessage(var10_15);
                    var6_5.setDynamicError(true);
                }
                catch (SshConnection$AuthenticationException v3) {
                    throw SshExecutor.a(v3);
                }
            }
            catch (IOException var8_10) {
                SshExecutor._logger.warn((Object)"Get ssh result error occurred");
                this._errorbuf.append(var8_10);
                var6_5.setResultState("E");
                var6_5.setValue(SshExecutor.SSH_IO_ERROR);
            }
            catch (JSchException var8_11) {
                SshExecutor._logger.warn((Object)"Can't connect to the ssh server");
                this._errorbuf.append((Object)var8_11);
                var6_5.setResultState("E");
                var6_5.setValue(SshExecutor.SSH_IO_ERROR);
            }
            catch (Exception var8_12) {
                SshExecutor._logger.warn((Object)"Get ssh result error occurred", (Throwable)var8_12);
                this._errorbuf.append(var8_12);
                var6_5.setResultState("E");
                var6_5.setValue(SshExecutor.SSH_UNKNOWN_ERROR);
            }
            finally {
                OpenConnectionsCache.removeConnection(var2_2, var4_4, false);
            }
        }
        return var6_5;
    }

    static {
        try {
            SSH_RESPONSE_TIME = ExecutorHelper.getId("SSH_RESPONSE_TIME");
            SSH_CONTENT_MATCH = ExecutorHelper.getId("SSH_CONTENT_MATCH");
            RESULT_TYPES_1 = new int[]{SSH_RESPONSE_TIME, SSH_CONTENT_MATCH};
        }
        catch (Exception exception) {
            _logger.error((Object)exception);
        }
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

