/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.util;

import com.ireasoning.protocol.snmp.MibUtil;
import com.ireasoning.protocol.snmp.SnmpOID;
import com.ireasoning.protocol.snmp.SnmpPdu;
import com.ireasoning.protocol.snmp.SnmpSession;
import com.ireasoning.protocol.snmp.SnmpVarBind;
import com.ireasoning.protocol.snmp.m;
import com.ireasoning.util.bs;
import com.sysuptime.common.discovery.ReadCommunity;
import com.sysuptime.common.discovery.V3Params;
import com.sysuptime.common.util.AppUtil;
import com.sysuptime.server.util.MBeanUtil;
import java.io.IOException;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class SnmpUtil
implements Serializable {
    private static final Logger _logger = Logger.getLogger((String)SnmpUtil.class.getName());
    static boolean _isMIB2Loaded = false;

    public static void reloadMib2() {
        _isMIB2Loaded = false;
        SnmpUtil.loadMib2();
    }

    public static void loadMib2() {
        try {
            if (_isMIB2Loaded) {
                return;
            }
        }
        catch (IOException iOException) {
            throw SnmpUtil.a(iOException);
        }
        _isMIB2Loaded = true;
        try {
            String string = AppUtil.getAppHomeDirectory();
            _logger.info((Object)("To load MIBs from :" + string));
            MibUtil.loadMib(string + "/mibs/RFC1213-MIB");
            MibUtil.loadMib(string + "/mibs/HOST-RESOURCES-MIB");
            _logger.info((Object)"Loaded MIB-II and host resources MIB");
        }
        catch (IOException iOException) {
            _logger.error((Object)"MIB-II not found.");
        }
        catch (bs bs2) {
            _logger.error((Object)"Can't parse MIB-II");
        }
    }

    public static String[] get(SnmpOID[] snmpOIDArray, SnmpSession snmpSession) throws IOException {
        Object[] objectArray;
        String string;
        block17: {
            string = MBeanUtil.b();
            try {
                try {
                    if (snmpOIDArray != null && snmpOIDArray.length >= 1) break block17;
                }
                catch (IOException iOException) {
                    throw SnmpUtil.a(iOException);
                }
                return null;
            }
            catch (IOException iOException) {
                throw SnmpUtil.a(iOException);
            }
        }
        SnmpOID[] snmpOIDArray2 = new SnmpOID[snmpOIDArray.length];
        for (int i2 = 0; i2 < snmpOIDArray.length; ++i2) {
            block18: {
                objectArray = snmpOIDArray[i2].getValue();
                try {
                    try {
                        if (objectArray == null) continue;
                        if (objectArray.length >= 1) break block18;
                    }
                    catch (IOException iOException) {
                        throw SnmpUtil.a(iOException);
                    }
                    if (string != null) continue;
                }
                catch (IOException iOException) {
                    throw SnmpUtil.a(iOException);
                }
            }
            int n2 = objectArray[objectArray.length - 1];
            try {
                snmpOIDArray2[i2] = snmpOIDArray[i2].suboid(0, objectArray.length - 1);
                if (n2 == 0) continue;
                snmpOIDArray2[i2].append(new int[]{n2 - 1, Integer.MAX_VALUE});
                continue;
            }
            catch (IOException iOException) {
                throw SnmpUtil.a(iOException);
            }
        }
        SnmpPdu snmpPdu = snmpSession.snmpGetNextRequest(snmpOIDArray2);
        objectArray = new String[snmpOIDArray.length];
        if (snmpPdu.getErrorStatus() == 0) {
            SnmpVarBind[] snmpVarBindArray = snmpPdu.getVarBinds();
            for (int i3 = 0; i3 < snmpVarBindArray.length; ++i3) {
                try {
                    try {
                        if (!snmpVarBindArray[i3].getName().equals(snmpOIDArray[i3]) || snmpVarBindArray[i3].getValue() == null) continue;
                    }
                    catch (IOException iOException) {
                        throw SnmpUtil.a(iOException);
                    }
                    objectArray[i3] = (int)snmpVarBindArray[i3].getValue().toString();
                    continue;
                }
                catch (IOException iOException) {
                    throw SnmpUtil.a(iOException);
                }
            }
        }
        return objectArray;
    }

    public static String[] get(String[] stringArray, SnmpSession snmpSession) throws IOException {
        SnmpOID[] snmpOIDArray;
        block9: {
            String string;
            block8: {
                string = MBeanUtil.b();
                try {
                    try {
                        if (stringArray != null && stringArray.length >= 1) break block8;
                    }
                    catch (IOException iOException) {
                        throw SnmpUtil.a(iOException);
                    }
                    return null;
                }
                catch (IOException iOException) {
                    throw SnmpUtil.a(iOException);
                }
            }
            SnmpOID[] snmpOIDArray2 = new SnmpOID[stringArray.length];
            for (int i2 = 0; i2 < snmpOIDArray2.length; ++i2) {
                try {
                    snmpOIDArray = snmpOIDArray2;
                    if (string != null) {
                        snmpOIDArray[i2] = new SnmpOID(stringArray[i2]);
                        if (string != null) continue;
                        break;
                    }
                    break block9;
                }
                catch (IOException iOException) {
                    throw SnmpUtil.a(iOException);
                }
            }
            snmpOIDArray = snmpOIDArray2;
        }
        return SnmpUtil.get(snmpOIDArray, snmpSession);
    }

    public static SnmpSession createSession(String string, ReadCommunity readCommunity, int n2) {
        SnmpSession snmpSession = null;
        m m2 = new m(string, readCommunity.getPort());
        try {
            snmpSession = new SnmpSession(m2);
            snmpSession.setRetries(0);
            snmpSession.setTimeout(n2);
            ((m)snmpSession.getTarget()).setReadCommunity(readCommunity.getCommunity());
            snmpSession.setVersion(readCommunity.getVersion());
            if (readCommunity.getVersion() == 3) {
                V3Params v3Params = readCommunity.getV3Params();
                snmpSession.setV3Params(v3Params.getUserName(), v3Params.getAuthProtocol(), v3Params.getAuthPassword(), v3Params.getPrivProtocol(), v3Params.getPrivPassword());
            }
        }
        catch (IOException iOException) {
            _logger.error((Object)"", (Throwable)iOException);
        }
        return snmpSession;
    }

    private static IOException a(IOException iOException) {
        return iOException;
    }
}

