/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.openide.awt.JPopupMenuUtils;
import org.openide.util.Utilities;

public class JInlineMenu
extends JMenuItem {
    static final long serialVersionUID = -2310488127953523571L;
    private static final Icon BLANK_ICON = new ImageIcon(Utilities.loadImage("org/openide/resources/actions/empty.gif"));
    private JSeparator north = new JSeparator();
    private JSeparator south = new JSeparator();
    private JComponent[] items = new JComponent[0];
    boolean upToDate;
    private List addedItems;

    public JInlineMenu() {
        this.setEnabled(false);
        this.setVisible(false);
        this.upToDate = true;
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public void setMenuItems(JMenuItem[] newItems) {
        JComponent[] local = new JComponent[newItems.length];
        for (int i = 0; i < newItems.length; ++i) {
            local[i] = newItems[i] != null ? newItems[i] : new JSeparator();
        }
        this.items = local;
        this.upToDate = false;
        this.alignItems();
        Container parent = this.getParent();
        while (parent instanceof JInlineMenu) {
            ((JInlineMenu)parent).upToDate = false;
            parent = parent.getParent();
        }
        if (this.isShowing()) {
            SwingUtilities.invokeLater(new Updater());
        }
    }

    public void addNotify() {
        super.addNotify();
        if (!this.upToDate) {
            SwingUtilities.invokeLater(new Updater());
        }
    }

    private void alignItems() {
        boolean shouldAlign;
        boolean bl = shouldAlign = this.getIcon() != null;
        if (!shouldAlign) {
            for (int i = 0; i < this.items.length; ++i) {
                if (!(this.items[i] instanceof JMenuItem) || ((JMenuItem)this.items[i]).getIcon() == null) continue;
                shouldAlign = true;
                break;
            }
        }
        if (!shouldAlign) {
            return;
        }
        JMenuItem curItem = null;
        for (int i = 0; i < this.items.length; ++i) {
            if (!(this.items[i] instanceof JMenuItem) || (curItem = (JMenuItem)this.items[i]).getIcon() != null) continue;
            curItem.setIcon(BLANK_ICON);
        }
    }

    static void prepareItemsInContainer(Container c) {
        Component[] comps = c.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof JInlineMenu)) continue;
            ((JInlineMenu)comps[i]).doUpdate();
        }
    }

    private void doUpdate() {
        Object prop = this.getClientProperty("hack.preShowUpdater");
        if (prop instanceof Runnable) {
            ((Runnable)prop).run();
        }
        this.updateContents();
    }

    private void updateContents() {
        Container parent = this.getParent();
        if (!this.upToDate && parent != null) {
            if (!(parent instanceof JInlineMenu)) {
                for (int i = 0; i < this.items.length; ++i) {
                    Object prop = this.items[i].getClientProperty("hack.preShowUpdater");
                    if (!(prop instanceof Runnable)) continue;
                    ((Runnable)prop).run();
                }
                this.removeItems();
                this.addItems();
            }
            this.upToDate = true;
        }
    }

    private void removeItems() {
        JComponent m = (JComponent)this.getParent();
        if (m == null) {
            return;
        }
        if (m instanceof JInlineMenu) {
            ((JInlineMenu)m).removeItems();
            return;
        }
        if (this.addedItems != null) {
            Iterator it = this.addedItems.iterator();
            while (it.hasNext()) {
                m.remove((Component)it.next());
            }
        }
        m.remove(this.north);
        m.remove(this.south);
        this.addedItems = null;
    }

    private void getAllInlineItems(List its) {
        for (int i = 0; i < this.items.length; ++i) {
            JComponent item = this.items[i];
            if (item instanceof JInlineMenu) {
                ((JInlineMenu)item).getAllInlineItems(its);
                continue;
            }
            its.add(item);
        }
    }

    private static int findIndex(Object of, Object[] arr) {
        int menuLength = arr.length;
        for (int i = 0; i < menuLength; ++i) {
            if (of != arr[i]) continue;
            return i;
        }
        return -1;
    }

    void addItems() {
        JComponent m = (JComponent)this.getParent();
        if (m == null) {
            return;
        }
        boolean usedToBeContained = false;
        if (m instanceof JPopupMenu) {
            usedToBeContained = JPopupMenuUtils.isPopupContained((JPopupMenu)m);
        }
        ArrayList its = new ArrayList(this.items.length);
        this.getAllInlineItems(its);
        JComponent[] items = its.toArray(new JComponent[its.size()]);
        this.addedItems = its;
        Object[] array = m.getComponents();
        int menuPos = JInlineMenu.findIndex(this, array);
        if (menuPos == -1) {
            return;
        }
        if (menuPos > 0 && items.length > 0 && array.length > 0 && !(array[menuPos - 1] instanceof JSeparator) && !(array[menuPos - 1] instanceof JInlineMenu)) {
            m.add((Component)this.north, menuPos++);
            array = m.getComponents();
        }
        if (menuPos < array.length - 1) {
            if (items.length > 0 && !(array[menuPos + 1] instanceof JPopupMenu.Separator) && !(array[menuPos + 1] instanceof JSeparator)) {
                m.add((Component)this.south, menuPos + 1);
            } else if (items.length == 0 && (array[menuPos + 1] instanceof JPopupMenu.Separator || array[menuPos + 1] instanceof JSeparator)) {
                m.remove(menuPos + 1);
                array = m.getComponents();
            }
        }
        if (menuPos > array.length) {
            int menuLength = items.length;
            for (int i = 0; i < menuLength; ++i) {
                m.add(items[i]);
            }
        } else {
            int menuLength = items.length;
            for (int i = 0; i < menuLength; ++i) {
                m.add((Component)items[i], ++menuPos);
                if (!(items[i] instanceof JInlineMenu)) continue;
                JInlineMenu him = (JInlineMenu)items[i];
                menuPos += him.items.length;
            }
        }
        if (m instanceof JPopupMenu && m.isShowing()) {
            JPopupMenuUtils.dynamicChange((JPopupMenu)m, usedToBeContained);
        } else {
            m.invalidate();
        }
    }

    private class Updater
    implements Runnable {
        Updater() {
        }

        public void run() {
            JInlineMenu.this.updateContents();
        }
    }
}

