/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.util.Enumeration;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

final class SheetColumnModel
implements TableColumnModel {
    TableColumn namesColumn;
    TableColumn valuesColumn;
    static final Object NAMES_IDENTIFIER = "names";
    static final Object VALUES_IDENTIFIER = "values";
    ListSelectionModel lsm = new DefaultListSelectionModel();

    public SheetColumnModel() {
        this.namesColumn = new TableColumn(0);
        this.namesColumn.setIdentifier(NAMES_IDENTIFIER);
        this.valuesColumn = new TableColumn(1);
        this.valuesColumn.setIdentifier(VALUES_IDENTIFIER);
        this.namesColumn.setMinWidth(60);
        this.valuesColumn.setMinWidth(30);
    }

    public void addColumn(TableColumn aColumn) {
        throw new UnsupportedOperationException("Adding columns not supported");
    }

    public void addColumnModelListener(TableColumnModelListener x) {
    }

    public TableColumn getColumn(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.namesColumn;
            }
            case 1: {
                return this.valuesColumn;
            }
        }
        throw new IllegalArgumentException("Property sheet only has 2 columns - " + Integer.toString(columnIndex));
    }

    public int getColumnCount() {
        return 2;
    }

    public int getColumnIndex(Object columnIdentifier) {
        if (columnIdentifier instanceof String) {
            if (columnIdentifier.equals(NAMES_IDENTIFIER)) {
                return 0;
            }
            if (columnIdentifier.equals(VALUES_IDENTIFIER)) {
                return 1;
            }
        }
        throw new IllegalArgumentException("Illegal value: " + columnIdentifier);
    }

    public int getColumnIndexAtX(int xPosition) {
        int width0 = this.namesColumn.getWidth();
        if (xPosition < width0) {
            return 0;
        }
        if (xPosition < width0 + this.valuesColumn.getWidth()) {
            return 1;
        }
        return -1;
    }

    public int getColumnMargin() {
        return 1;
    }

    public boolean getColumnSelectionAllowed() {
        return false;
    }

    public Enumeration getColumns() {
        return new Enumeration(){
            private boolean done = false;
            private boolean doneOne = false;

            public boolean hasMoreElements() {
                return !this.done;
            }

            public Object nextElement() {
                if (this.done) {
                    return null;
                }
                if (this.doneOne) {
                    this.done = true;
                    return SheetColumnModel.this.valuesColumn;
                }
                this.doneOne = true;
                return SheetColumnModel.this.namesColumn;
            }
        };
    }

    public int getSelectedColumnCount() {
        return 0;
    }

    public int[] getSelectedColumns() {
        return new int[0];
    }

    public ListSelectionModel getSelectionModel() {
        return this.lsm;
    }

    public int getTotalColumnWidth() {
        return this.namesColumn.getWidth() + this.valuesColumn.getWidth();
    }

    public void moveColumn(int columnIndex, int newIndex) {
    }

    public void removeColumn(TableColumn column) {
        throw new UnsupportedOperationException("Deleting columns not supported");
    }

    public void removeColumnModelListener(TableColumnModelListener x) {
    }

    public void setColumnMargin(int newMargin) {
    }

    public void setColumnSelectionAllowed(boolean flag) {
    }

    public void setSelectionModel(ListSelectionModel newModel) {
    }
}

