/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.actions;

import java.beans.PropertyChangeEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeOp;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.Mutex;
import org.openide.util.actions.NodeAction;

public abstract class CookieAction
extends NodeAction {
    private static final String PROP_COOKIES = "cookies";
    public static final int MODE_ONE = 1;
    public static final int MODE_SOME = 2;
    public static final int MODE_ALL = 4;
    public static final int MODE_EXACTLY_ONE = 8;
    public static final int MODE_ANY = 7;
    private static final long serialVersionUID = 6031319415908298424L;
    private CookiesChangeListener listener = new CookiesChangeListener(this);

    protected abstract int mode();

    protected abstract Class[] cookieClasses();

    private Class[] getCookies() {
        Class[] ret = (Class[])this.getProperty(PROP_COOKIES);
        if (ret != null) {
            return ret;
        }
        ret = this.cookieClasses();
        this.putProperty(PROP_COOKIES, ret);
        return ret;
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes.length == 0) {
            return false;
        }
        this.listener.setNodes(activatedNodes);
        return this.doEnable(activatedNodes);
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new CookieDelegateAction(this, actionContext);
    }

    boolean doEnable(Node[] activatedNodes) {
        int supported = this.resolveSupported(activatedNodes);
        if (supported == 0) {
            return false;
        }
        int mode = this.mode();
        return (mode & 1) != 0 || (mode & 4) != 0 && supported == activatedNodes.length || (mode & 8) != 0 && activatedNodes.length == 1 || (mode & 2) != 0 && supported < activatedNodes.length;
    }

    private int resolveSupported(Node[] activatedNodes) {
        int total = activatedNodes.length;
        int ret = 0;
        Class[] cookies = this.getCookies();
        block0: for (int i = 0; i < total; ++i) {
            for (int j = 0; j < cookies.length; ++j) {
                if (activatedNodes[i].getLookup().lookupItem(new Lookup.Template(cookies[j])) == null) continue;
                ++ret;
                continue block0;
            }
        }
        return ret;
    }

    static final class CookieDelegateAction
    extends NodeAction.DelegateAction
    implements NodeListener,
    Runnable {
        private NodeListener listener = NodeOp.weakNodeListener(this, null);
        private List nodes;

        public CookieDelegateAction(CookieAction a, Lookup actionContext) {
            super(a, actionContext);
            this.setNodes(this.nodes());
        }

        public void resultChanged(LookupEvent ev) {
            this.setNodes(this.nodes());
            this.superResultChanged(ev);
        }

        private void superResultChanged(LookupEvent ev) {
            super.resultChanged(ev);
        }

        public void childrenAdded(NodeMemberEvent ev) {
        }

        public void childrenRemoved(NodeMemberEvent ev) {
        }

        public void childrenReordered(NodeReorderEvent ev) {
        }

        public void nodeDestroyed(NodeEvent ev) {
        }

        public void propertyChange(PropertyChangeEvent ev) {
            if (!"cookie".equals(ev.getPropertyName())) {
                return;
            }
            Mutex.EVENT.readAccess(this);
        }

        public void run() {
            this.superResultChanged(null);
        }

        private void setNodes(Node[] newNodes) {
            this.detachListeners(this.nodes);
            if (newNodes != null) {
                this.nodes = new ArrayList(newNodes.length);
                for (int i = 0; i < newNodes.length; ++i) {
                    this.nodes.add(new WeakReference<Node>(newNodes[i]));
                }
            }
            this.attachListeners(this.nodes);
        }

        private void detachListeners(List nodes) {
            if (nodes != null) {
                Iterator it = nodes.iterator();
                while (it.hasNext()) {
                    Node node = (Node)((Reference)it.next()).get();
                    if (node == null) continue;
                    node.removeNodeListener(this.listener);
                }
            }
        }

        private void attachListeners(List nodes) {
            if (nodes != null) {
                Iterator it = nodes.iterator();
                while (it.hasNext()) {
                    Node node = (Node)((Reference)it.next()).get();
                    if (node == null) continue;
                    node.addNodeListener(this.listener);
                }
            }
        }
    }

    private static final class CookiesChangeListener
    extends NodeAdapter {
        private List nodes;
        private Reference action;

        public CookiesChangeListener(CookieAction a) {
            this.action = new WeakReference<CookieAction>(a);
        }

        void setNodes(Node[] newNodes) {
            List nodes2 = this.nodes;
            if (nodes2 != null) {
                this.detachListeners(nodes2);
            }
            this.nodes = null;
            if (newNodes != null) {
                this.nodes = new ArrayList(newNodes.length);
                for (int i = 0; i < newNodes.length; ++i) {
                    this.nodes.add(new WeakReference<Node>(newNodes[i]));
                }
                this.attachListeners(this.nodes);
            }
        }

        void detachListeners(List nodes) {
            Iterator it = nodes.iterator();
            while (it.hasNext()) {
                Node node = (Node)((Reference)it.next()).get();
                if (node == null) continue;
                node.removeNodeListener(this);
            }
        }

        void attachListeners(List nodes) {
            Iterator it = nodes.iterator();
            while (it.hasNext()) {
                Node node = (Node)((Reference)it.next()).get();
                if (node == null) continue;
                node.addNodeListener(this);
            }
        }

        public void propertyChange(PropertyChangeEvent ev) {
            if (!"cookie".equals(ev.getPropertyName())) {
                return;
            }
            CookieAction a = (CookieAction)this.action.get();
            if (a == null) {
                return;
            }
            List _nodes = this.nodes;
            if (_nodes != null) {
                ArrayList<Node> nonNullNodes = new ArrayList<Node>(_nodes.size());
                Iterator it = _nodes.iterator();
                while (it.hasNext()) {
                    Node node = (Node)((Reference)it.next()).get();
                    if (node != null) {
                        nonNullNodes.add(node);
                        continue;
                    }
                    return;
                }
                Node[] nodes2 = new Node[nonNullNodes.size()];
                nonNullNodes.toArray(nodes2);
                Mutex.EVENT.writeAccess(new Runnable(this, a, nodes2){
                    private final /* synthetic */ CookieAction val$a;
                    private final /* synthetic */ Node[] val$nodes2;
                    private final /* synthetic */ CookiesChangeListener this$0;
                    {
                        this.this$0 = this$0;
                        this.val$a = val$a;
                        this.val$nodes2 = val$nodes2;
                    }

                    public void run() {
                        this.val$a.setEnabled(this.val$a.enable(this.val$nodes2));
                    }
                });
            }
        }
    }
}

